"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service dbqms
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_databasequerymetadataservice.html
 */
class Dbqms extends shared_1.PolicyStatement {
    /**
     * Action provider for service dbqms
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_databasequerymetadataservice.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'dbqms';
        this.actions = {
            "CreateFavoriteQuery": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#CreateFavoriteQuery",
                "description": "Creates a new favorite query",
                "accessLevel": "Write"
            },
            "CreateQueryHistory": {
                "url": "",
                "description": "Add a query to the history",
                "accessLevel": "Write"
            },
            "DeleteFavoriteQueries": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteFavoriteQueries",
                "description": "Delete saved queries",
                "accessLevel": "Write"
            },
            "DeleteQueryHistory": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteQueryHistory",
                "description": "Delete a historical query",
                "accessLevel": "Write"
            },
            "DescribeFavoriteQueries": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeFavoriteQueries",
                "description": "List saved queries and associated metadata",
                "accessLevel": "List"
            },
            "DescribeQueryHistory": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeQueryHistory",
                "description": "List history of queries that were run",
                "accessLevel": "List"
            },
            "GetQueryString": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#GetQueryString",
                "description": "Retrieve favorite or history query string by id",
                "accessLevel": "Read"
            },
            "UpdateFavoriteQuery": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateFavoriteQuery",
                "description": "Update saved query and description",
                "accessLevel": "Write"
            },
            "UpdateQueryHistory": {
                "url": "https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateQueryHistory",
                "description": "Update the query history",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Creates a new favorite query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#CreateFavoriteQuery
     */
    createFavoriteQuery() {
        this.add('dbqms:CreateFavoriteQuery');
        return this;
    }
    /**
     * Add a query to the history
     *
     * Access Level: Write
     */
    createQueryHistory() {
        this.add('dbqms:CreateQueryHistory');
        return this;
    }
    /**
     * Delete saved queries
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteFavoriteQueries
     */
    deleteFavoriteQueries() {
        this.add('dbqms:DeleteFavoriteQueries');
        return this;
    }
    /**
     * Delete a historical query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteQueryHistory
     */
    deleteQueryHistory() {
        this.add('dbqms:DeleteQueryHistory');
        return this;
    }
    /**
     * List saved queries and associated metadata
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeFavoriteQueries
     */
    describeFavoriteQueries() {
        this.add('dbqms:DescribeFavoriteQueries');
        return this;
    }
    /**
     * List history of queries that were run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeQueryHistory
     */
    describeQueryHistory() {
        this.add('dbqms:DescribeQueryHistory');
        return this;
    }
    /**
     * Retrieve favorite or history query string by id
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#GetQueryString
     */
    getQueryString() {
        this.add('dbqms:GetQueryString');
        return this;
    }
    /**
     * Update saved query and description
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateFavoriteQuery
     */
    updateFavoriteQuery() {
        this.add('dbqms:UpdateFavoriteQuery');
        return this;
    }
    /**
     * Update the query history
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateQueryHistory
     */
    updateQueryHistory() {
        this.add('dbqms:UpdateQueryHistory');
        return this;
    }
}
exports.Dbqms = Dbqms;
//# sourceMappingURL=data:application/json;base64,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