"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service launchwizard
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_launchwizard.html
 */
class Launchwizard extends shared_1.PolicyStatement {
    /**
     * Action provider for service launchwizard
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_launchwizard.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'launchwizard';
        this.actions = {
            "DeleteApp": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "Delete an application",
                "accessLevel": "Write"
            },
            "DescribeProvisionedApp": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "Describe provisioning applications",
                "accessLevel": "Read"
            },
            "DescribeProvisioningEvents": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "Describe provisioning events",
                "accessLevel": "Read"
            },
            "GetInfrastructureSuggestion": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "Get infrastructure suggestion",
                "accessLevel": "Read"
            },
            "GetIpAddress": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "Get customer's ip address",
                "accessLevel": "Read"
            },
            "GetResourceCostEstimate": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "Get resource cost estimate",
                "accessLevel": "Read"
            },
            "ListProvisionedApps": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "List provisioning applications",
                "accessLevel": "List"
            },
            "StartProvisioning": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "Start a provisioning",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Delete an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    deleteApp() {
        this.add('launchwizard:DeleteApp');
        return this;
    }
    /**
     * Describe provisioning applications
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    describeProvisionedApp() {
        this.add('launchwizard:DescribeProvisionedApp');
        return this;
    }
    /**
     * Describe provisioning events
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    describeProvisioningEvents() {
        this.add('launchwizard:DescribeProvisioningEvents');
        return this;
    }
    /**
     * Get infrastructure suggestion
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    getInfrastructureSuggestion() {
        this.add('launchwizard:GetInfrastructureSuggestion');
        return this;
    }
    /**
     * Get customer's ip address
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    getIpAddress() {
        this.add('launchwizard:GetIpAddress');
        return this;
    }
    /**
     * Get resource cost estimate
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    getResourceCostEstimate() {
        this.add('launchwizard:GetResourceCostEstimate');
        return this;
    }
    /**
     * List provisioning applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    listProvisionedApps() {
        this.add('launchwizard:ListProvisionedApps');
        return this;
    }
    /**
     * Start a provisioning
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    startProvisioning() {
        this.add('launchwizard:StartProvisioning');
        return this;
    }
}
exports.Launchwizard = Launchwizard;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGF1bmNod2l6YXJkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibGF1bmNod2l6YXJkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsc0NBQW9FO0FBR3BFOzs7O0dBSUc7QUFDSCxNQUFhLFlBQWEsU0FBUSx3QkFBZTtJQThDL0M7Ozs7T0FJRztJQUNILFlBQWEsS0FBNEI7UUFDdkMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBbkRSLGtCQUFhLEdBQUcsY0FBYyxDQUFDO1FBQy9CLFlBQU8sR0FBWTtZQUN4QixXQUFXLEVBQUU7Z0JBQ1gsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLHVCQUF1QjtnQkFDdEMsYUFBYSxFQUFFLE9BQU87YUFDdkI7WUFDRCx3QkFBd0IsRUFBRTtnQkFDeEIsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLG9DQUFvQztnQkFDbkQsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCw0QkFBNEIsRUFBRTtnQkFDNUIsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLDhCQUE4QjtnQkFDN0MsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCw2QkFBNkIsRUFBRTtnQkFDN0IsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLCtCQUErQjtnQkFDOUMsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxjQUFjLEVBQUU7Z0JBQ2QsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLDJCQUEyQjtnQkFDMUMsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCx5QkFBeUIsRUFBRTtnQkFDekIsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLDRCQUE0QjtnQkFDM0MsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxxQkFBcUIsRUFBRTtnQkFDckIsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLGdDQUFnQztnQkFDL0MsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxtQkFBbUIsRUFBRTtnQkFDbkIsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLHNCQUFzQjtnQkFDckMsYUFBYSxFQUFFLE9BQU87YUFDdkI7U0FDRixDQUFDO1FBQ0ssa0JBQWEsR0FBa0IsRUFBRSxDQUFDO0lBU3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxTQUFTO1FBQ2QsSUFBSSxDQUFDLEdBQUcsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO1FBQ25DLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsR0FBRyxDQUFDLHFDQUFxQyxDQUFDLENBQUM7UUFDaEQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMEJBQTBCO1FBQy9CLElBQUksQ0FBQyxHQUFHLENBQUMseUNBQXlDLENBQUMsQ0FBQztRQUNwRCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQkFBMkI7UUFDaEMsSUFBSSxDQUFDLEdBQUcsQ0FBQywwQ0FBMEMsQ0FBQyxDQUFDO1FBQ3JELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFlBQVk7UUFDakIsSUFBSSxDQUFDLEdBQUcsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO1FBQ3RDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHVCQUF1QjtRQUM1QixJQUFJLENBQUMsR0FBRyxDQUFDLHNDQUFzQyxDQUFDLENBQUM7UUFDakQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLElBQUksQ0FBQyxHQUFHLENBQUMsa0NBQWtDLENBQUMsQ0FBQztRQUM3QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQzNDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztDQUNGO0FBdEpELG9DQXNKQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjdGlvbnMsIFBvbGljeVN0YXRlbWVudCwgUmVzb3VyY2VUeXBlcyB9IGZyb20gXCIuLi9zaGFyZWRcIjtcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudFByb3BzIH0gZnJvbSBcIkBhd3MtY2RrL2F3cy1pYW1cIjtcblxuLyoqXG4gKiBBY3Rpb24gcHJvdmlkZXIgZm9yIHNlcnZpY2UgbGF1bmNod2l6YXJkXG4gKlxuICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL2xpc3RfbGF1bmNod2l6YXJkLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIExhdW5jaHdpemFyZCBleHRlbmRzIFBvbGljeVN0YXRlbWVudCB7XG4gIHB1YmxpYyBzZXJ2aWNlUHJlZml4ID0gJ2xhdW5jaHdpemFyZCc7XG4gIHB1YmxpYyBhY3Rpb25zOiBBY3Rpb25zID0ge1xuICAgIFwiRGVsZXRlQXBwXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xhdW5jaHdpemFyZC9cIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJEZWxldGUgYW4gYXBwbGljYXRpb25cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJXcml0ZVwiXG4gICAgfSxcbiAgICBcIkRlc2NyaWJlUHJvdmlzaW9uZWRBcHBcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGF1bmNod2l6YXJkL1wiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkRlc2NyaWJlIHByb3Zpc2lvbmluZyBhcHBsaWNhdGlvbnNcIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJSZWFkXCJcbiAgICB9LFxuICAgIFwiRGVzY3JpYmVQcm92aXNpb25pbmdFdmVudHNcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGF1bmNod2l6YXJkL1wiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkRlc2NyaWJlIHByb3Zpc2lvbmluZyBldmVudHNcIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJSZWFkXCJcbiAgICB9LFxuICAgIFwiR2V0SW5mcmFzdHJ1Y3R1cmVTdWdnZXN0aW9uXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xhdW5jaHdpemFyZC9cIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJHZXQgaW5mcmFzdHJ1Y3R1cmUgc3VnZ2VzdGlvblwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIlJlYWRcIlxuICAgIH0sXG4gICAgXCJHZXRJcEFkZHJlc3NcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGF1bmNod2l6YXJkL1wiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkdldCBjdXN0b21lcidzIGlwIGFkZHJlc3NcIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJSZWFkXCJcbiAgICB9LFxuICAgIFwiR2V0UmVzb3VyY2VDb3N0RXN0aW1hdGVcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGF1bmNod2l6YXJkL1wiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkdldCByZXNvdXJjZSBjb3N0IGVzdGltYXRlXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiUmVhZFwiXG4gICAgfSxcbiAgICBcIkxpc3RQcm92aXNpb25lZEFwcHNcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGF1bmNod2l6YXJkL1wiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkxpc3QgcHJvdmlzaW9uaW5nIGFwcGxpY2F0aW9uc1wiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIkxpc3RcIlxuICAgIH0sXG4gICAgXCJTdGFydFByb3Zpc2lvbmluZ1wiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYXVuY2h3aXphcmQvXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiU3RhcnQgYSBwcm92aXNpb25pbmdcIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJXcml0ZVwiXG4gICAgfVxuICB9O1xuICBwdWJsaWMgcmVzb3VyY2VUeXBlczogUmVzb3VyY2VUeXBlcyA9IHt9O1xuXG4gIC8qKlxuICAgKiBBY3Rpb24gcHJvdmlkZXIgZm9yIHNlcnZpY2UgbGF1bmNod2l6YXJkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9saXN0X2xhdW5jaHdpemFyZC5odG1sXG4gICAqL1xuICBjb25zdHJ1Y3RvciAocHJvcHM/OiBQb2xpY3lTdGF0ZW1lbnRQcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWxldGUgYW4gYXBwbGljYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGF1bmNod2l6YXJkL1xuICAgKi9cbiAgcHVibGljIGRlbGV0ZUFwcCgpIHtcbiAgICB0aGlzLmFkZCgnbGF1bmNod2l6YXJkOkRlbGV0ZUFwcCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlc2NyaWJlIHByb3Zpc2lvbmluZyBhcHBsaWNhdGlvbnNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYXVuY2h3aXphcmQvXG4gICAqL1xuICBwdWJsaWMgZGVzY3JpYmVQcm92aXNpb25lZEFwcCgpIHtcbiAgICB0aGlzLmFkZCgnbGF1bmNod2l6YXJkOkRlc2NyaWJlUHJvdmlzaW9uZWRBcHAnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBEZXNjcmliZSBwcm92aXNpb25pbmcgZXZlbnRzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGF1bmNod2l6YXJkL1xuICAgKi9cbiAgcHVibGljIGRlc2NyaWJlUHJvdmlzaW9uaW5nRXZlbnRzKCkge1xuICAgIHRoaXMuYWRkKCdsYXVuY2h3aXphcmQ6RGVzY3JpYmVQcm92aXNpb25pbmdFdmVudHMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXQgaW5mcmFzdHJ1Y3R1cmUgc3VnZ2VzdGlvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xhdW5jaHdpemFyZC9cbiAgICovXG4gIHB1YmxpYyBnZXRJbmZyYXN0cnVjdHVyZVN1Z2dlc3Rpb24oKSB7XG4gICAgdGhpcy5hZGQoJ2xhdW5jaHdpemFyZDpHZXRJbmZyYXN0cnVjdHVyZVN1Z2dlc3Rpb24nKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXQgY3VzdG9tZXIncyBpcCBhZGRyZXNzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGF1bmNod2l6YXJkL1xuICAgKi9cbiAgcHVibGljIGdldElwQWRkcmVzcygpIHtcbiAgICB0aGlzLmFkZCgnbGF1bmNod2l6YXJkOkdldElwQWRkcmVzcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldCByZXNvdXJjZSBjb3N0IGVzdGltYXRlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGF1bmNod2l6YXJkL1xuICAgKi9cbiAgcHVibGljIGdldFJlc291cmNlQ29zdEVzdGltYXRlKCkge1xuICAgIHRoaXMuYWRkKCdsYXVuY2h3aXphcmQ6R2V0UmVzb3VyY2VDb3N0RXN0aW1hdGUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0IHByb3Zpc2lvbmluZyBhcHBsaWNhdGlvbnNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYXVuY2h3aXphcmQvXG4gICAqL1xuICBwdWJsaWMgbGlzdFByb3Zpc2lvbmVkQXBwcygpIHtcbiAgICB0aGlzLmFkZCgnbGF1bmNod2l6YXJkOkxpc3RQcm92aXNpb25lZEFwcHMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBTdGFydCBhIHByb3Zpc2lvbmluZ1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYXVuY2h3aXphcmQvXG4gICAqL1xuICBwdWJsaWMgc3RhcnRQcm92aXNpb25pbmcoKSB7XG4gICAgdGhpcy5hZGQoJ2xhdW5jaHdpemFyZDpTdGFydFByb3Zpc2lvbmluZycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG59XG4iXX0=