import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service apigateway
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_manageamazonapigateway.html
 */
export declare class Apigateway extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service apigateway
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_manageamazonapigateway.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Used to delete resources
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/API_DELETE.html
     */
    dELETE(): this;
    /**
     * Used to get information about resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/API_GET.html
     */
    gET(): this;
    /**
     * Used to update resources
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/API_PATCH.html
     */
    pATCH(): this;
    /**
     * Used to create child resources
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/API_POST.html
     */
    pOST(): this;
    /**
     * Used to update resources (and, although not recommended, can be used to create child resources)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/API_PUT.html
     */
    pUT(): this;
    /**
     * Gives WebAcl permissions to WAF
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/WEBACL_SET.html
     */
    setWebACL(): this;
    /**
     * Used to update the Resource Policy for a given API
     *
     * Access Level: Write
     */
    updateRestApiPolicy(): this;
    /**
     * Adds a resource of type apigateway-general to the statement
     *
     * https://docs.aws.amazon.com/apigateway/latest/developerguide/permissions.html
     *
     * @param apiGatewayResourcePath - Identifier for the apiGatewayResourcePath.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onApigatewayGeneral(apiGatewayResourcePath: string, region?: string, partition?: string): this;
}
