"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readRootPackageJson = void 0;
const path_1 = require("nx/src/utils/path");
const fileutils_1 = require("nx/src/utils/fileutils");
const workspace_root_1 = require("nx/src/utils/workspace-root");
const fs_1 = require("fs");
function readRootPackageJson() {
    const pkgJsonPath = (0, path_1.joinPathFragments)(workspace_root_1.workspaceRoot, 'package.json');
    if (!(0, fs_1.existsSync)(pkgJsonPath)) {
        throw new Error('NX MF: Could not find root package.json to determine dependency versions.');
    }
    return (0, fileutils_1.readJsonFile)(pkgJsonPath);
}
exports.readRootPackageJson = readRootPackageJson;
//# sourceMappingURL=package-json.js.map