import pytest

from dzcb import k7abd
from dzcb import repeaterbook

TEST_ZONE = "Test Zone Name"

R1 = (
    {
        "State ID": "41",
        "Rptr ID": "26",
        "Frequency": "146.94000",
        "Input Freq": "146.34000",
        "PL": "CSQ",
        "TSQ": "",
        "Nearest City": "Clackamas",
        "Landmark": "Mt Scott",
        "County": "Clackamas",
        "State": "Oregon",
        "Country": "United States",
        "Lat": "45.45479965",
        "Long": "-122.55100250",
        "Precise": "1",
        "Callsign": "W7LT",
        "Use": "OPEN",
        "Operational Status": "On-air",
        "ARES": "No",
        "RACES": "No",
        "SKYWARN": "No",
        "CANWARN": "No",
        "AllStar Node": "",
        "EchoLink Node": "",
        "IRLP Node": "",
        "Wires Node": "",
        "FM Analog": "Yes",
        "DMR": "No",
        "DMR Color Code": "",
        "DMR ID": "",
        "D-Star": "No",
        "NXDN": "No",
        "APCO P-25": "No",
        "P-25 NAC": "",
        "Tetra": "No",
        "Tetra MCC": "",
        "Tetra MNC": "",
        "System Fusion": "No",
        "YSF DG ID Uplink": "",
        "YSF DG IS Downlink": "",
        "YSF DSC": "",
        "Last Update": "2021-01-16",
        "Trustee": "",
    },
    {
        k7abd.ZONE: TEST_ZONE,
        k7abd.CHANNEL_NAME: "W7LT Clackamas Mt Scott",
        k7abd.BANDWIDTH: "25K",
        k7abd.POWER: "High",
        k7abd.RX_FREQ: "146.94000",
        k7abd.TX_FREQ: "146.34000",
        k7abd.CTCSS_DECODE: k7abd.OFF,
        k7abd.CTCSS_ENCODE: k7abd.OFF,
        k7abd.TX_PROHIBIT: k7abd.OFF,
    },
)

R2 = (
    {
        "State ID": "41",
        "Rptr ID": "15196",
        "Frequency": "442.75000",
        "Input Freq": "447.75000",
        "PL": "Restricted",
        "TSQ": "Restricted",
        "Nearest City": "Colton",
        "Landmark": "Goat Mtn",
        "County": "Clackamas",
        "State": "Oregon",
        "Country": "United States",
        "Lat": "45.13150024",
        "Long": "-122.29699707",
        "Precise": "0",
        "Callsign": "KB7APU",
        "Use": "OPEN",
        "Operational Status": "On-air",
        "ARES": "No",
        "RACES": "No",
        "SKYWARN": "No",
        "CANWARN": "No",
        "AllStar Node": "",
        "EchoLink Node": "",
        "IRLP Node": "",
        "Wires Node": "",
        "FM Analog": "No",
        "DMR": "Yes",
        "DMR Color Code": "1",
        "DMR ID": "314107",
        "D-Star": "No",
        "NXDN": "No",
        "APCO P-25": "No",
        "P-25 NAC": "",
        "Tetra": "No",
        "Tetra MCC": "",
        "Tetra MNC": "",
        "System Fusion": "No",
        "YSF DG ID Uplink": "",
        "YSF DG IS Downlink": "",
        "YSF DSC": "",
        "Last Update": "2020-03-16",
        "Trustee": "KB7APU",
    },
    {
        k7abd.ZONE: TEST_ZONE,
        k7abd.CHANNEL_NAME: "KB7APU Colton Goat Mtn",
        k7abd.BANDWIDTH: "25K",
        k7abd.POWER: "High",
        k7abd.RX_FREQ: "442.75000",
        k7abd.TX_FREQ: "447.75000",
        k7abd.CTCSS_DECODE: "Restricted",
        k7abd.CTCSS_ENCODE: "Restricted",
        k7abd.TX_PROHIBIT: k7abd.OFF,
    },
)

R3 = (
    {
        "State ID": "41",
        "Rptr ID": "15421",
        "Frequency": "145.39000",
        "Input Freq": "144.79000",
        "PL": "D025",
        "TSQ": "D025",
        "Nearest City": "Cottage Grove",
        "Landmark": "Bear Mtn",
        "County": "Lane",
        "State": "Oregon",
        "Country": "United States",
        "Lat": "43.84299850",
        "Long": "-122.89199829",
        "Precise": "0",
        "Callsign": "AB7BS",
        "Use": "OPEN",
        "Operational Status": "On-air",
        "ARES": "No",
        "RACES": "No",
        "SKYWARN": "No",
        "CANWARN": "No",
        "AllStar Node": "0",
        "EchoLink Node": "521741",
        "IRLP Node": "0",
        "Wires Node": "",
        "FM Analog": "Yes",
        "DMR": "No",
        "DMR Color Code": "",
        "DMR ID": "",
        "D-Star": "No",
        "NXDN": "No",
        "APCO P-25": "No",
        "P-25 NAC": "",
        "Tetra": "No",
        "Tetra MCC": "",
        "Tetra MNC": "",
        "System Fusion": "No",
        "YSF DG ID Uplink": "",
        "YSF DG IS Downlink": "",
        "YSF DSC": "",
        "Last Update": "2020-10-09",
        "Trustee": "",
    },
    {
        k7abd.ZONE: TEST_ZONE,
        k7abd.CHANNEL_NAME: "AB7BS Cottage Grove Bear Mtn",
        k7abd.BANDWIDTH: "25K",
        k7abd.POWER: "High",
        k7abd.RX_FREQ: "145.39000",
        k7abd.TX_FREQ: "144.79000",
        k7abd.CTCSS_DECODE: "D025",
        k7abd.CTCSS_ENCODE: "D025",
        k7abd.TX_PROHIBIT: k7abd.OFF,
    },
)

R4 = (
    {
        "State ID": "41",
        "Rptr ID": "15803",
        "Frequency": "147.14000",
        "Input Freq": "147.74000",
        "PL": "136.5",
        "TSQ": "91.5",
        "Nearest City": "Mapleton",
        "Landmark": "Roman Nose Mountain",
        "County": "Lane",
        "State": "Oregon",
        "Country": "United States",
        "Lat": "43.91189957",
        "Long": "-123.73899841",
        "Precise": "1",
        "Callsign": "AB7BS",
        "Use": "OPEN",
        "Operational Status": "On-air",
        "ARES": "No",
        "RACES": "No",
        "SKYWARN": "No",
        "CANWARN": "No",
        "AllStar Node": "0",
        "EchoLink Node": "",
        "IRLP Node": "0",
        "Wires Node": "",
        "FM Analog": "Yes",
        "DMR": "No",
        "DMR Color Code": "",
        "DMR ID": "",
        "D-Star": "No",
        "NXDN": "No",
        "APCO P-25": "No",
        "P-25 NAC": "",
        "Tetra": "No",
        "Tetra MCC": "",
        "Tetra MNC": "",
        "System Fusion": "No",
        "YSF DG ID Uplink": "",
        "YSF DG IS Downlink": "",
        "YSF DSC": "",
        "Last Update": "2020-05-12",
        "Trustee": "",
    },
    {
        k7abd.ZONE: TEST_ZONE,
        k7abd.CHANNEL_NAME: "AB7BS Mapleton Roman Nose Mountain",
        k7abd.BANDWIDTH: "25K",
        k7abd.POWER: "High",
        k7abd.RX_FREQ: "147.14000",
        k7abd.TX_FREQ: "147.74000",
        k7abd.CTCSS_DECODE: "91.5",
        k7abd.CTCSS_ENCODE: "136.5",
        k7abd.TX_PROHIBIT: k7abd.OFF,
    },
)


@pytest.mark.parametrize(
    "repeater,k7abd_row",
    (
        pytest.param(*R1, id="CSQ"),
        pytest.param(*R2, id="Restricted"),
        pytest.param(*R3, id="DCS"),
        pytest.param(*R4, id="split-tone"),
    ),
)
def test_repeater_to_k7abd_row(repeater, k7abd_row):
    assert repeaterbook.repeater_to_k7abd_row(repeater, TEST_ZONE) == k7abd_row
