# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IAttributeSearchProperties(Model):
    """Represents seachable attribute properties.

    :param is_searchable: Gets a value indicating whether the attribute
     supports full text search.
    :type is_searchable: bool
    :param is_filterable: Gets a value indicating whether the attribute
     supports filtering.
    :type is_filterable: bool
    :param is_facetable: Gets a value indicating whether the attribute can be
     included as facet results.
    :type is_facetable: bool
    :param is_sortable: Gets a value indicating whether the attribute can be
     included in orderby directives.
    :type is_sortable: bool
    :param facet_specification: Gets an optional specification for search
     faceting used at query time (advanced).
     this is the part behind the comma in the examples below.
     bucket facet: "price,interval:10"
     other type: "listPrice,values:10|25|100|500|1000|2500"
     value facet: city,count:5
    :type facet_specification: str
    """

    _attribute_map = {
        'is_searchable': {'key': 'isSearchable', 'type': 'bool'},
        'is_filterable': {'key': 'isFilterable', 'type': 'bool'},
        'is_facetable': {'key': 'isFacetable', 'type': 'bool'},
        'is_sortable': {'key': 'isSortable', 'type': 'bool'},
        'facet_specification': {'key': 'facetSpecification', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IAttributeSearchProperties, self).__init__(**kwargs)
        self.is_searchable = kwargs.get('is_searchable', None)
        self.is_filterable = kwargs.get('is_filterable', None)
        self.is_facetable = kwargs.get('is_facetable', None)
        self.is_sortable = kwargs.get('is_sortable', None)
        self.facet_specification = kwargs.get('facet_specification', None)
