"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const kinesis = require("@aws-cdk/aws-kinesis");
const lambda = require("@aws-cdk/aws-lambda");
const sqs = require("@aws-cdk/aws-sqs");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
/*
 * Stack verification steps:
 * * aws kinesis put-record --stream-name <value of stack output: InputKinesisStreamName> --partition-key 123 --data testdata
 * * aws sqs receive-message --queue-url <value of stack output: DlqSqsQueueUrl> --max-number-of-messages 1 --query 'Messages[0].Body'
 * The last command should return a string that contains the Lambda function ARN in it.
 */
async function handler(event) {
    // tslint:disable-next-line:no-console
    console.log('event:', JSON.stringify(event, undefined, 2));
    throw new Error();
}
class KinesisWithDLQTest extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        const fn = new lambda.Function(this, 'F', {
            runtime: lambda.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: lambda.Code.fromInline(`exports.handler = ${handler.toString()}`)
        });
        new core_1.CfnOutput(this, 'FunctionArn', { value: fn.functionArn });
        const stream = new kinesis.Stream(this, 'S');
        new core_1.CfnOutput(this, 'InputKinesisStreamName', { value: stream.streamName });
        const dlq = new sqs.Queue(this, 'Q');
        new core_1.CfnOutput(this, 'DlqSqsQueueUrl', { value: dlq.queueUrl });
        fn.addEventSource(new lib_1.KinesisEventSource(stream, {
            startingPosition: lambda.StartingPosition.TRIM_HORIZON,
            onFailure: new lib_1.SqsDlq(dlq),
            retryAttempts: 0,
        }));
    }
}
const app = new core_1.App();
new KinesisWithDLQTest(app, 'lambda-event-source-kinesis-with-dlq');
app.synth();
//# sourceMappingURL=data:application/json;base64,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