import traceback
from typing import Callable, Generic, NoReturn, Optional, TypeVar

import qcore.helpers as core_helpers
import qcore.events as core_events
import qcore.errors as core_errors

from . import debug
from . import _debug

_T = TypeVar("_T")

class FutureIsAlreadyComputed(Exception): ...

class FutureBase(Generic[_T]):
    def __init__(self) -> None: ...
    def value(self) -> _T: ...
    def set_value(self, value: _T) -> None: ...
    def reset_unsafe(self) -> None: ...
    def error(self) -> Optional[BaseException]: ...
    def set_error(self, error: BaseException) -> None: ...
    def is_computed(self) -> bool: ...
    def raise_if_error(self) -> None: ...
    def __call__(self) -> _T: ...
    def dump(self, indent: int = ...) -> None: ...

class Future(FutureBase[_T]):
    def __init__(self, value_provider: Callable[..., _T]) -> None: ...

class ConstFuture(FutureBase[_T]):
    def __init__(self, value: _T) -> None: ...

none_future: ConstFuture[None]

class ErrorFuture(FutureBase[NoReturn]):
    def __init__(self, error: BaseException) -> None: ...
