import threading
from typing import Any, Optional

from . import futures
from .async_task import AsyncTask

class AsyncTaskError(Exception): ...

class TaskScheduler(object):
    def __init__(self) -> None: ...
    def reset(self) -> None: ...
    def wait_for(self, task: futures.FutureBase[Any]) -> None: ...
    def dump(self, indent: int = ...) -> None: ...
    def try_time_based_dump(self, last_task: Any = ...) -> None: ...

class LocalTaskSchedulerState(threading.local):
    def reset(self) -> None: ...

def get_scheduler() -> TaskScheduler: ...
def reset() -> None: ...
def get_active_task() -> Optional[futures.FutureBase]: ...
