# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2015-12-09 07:55
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import jsonfield.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('actor_object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('actor_text', models.CharField(blank=True, max_length=50, null=True)),
                ('actor_url_text', models.URLField(blank=True, null=True)),
                ('verb', models.CharField(max_length=50)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('nf_type', models.CharField(default='default', max_length=20)),
                ('target_object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('target_text', models.CharField(blank=True, max_length=50, null=True)),
                ('target_url_text', models.URLField(blank=True, null=True)),
                ('obj_object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('obj_text', models.CharField(blank=True, max_length=50, null=True)),
                ('obj_url_text', models.URLField(blank=True, null=True)),
                ('extra', jsonfield.fields.JSONField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('read', models.BooleanField(default=False)),
                ('deleted', models.BooleanField(default=False)),
                ('actor_content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='notify_actor', to='contenttypes.ContentType')),
                ('obj_content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='notify_object', to='contenttypes.ContentType')),
                ('recipient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notifications', to=settings.AUTH_USER_MODEL)),
                ('target_content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='notify_target', to='contenttypes.ContentType')),
            ],
            options={
                'ordering': ('-created',),
            },
        ),
    ]
