"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RawEndpoint = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Untyped endpoint implementation
 *
 * Prefer using the classes in the `aws-globalaccelerator-endpoints` package instead,
 * as they accept typed constructs. You can use this class if you want to use an
 * endpoint type that does not have an appropriate class in that package yet.
 */
class RawEndpoint {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_globalaccelerator_RawEndpointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.region = props.region;
    }
    renderEndpointConfiguration() {
        return {
            endpointId: this.props.endpointId,
            weight: this.props.weight,
            clientIpPreservationEnabled: this.props.preserveClientIp,
        };
    }
}
exports.RawEndpoint = RawEndpoint;
_a = JSII_RTTI_SYMBOL_1;
RawEndpoint[_a] = { fqn: "@aws-cdk/aws-globalaccelerator.RawEndpoint", version: "1.156.0" };
//# sourceMappingURL=data:application/json;base64,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