"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Listener = exports.ClientAffinity = exports.ConnectionProtocol = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const endpoint_group_1 = require("./endpoint-group");
const ga = require("./globalaccelerator.generated");
/**
 * The protocol for the connections from clients to the accelerator.
 */
var ConnectionProtocol;
(function (ConnectionProtocol) {
    /**
     * TCP
     */
    ConnectionProtocol["TCP"] = "TCP";
    /**
     * UDP
     */
    ConnectionProtocol["UDP"] = "UDP";
})(ConnectionProtocol = exports.ConnectionProtocol || (exports.ConnectionProtocol = {}));
/**
 * Client affinity gives you control over whether to always route each client to the same specific endpoint.
 *
 * @see https://docs.aws.amazon.com/global-accelerator/latest/dg/about-listeners.html#about-listeners-client-affinity
 */
var ClientAffinity;
(function (ClientAffinity) {
    /**
     * Route traffic based on the 5-tuple `(source IP, source port, destination IP, destination port, protocol)`
     */
    ClientAffinity["NONE"] = "NONE";
    /**
     * Route traffic based on the 2-tuple `(source IP, destination IP)`
     *
     * The result is that multiple connections from the same client will be routed the same.
     */
    ClientAffinity["SOURCE_IP"] = "SOURCE_IP";
})(ClientAffinity = exports.ClientAffinity || (exports.ClientAffinity = {}));
/**
 * The construct for the Listener
 */
class Listener extends cdk.Resource {
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_globalaccelerator_ListenerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const resource = new ga.CfnListener(this, 'Resource', {
            acceleratorArn: props.accelerator.acceleratorArn,
            portRanges: props.portRanges.map(m => {
                var _b;
                return ({
                    fromPort: m.fromPort,
                    toPort: (_b = m.toPort) !== null && _b !== void 0 ? _b : m.fromPort,
                });
            }),
            protocol: (_b = props.protocol) !== null && _b !== void 0 ? _b : ConnectionProtocol.TCP,
            clientAffinity: (_c = props.clientAffinity) !== null && _c !== void 0 ? _c : ClientAffinity.NONE,
        });
        this.listenerArn = resource.attrListenerArn;
        this.listenerName = (_d = props.listenerName) !== null && _d !== void 0 ? _d : resource.logicalId;
    }
    /**
     * import from ARN
     */
    static fromListenerArn(scope, id, listenerArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.listenerArn = listenerArn;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Add a new endpoint group to this listener
     */
    addEndpointGroup(id, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_globalaccelerator_EndpointGroupOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addEndpointGroup);
            }
            throw error;
        }
        return new endpoint_group_1.EndpointGroup(this, id, {
            listener: this,
            ...options,
        });
    }
}
exports.Listener = Listener;
_a = JSII_RTTI_SYMBOL_1;
Listener[_a] = { fqn: "@aws-cdk/aws-globalaccelerator.Listener", version: "1.156.0" };
//# sourceMappingURL=data:application/json;base64,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