# coding: utf-8


"""
IGNORE:
    Nutanix Iam Versioned APIs

    Identity and Access Management in Nutanix cluster.  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_iam_py_client.Ntnx.common.v1.config.KVPair import KVPair  # noqa: F401,E501
from ntnx_iam_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_iam_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_iam_py_client.Ntnx.iam.v4.authn.UserStatusType import UserStatusType  # noqa: F401,E501
from ntnx_iam_py_client.Ntnx.iam.v4.authn.UserType import UserType  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class User(ExternalizableAbstractModel):
    """User - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'username': 'str',
        'user_type': 'iam.v4.authn.UserType',
        'idp_id': 'str',
        'display_name': 'str',
        'first_name': 'str',
        'middle_initial': 'str',
        'last_name': 'str',
        'email_id': 'str',
        'locale': 'str',
        'region': 'str',
        'password': 'str',
        'force_reset_password': 'bool',
        'additional_attributes': 'list[common.v1.config.KVPair]',
        'status': 'iam.v4.authn.UserStatusType',
        'last_login_time': 'datetime',
        'created_time': 'datetime',
        'last_updated_time': 'datetime',
        'created_by': 'str',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'username': 'username',
        'user_type': 'userType',
        'idp_id': 'idpId',
        'display_name': 'displayName',
        'first_name': 'firstName',
        'middle_initial': 'middleInitial',
        'last_name': 'lastName',
        'email_id': 'emailId',
        'locale': 'locale',
        'region': 'region',
        'password': 'password',
        'force_reset_password': 'forceResetPassword',
        'additional_attributes': 'additionalAttributes',
        'status': 'status',
        'last_login_time': 'lastLoginTime',
        'created_time': 'createdTime',
        'last_updated_time': 'lastUpdatedTime',
        'created_by': 'createdBy',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, username=None, user_type=None, idp_id=None, display_name=None, first_name=None, middle_initial=None, last_name=None, email_id=None, locale=None, region=None, password=None, force_reset_password=None, additional_attributes=None, status=None, last_login_time=None, created_time=None, last_updated_time=None, created_by=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """User - a model defined in Swagger
            \nInformation of the user
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__username = None
        self.__user_type = None
        self.__idp_id = None
        self.__display_name = None
        self.__first_name = None
        self.__middle_initial = None
        self.__last_name = None
        self.__email_id = None
        self.__locale = None
        self.__region = None
        self.__password = None
        self.__force_reset_password = None
        self.__additional_attributes = None
        self.__status = None
        self.__last_login_time = None
        self.__created_time = None
        self.__last_updated_time = None
        self.__created_by = None
        self.discriminator = None
        self.__username = username
        self.__user_type = user_type
        if idp_id is not None:
            self.__idp_id = idp_id
        if display_name is not None:
            self.__display_name = display_name
        if first_name is not None:
            self.__first_name = first_name
        if middle_initial is not None:
            self.__middle_initial = middle_initial
        if last_name is not None:
            self.__last_name = last_name
        if email_id is not None:
            self.__email_id = email_id
        if locale is not None:
            self.__locale = locale
        if region is not None:
            self.__region = region
        if password is not None:
            self.__password = password
        if force_reset_password is not None:
            self.__force_reset_password = force_reset_password
        if additional_attributes is not None:
            self.__additional_attributes = additional_attributes
        if status is not None:
            self.__status = status
        if last_login_time is not None:
            self.__last_login_time = last_login_time
        if created_time is not None:
            self.__created_time = created_time
        if last_updated_time is not None:
            self.__last_updated_time = last_updated_time
        if created_by is not None:
            self.__created_by = created_by

    def _initialize_object_type(self):
        return 'iam.v4.authn.User'

    def _initialize_fq_object_type(self):
        return 'iam.v4.r0.a1.authn.User'


    @property
    def username(self):
        """`{ str }`
            \nIdentifier for the user in the form an email address
        """ # noqa: E501
        return self.__username

    @username.setter
    def username(self, username):
        if username is None:
            raise ValueError("Invalid value for `username`, must not be `None`")  # noqa: E501
        if username is not None and len(username) > 255:
            raise ValueError("Invalid value for `username`, length must be less than or equal to `255`")  # noqa: E501
        if username is not None and len(username) < 1:
            raise ValueError("Invalid value for `username`, length must be greater than or equal to `1`")  # noqa: E501

        self.__username = username

    @property
    def user_type(self):
        """`{ iam.v4.authn.UserType }`
            
        """ # noqa: E501
        return self.__user_type

    @user_type.setter
    def user_type(self, user_type):
        if user_type is None:
            raise ValueError("Invalid value for `user_type`, must not be `None`")  # noqa: E501

        self.__user_type = user_type

    @property
    def idp_id(self):
        """`{ str }`
            \nIdentifier of the IDP for the user
        """ # noqa: E501
        return self.__idp_id

    @idp_id.setter
    def idp_id(self, idp_id):
        if idp_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', idp_id):  # noqa: E501
            raise ValueError(r"Invalid value for `idp_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__idp_id = idp_id

    @property
    def display_name(self):
        """`{ str }`
            \nDisplay name for the user
        """ # noqa: E501
        return self.__display_name

    @display_name.setter
    def display_name(self, display_name):
        if display_name is not None and len(display_name) > 255:
            raise ValueError("Invalid value for `display_name`, length must be less than or equal to `255`")  # noqa: E501

        self.__display_name = display_name

    @property
    def first_name(self):
        """`{ str }`
            \nFirst name for the user
        """ # noqa: E501
        return self.__first_name

    @first_name.setter
    def first_name(self, first_name):
        if first_name is not None and len(first_name) > 255:
            raise ValueError("Invalid value for `first_name`, length must be less than or equal to `255`")  # noqa: E501

        self.__first_name = first_name

    @property
    def middle_initial(self):
        """`{ str }`
            \nMiddle name for the user
        """ # noqa: E501
        return self.__middle_initial

    @middle_initial.setter
    def middle_initial(self, middle_initial):
        if middle_initial is not None and len(middle_initial) > 255:
            raise ValueError("Invalid value for `middle_initial`, length must be less than or equal to `255`")  # noqa: E501

        self.__middle_initial = middle_initial

    @property
    def last_name(self):
        """`{ str }`
            \nLast name for the user
        """ # noqa: E501
        return self.__last_name

    @last_name.setter
    def last_name(self, last_name):
        if last_name is not None and len(last_name) > 255:
            raise ValueError("Invalid value for `last_name`, length must be less than or equal to `255`")  # noqa: E501

        self.__last_name = last_name

    @property
    def email_id(self):
        """`{ str }`
            \nEmail Id for the user
        """ # noqa: E501
        return self.__email_id

    @email_id.setter
    def email_id(self, email_id):
        if email_id is not None and len(email_id) > 255:
            raise ValueError("Invalid value for `email_id`, length must be less than or equal to `255`")  # noqa: E501

        self.__email_id = email_id

    @property
    def locale(self):
        """`{ str }`
            \nDefault locale for the user
        """ # noqa: E501
        return self.__locale

    @locale.setter
    def locale(self, locale):

        self.__locale = locale

    @property
    def region(self):
        """`{ str }`
            \nDefault region for the user
        """ # noqa: E501
        return self.__region

    @region.setter
    def region(self, region):

        self.__region = region

    @property
    def password(self):
        """`{ str }`
            \nPassword for the user
        """ # noqa: E501
        return self.__password

    @password.setter
    def password(self, password):

        self.__password = password

    @property
    def force_reset_password(self):
        """`{ bool }`
            \nFlag to force the user to reset password
        """ # noqa: E501
        return self.__force_reset_password

    @force_reset_password.setter
    def force_reset_password(self, force_reset_password):

        self.__force_reset_password = force_reset_password

    @property
    def additional_attributes(self):
        """`{ list[common.v1.config.KVPair] }`
            \nAny additional attribute for the user
        """ # noqa: E501
        return self.__additional_attributes

    @additional_attributes.setter
    def additional_attributes(self, additional_attributes):

        self.__additional_attributes = additional_attributes

    @property
    def status(self):
        """`{ iam.v4.authn.UserStatusType }`
            
        """ # noqa: E501
        return self.__status

    @status.setter
    def status(self, status):

        self.__status = status

    @property
    def last_login_time(self):
        """`{ datetime }`
            \nLast successful logged in time for the user
        """ # noqa: E501
        return self.__last_login_time

    @last_login_time.setter
    def last_login_time(self, last_login_time):

        self.__last_login_time = last_login_time

    @property
    def created_time(self):
        """`{ datetime }`
            \nCreation time of the user
        """ # noqa: E501
        return self.__created_time

    @created_time.setter
    def created_time(self, created_time):

        self.__created_time = created_time

    @property
    def last_updated_time(self):
        """`{ datetime }`
            \nLast updated time of the user
        """ # noqa: E501
        return self.__last_updated_time

    @last_updated_time.setter
    def last_updated_time(self, last_updated_time):

        self.__last_updated_time = last_updated_time

    @property
    def created_by(self):
        """`{ str }`
            \nUser or service who created the user
        """ # noqa: E501
        return self.__created_by

    @created_by.setter
    def created_by(self, created_by):

        self.__created_by = created_by

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(User, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, User):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

