# coding: utf-8


"""
IGNORE:
    Nutanix Iam Versioned APIs

    Identity and Access Management in Nutanix cluster.  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_iam_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_iam_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class Role(ExternalizableAbstractModel):
    """Role - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'display_name': 'str',
        'description': 'str',
        'client_name': 'str',
        'operations': 'list[str]',
        'accessible_clients': 'list[str]',
        'accessible_object_types': 'list[str]',
        'created_time': 'datetime',
        'last_updated_time': 'datetime',
        'created_by': 'str',
        'is_system_defined': 'bool',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'display_name': 'displayName',
        'description': 'description',
        'client_name': 'clientName',
        'operations': 'operations',
        'accessible_clients': 'accessibleClients',
        'accessible_object_types': 'accessibleObjectTypes',
        'created_time': 'createdTime',
        'last_updated_time': 'lastUpdatedTime',
        'created_by': 'createdBy',
        'is_system_defined': 'isSystemDefined',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, display_name=None, description=None, client_name=None, operations=None, accessible_clients=None, accessible_object_types=None, created_time=None, last_updated_time=None, created_by=None, is_system_defined=True, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """Role - a model defined in Swagger
            \nA role to group the operations and/or sub roles
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__display_name = None
        self.__description = None
        self.__client_name = None
        self.__operations = None
        self.__accessible_clients = None
        self.__accessible_object_types = None
        self.__created_time = None
        self.__last_updated_time = None
        self.__created_by = None
        self.__is_system_defined = None
        self.discriminator = None
        if display_name is not None:
            self.__display_name = display_name
        if description is not None:
            self.__description = description
        if client_name is not None:
            self.__client_name = client_name
        if operations is not None:
            self.__operations = operations
        if accessible_clients is not None:
            self.__accessible_clients = accessible_clients
        if accessible_object_types is not None:
            self.__accessible_object_types = accessible_object_types
        if created_time is not None:
            self.__created_time = created_time
        if last_updated_time is not None:
            self.__last_updated_time = last_updated_time
        if created_by is not None:
            self.__created_by = created_by
        if is_system_defined is not None:
            self.__is_system_defined = is_system_defined

    def _initialize_object_type(self):
        return 'iam.v4.authz.Role'

    def _initialize_fq_object_type(self):
        return 'iam.v4.r0.a1.authz.Role'


    @property
    def display_name(self):
        """`{ str }`
            \nThe display name for the role
        """ # noqa: E501
        return self.__display_name

    @display_name.setter
    def display_name(self, display_name):
        if display_name is not None and len(display_name) > 255:
            raise ValueError("Invalid value for `display_name`, length must be less than or equal to `255`")  # noqa: E501
        if display_name is not None and len(display_name) < 1:
            raise ValueError("Invalid value for `display_name`, length must be greater than or equal to `1`")  # noqa: E501
        if display_name is not None and not re.search('^[^\\\"]*$', display_name):  # noqa: E501
            raise ValueError(r"Invalid value for `display_name`, must be a follow pattern or equal to `/^[^\\\"]*$/`")  # noqa: E501

        self.__display_name = display_name

    @property
    def description(self):
        """`{ str }`
            \nDescription of the role
        """ # noqa: E501
        return self.__description

    @description.setter
    def description(self, description):
        if description is not None and len(description) > 1000:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `1000`")  # noqa: E501

        self.__description = description

    @property
    def client_name(self):
        """`{ str }`
            \nClient that created the role
        """ # noqa: E501
        return self.__client_name

    @client_name.setter
    def client_name(self, client_name):
        if client_name is not None and len(client_name) > 255:
            raise ValueError("Invalid value for `client_name`, length must be less than or equal to `255`")  # noqa: E501

        self.__client_name = client_name

    @property
    def operations(self):
        """`{ list[str] }`
            \nList of operations for the role
        """ # noqa: E501
        return self.__operations

    @operations.setter
    def operations(self, operations):

        self.__operations = operations

    @property
    def accessible_clients(self):
        """`{ list[str] }`
            \nList of accessible clients for the role
        """ # noqa: E501
        return self.__accessible_clients

    @accessible_clients.setter
    def accessible_clients(self, accessible_clients):

        self.__accessible_clients = accessible_clients

    @property
    def accessible_object_types(self):
        """`{ list[str] }`
            \nList of Accessible ObjectTypes for the role
        """ # noqa: E501
        return self.__accessible_object_types

    @accessible_object_types.setter
    def accessible_object_types(self, accessible_object_types):

        self.__accessible_object_types = accessible_object_types

    @property
    def created_time(self):
        """`{ datetime }`
            \nThe creation time of the role
        """ # noqa: E501
        return self.__created_time

    @created_time.setter
    def created_time(self, created_time):

        self.__created_time = created_time

    @property
    def last_updated_time(self):
        """`{ datetime }`
            \nThe time when the role was last updated
        """ # noqa: E501
        return self.__last_updated_time

    @last_updated_time.setter
    def last_updated_time(self, last_updated_time):

        self.__last_updated_time = last_updated_time

    @property
    def created_by(self):
        """`{ str }`
            \nUser or service name that created the role
        """ # noqa: E501
        return self.__created_by

    @created_by.setter
    def created_by(self, created_by):

        self.__created_by = created_by

    @property
    def is_system_defined(self):
        """`{ bool }`
            \nFlag identifying if the role is system defined or not
        """ # noqa: E501
        return self.__is_system_defined

    @is_system_defined.setter
    def is_system_defined(self, is_system_defined):

        self.__is_system_defined = is_system_defined

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(Role, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Role):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

