# coding: utf-8


"""
IGNORE:
    Nutanix Iam Versioned APIs

    Identity and Access Management in Nutanix cluster.  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import copy
import logging
from logging.handlers import TimedRotatingFileHandler
import multiprocessing
import sys
import urllib3

import six
from six.moves import http_client as httplib


class TypeWithDefault(type):
    def __init__(cls, name, bases, dct):
        super(TypeWithDefault, cls).__init__(name, bases, dct)
        cls._default = None

    def __call__(cls):
        if cls._default is None:
            cls._default = type.__call__(cls)
        return copy.copy(cls._default)

    def set_default(cls, default):
        cls._default = copy.copy(default)


class Configuration(six.with_metaclass(TypeWithDefault, object)):
    """Configuration class for Configuration of ApiClient.
    This class contains certain configuration methods and data required by the api client.

    :param host: (default: localhost) Host name to connect which can be either IPv4, IPv6 or FQDN
    :param port: (default: 9440) Port number to connect
    :param max_retry_attempts: (default: 5) Maximum retry attempts to be made in case of status codes [408, 503, 504]
    :param backoff_factor: (default: 3 sec) Backoff factor by which the retry request is delayed with specific number of seconds calculated by the following formula:
        {backoff_factor} * (2 * ({number of retries so far} - 1))
    :param username: Username for HTTP basic authentication
    :param password: Password for HTTP basic authentication
    :param debug: (default: False) Enable/Disable debug logging
    :param logger_file: Log file location
    """ # noqa: E501

    """NOTE: This class is auto generated by the swagger code generator program.
    Ref: https://github.com/swagger-api/swagger-codegen
    Do not edit the class manually.
    """ # noqa: E501

    def __init__(self):

        """Constructor"""
        self.__scheme = "https"

        # Default host name
        self.__host = "localhost"

        # Default port number
        self.__port = 9440

        # Maximum number of allowed retries for a HTTP call
        self.__max_retry_attempts = 5

        # Backoff factor by which the retry request is delayed with specific number of seconds.
        self.__backoff_factor = 3

        self.__user_agent = 'Nutanix-ntnx_iam_py_client/4.0.2a1'

        # Temp file folder for downloading files
        self.temp_folder_path = None

        # Authentication Settings
        # HTTP Basic Auth
        self.__username = None
        self.__password = None

        # API Key authentication (NOTE: SDK currently supports basic auth only)
        # Dictionary to store API key(s)
        self.api_key = {}
        # Dictionary to store API prefix (e.g. Bearer)
        self.api_key_prefix = {}

        # Logging Settings
        self.logger = {}
        self.logger["package_logger"] = logging.getLogger("ntnx_iam_py_client")
        # Log format
        self.logger_format = '%(asctime)s %(levelname)s [%(threadName)s:%(name)s:%(lineno)d] %(message)s'
        # Log stream handler
        self.logger_stream_handler = None
        # Log file handler
        self.logger_file_handler = None
        # Debug file location
        self.logger_file = None

        # Debug switch
        self.__debug = False

        # SSL/TLS verification
        # Set this to false to skip verifying SSL certificate received from the https server when calling API
        self.__verify_ssl = True

        # Set this to customize the certificate file to verify the peer.
        self.ssl_ca_cert = None
        # client certificate file
        self.cert_file = None
        # client key file
        self.key_file = None
        # Set this to True/False to enable/disable SSL hostname verification.
        self.assert_hostname = None

        # urllib3 connection pool's maximum number of connections saved
        # per pool. urllib3 uses 1 connection as default value, but this is
        # not the best value when you are making a lot of possibly parallel
        # requests to the same host, which is often the case here.
        # cpu_count * 5 is used as default value to increase performance.
        self.connection_pool_maxsize = multiprocessing.cpu_count() * 5

        # Proxy Parameters
        self.__proxy_scheme = None
        self.__proxy_host = None
        self.__proxy_port = None
        self.__proxy_username = None
        self.__proxy_password = None

        # Safe chars for path_param
        self.safe_chars_for_path_param = ''

        # Request timeout in milliseconds
        self.__default_connect_timeout = 30000
        self.__default_read_timeout = 30000
        self.__connect_timeout = None
        self.__read_timeout = None

    @property
    def scheme(self):
        """Retrieve current URI scheme for connecting to the cluster (HTTP or HTTPS using SSL/TLS)
        """
        return self.__scheme

    @scheme.setter
    def scheme(self, value):
        """Set URI scheme for connecting to the cluster (HTTP or HTTPS using SSL/TLS)

        :param value: URI scheme for connecting to the cluster (HTTP or HTTPS using SSL/TLS).
        :type: str
        """
        self.__scheme = value

    @property
    def host(self):
        """Host IPv4, IPv6 or FQDN
        """
        return self.__host

    @host.setter
    def host(self, value):
        """Host IPv4/IPv6 or FQDN

        :param value: Host to connect.
        :type: str
        """
        self.__host = value

    @property
    def port(self):
        """Port number
        """
        return self.__port

    @port.setter
    def port(self, value):
        """Port number

        :param value: Port number
        :type: int
        """
        self.__port = value

    @property
    def max_retry_attempts(self):
        """Maximum allowed retry attempts for a HTTP call in case of response status codes [408, 503, 504]
        """
        return self.__max_retry_attempts

    @max_retry_attempts.setter
    def max_retry_attempts(self, value):
        """Maximum allowed retry attempts for a HTTP call in case of response status codes [408, 503, 504]

        :param value: Maximum allowed retry attempts
        :type: int
        """
        self.__max_retry_attempts = value

    @property
    def backoff_factor(self):
        """Backoff factor by which the retry request is delayed with specific number of seconds.
        This is calculated based on the following formula:
        {backoff_factor} * (2 * ({number of retries so far} - 1))
        """
        return self.__backoff_factor

    @backoff_factor.setter
    def backoff_factor(self, value):
        """Backoff factor by which the retry request is delayed with specific number of seconds.
        This is calculated based on the following formula:
        {backoff_factor} * (2 * ({number of retries so far} - 1))

        :param value: Backoff factor
        :type: float
        """
        self.__backoff_factor = value

    @property
    def user_agent(self):
        """Value for User-Agent header.
        """
        return self.__user_agent

    @property
    def username(self):
        """User name for basic authentication
        """
        return self.__username

    @username.setter
    def username(self, value):
        """User name for basic authentication

        :param value: User name
        :type: str
        """
        self.__username = value

    @property
    def password(self):
        """Password for basic authentication
        """
        return self.__password

    @password.setter
    def password(self, value):
        """Password for basic authentication

        :param value: Password
        :type: str
        """
        self.__password = value

    @property
    def verify_ssl(self):
        """Retrieves whether client side SSL verification is enabled or not
        """
        return self.__verify_ssl

    @verify_ssl.setter
    def verify_ssl(self, value):
        """Toggles whether client side SSL verification needs to be enabled or not

        :param value: Verify SSL handshake certificate
        :type bool
        """
        self.__verify_ssl = value

    @property
    def proxy_scheme(self):
        """ Retrieve scheme for the proxy
        """
        return self.__proxy_scheme

    @proxy_scheme.setter
    def proxy_scheme(self, value):
        """ Set value for the scheme for the proxy

        :param value: proxy scheme
        :type str
        """
        self.__proxy_scheme = value

    @property
    def proxy_host(self):
        """ Retrieve host for the proxy
        """
        return self.__proxy_host

    @proxy_host.setter
    def proxy_host(self, value):
        """ Set value for the host for the proxy

        :param value: proxy host
        :type str
        """
        self.__proxy_host = value

    @property
    def proxy_port(self):
        """ Retrieve port for the proxy
        """
        return self.__proxy_port

    @proxy_port.setter
    def proxy_port(self, value):
        """ Set value for the port for the proxy

        :param value: proxy port
        :type int
        """
        self.__proxy_port = value

    @property
    def proxy_username(self):
        """ Retrieve username for the proxy
        """
        return self.__proxy_username

    @proxy_username.setter
    def proxy_username(self, value):
        """ Set value for the username for the proxy

        :param value: proxy username
        :type str
        """
        self.__proxy_username = value

    @property
    def proxy_password(self):
        """ Retrieve password for the proxy
        """
        return self.__proxy_password

    @proxy_password.setter
    def proxy_password(self, value):
        """ Set value for the password for the proxy

        :param value: proxy password
        :type str
        """
        self.__proxy_password = value

    @property
    def logger_file(self):
        """The logger file.

        If the logger_file is None, then add stream handler and remove file
        handler. Otherwise, add file handler and remove stream handler.

        :param value: The logger_file path.
        :type: str
        """
        return self.__logger_file

    @logger_file.setter
    def logger_file(self, value):
        """The logger file.

        If the logger_file is None, then add stream handler and remove file
        handler. Otherwise, add file handler and remove stream handler.

        :param value: The logger_file path.
        :type: str
        """
        self.__logger_file = value
        if self.__logger_file:
            # If set logging file,
            # then add file handler and remove stream handler.
            self.logger_file_handler = logging.handlers.TimedRotatingFileHandler(self.__logger_file, 'midnight', 1)
            self.logger_file_handler.suffix = "%Y-%m-%d"
            self.logger_file_handler.setFormatter(self.logger_formatter)
            for _, logger in six.iteritems(self.logger):
                logger.addHandler(self.logger_file_handler)
                if self.logger_stream_handler:
                    logger.removeHandler(self.logger_stream_handler)
        else:
            # If not set logging file,
            # then add stream handler and remove file handler.
            self.logger_stream_handler = logging.StreamHandler()
            self.logger_stream_handler.setFormatter(self.logger_formatter)
            for _, logger in six.iteritems(self.logger):
                logger.addHandler(self.logger_stream_handler)
                if self.logger_file_handler:
                    logger.removeHandler(self.logger_file_handler)

    @property
    def debug(self):
        """Debug status

        :param value: The debug status, True or False.
        :type: bool
        """
        return self.__debug

    @debug.setter
    def debug(self, value):
        """Debug status

        :param value: The debug status, True or False.
        :type: bool
        """
        self.__debug = value
        if self.__debug:
            # if debug status is True, turn on debug logging
            for _, logger in six.iteritems(self.logger):
                logger.setLevel(logging.DEBUG)
            # turn on httplib debug
            httplib.HTTPConnection.debuglevel = 1
        else:
            # if debug status is False, turn off debug logging,
            # setting log level to default `logging.INFO`
            for _, logger in six.iteritems(self.logger):
                logger.setLevel(logging.INFO)
            # turn off httplib debug
            httplib.HTTPConnection.debuglevel = 0

    @property
    def logger_format(self):
        """The logger format.

        The logger_formatter will be updated when sets logger_format.

        :param value: The format string.
        :type: str
        """
        return self.__logger_format

    @logger_format.setter
    def logger_format(self, value):
        """The logger format.

        The logger_formatter will be updated when sets logger_format.

        :param value: The format string.
        :type: str
        """
        self.__logger_format = value
        self.logger_formatter = logging.Formatter(self.__logger_format)

    @property
    def default_connect_timeout(self):
        """Default connect timeout
        """

        return self.__default_connect_timeout

    @property
    def default_read_timeout(self):
        """Default read timeout
        """

        return self.__default_read_timeout

    @property
    def connect_timeout(self):
        """Connect timeout for an operation in milliseconds
        """

        return self.__connect_timeout

    @connect_timeout.setter
    def connect_timeout(self, value):
        """Connect timeout

        :param value: Time in milliseconds.
        :type: integer
        """

        self.__connect_timeout = value

    @property
    def read_timeout(self):
        """Read timeout for an operation in milliseconds
        """

        return self.__read_timeout

    @read_timeout.setter
    def read_timeout(self, value):
        """Read timeout

        :param value: Time in milliseconds.
        :type: integer
        """

        self.__read_timeout = value

    def get_api_key_with_prefix(self, identifier):
        """Gets API key (with prefix if set).

        :param identifier: The identifier of apiKey.
        :return: The token for api key authentication.
        """
        if (self.api_key.get(identifier) and
                self.api_key_prefix.get(identifier)):
            return self.api_key_prefix[identifier] + ' ' + self.api_key[identifier]  # noqa: E501
        elif self.api_key.get(identifier):
            return self.api_key[identifier]

    def get_basic_auth_token(self):
        """Gets HTTP basic authentication header (string).

        :return: The token for basic HTTP authentication.
        """
        if self.__username and self.__password:
            return urllib3.util.make_headers(
                basic_auth=self.__username + ':' + self.__password
            ).get('authorization')

    def auth_settings(self):
        """Gets Auth Settings dict for api client.

        :return: The Auth Settings information dict.
        """
        return {
            'basicAuthScheme':
                {
                    'type': 'basic',
                    'in': 'header',
                    'key': 'Authorization',
                    'value': self.get_basic_auth_token()
                },
        }

    def to_debug_report(self):
        """Gets the essential information for debugging.

        :return: The report for debugging.
        """
        return "Python SDK Debug Report:\n"\
               "OS: {env}\n"\
               "Python Version: {pyversion}\n"\
               "Version of the API: 4.0.2-alpha-1\n"\
               "SDK Package Version: 4.0.2a1".\
               format(env=sys.platform, pyversion=sys.version)