import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectMilestoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestone#id DataGitlabProjectMilestone#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The instance-wide ID of the project’s milestone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestone#milestone_id DataGitlabProjectMilestone#milestone_id}
    */
    readonly milestoneId: number;
    /**
    * The ID or URL-encoded path of the project owned by the authenticated user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestone#project DataGitlabProjectMilestone#project}
    */
    readonly project: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestone gitlab_project_milestone}
*/
export declare class DataGitlabProjectMilestone extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project_milestone";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestone gitlab_project_milestone} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectMilestoneConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabProjectMilestoneConfig);
    get createdAt(): string;
    get description(): string;
    get dueDate(): string;
    get expired(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get iid(): number;
    private _milestoneId?;
    get milestoneId(): number;
    set milestoneId(value: number);
    get milestoneIdInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get projectId(): number;
    get startDate(): string;
    get state(): string;
    get title(): string;
    get updatedAt(): string;
    get webUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
