import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ReleaseLinkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Relative path for a [Direct Asset link](https://docs.gitlab.com/ee/user/project/releases/index.html#permanent-links-to-release-assets).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/release_link#filepath ReleaseLink#filepath}
    */
    readonly filepath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/release_link#id ReleaseLink#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The type of the link. Valid values are `other`, `runbook`, `image`, `package`. Defaults to other.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/release_link#link_type ReleaseLink#link_type}
    */
    readonly linkType?: string;
    /**
    * The name of the link. Link names must be unique within the release.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/release_link#name ReleaseLink#name}
    */
    readonly name: string;
    /**
    * The ID or [URL-encoded path of the project](https://docs.gitlab.com/ee/api/index.html#namespaced-path-encoding).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/release_link#project ReleaseLink#project}
    */
    readonly project: string;
    /**
    * The tag associated with the Release.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/release_link#tag_name ReleaseLink#tag_name}
    */
    readonly tagName: string;
    /**
    * The URL of the link. Link URLs must be unique within the release.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/release_link#url ReleaseLink#url}
    */
    readonly url: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/release_link gitlab_release_link}
*/
export declare class ReleaseLink extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_release_link";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/release_link gitlab_release_link} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ReleaseLinkConfig
    */
    constructor(scope: Construct, id: string, config: ReleaseLinkConfig);
    get directAssetUrl(): string;
    get external(): cdktf.IResolvable;
    private _filepath?;
    get filepath(): string;
    set filepath(value: string);
    resetFilepath(): void;
    get filepathInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get linkId(): number;
    private _linkType?;
    get linkType(): string;
    set linkType(value: string);
    resetLinkType(): void;
    get linkTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _tagName?;
    get tagName(): string;
    set tagName(value: string);
    get tagNameInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
