<a id="mypy-boto3-codepipeline"></a>

# mypy-boto3-codepipeline

[![PyPI - mypy-boto3-codepipeline](https://img.shields.io/pypi/v/mypy-boto3-codepipeline.svg?color=blue)](https://pypi.org/project/mypy-boto3-codepipeline)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codepipeline.svg?color=blue)](https://pypi.org/project/mypy-boto3-codepipeline)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-codepipeline?color=blue)](https://pypistats.org/packages/mypy-boto3-codepipeline)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.CodePipeline 1.19.1](https://boto3.amazonaws.com/v1/documentation/api/1.19.1/reference/services/codepipeline.html#CodePipeline)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.0.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-codepipeline docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codepipeline/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-codepipeline](#mypy-boto3-codepipeline)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `CodePipeline` service.

```bash
python -m pip install boto3-stubs[codepipeline]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[codepipeline]` in your environment:
  `python -m pip install 'boto3-stubs[codepipeline]'`

Both type checking and auto-complete should work for `CodePipeline` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[codepipeline]` in your environment:
  `python -m pip install 'boto3-stubs[codepipeline]'`

Both type checking and auto-complete should work for `CodePipeline` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[codepipeline]` in your environment:
  `python -m pip install 'boto3-stubs[codepipeline]'`
- Run `mypy` as usual

Type checking should work for `CodePipeline` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[codepipeline]` in your environment:
  `python -m pip install 'boto3-stubs[codepipeline]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CodePipeline` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`CodePipelineClient` provides annotations for `boto3.client("codepipeline")`.

```python
import boto3

from mypy_boto3_codepipeline import CodePipelineClient

client: CodePipelineClient = boto3.client("codepipeline")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CodePipelineClient = session.client("codepipeline")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_codepipeline.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_codepipeline import CodePipelineClient
from mypy_boto3_codepipeline.paginator import (
    ListActionExecutionsPaginator,
    ListActionTypesPaginator,
    ListPipelineExecutionsPaginator,
    ListPipelinesPaginator,
    ListTagsForResourcePaginator,
    ListWebhooksPaginator,
)

client: CodePipelineClient = boto3.client("codepipeline")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_action_executions_paginator: ListActionExecutionsPaginator = client.get_paginator("list_action_executions")
list_action_types_paginator: ListActionTypesPaginator = client.get_paginator("list_action_types")
list_pipeline_executions_paginator: ListPipelineExecutionsPaginator = client.get_paginator("list_pipeline_executions")
list_pipelines_paginator: ListPipelinesPaginator = client.get_paginator("list_pipelines")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
list_webhooks_paginator: ListWebhooksPaginator = client.get_paginator("list_webhooks")
```

<a id="literals"></a>

### Literals

`mypy_boto3_codepipeline.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_codepipeline.literals import (
    ActionCategoryType,
    ActionConfigurationPropertyTypeType,
    ActionExecutionStatusType,
    ActionOwnerType,
    ApprovalStatusType,
    ArtifactLocationTypeType,
    ArtifactStoreTypeType,
    BlockerTypeType,
    EncryptionKeyTypeType,
    ExecutorTypeType,
    FailureTypeType,
    JobStatusType,
    ListActionExecutionsPaginatorName,
    ListActionTypesPaginatorName,
    ListPipelineExecutionsPaginatorName,
    ListPipelinesPaginatorName,
    ListTagsForResourcePaginatorName,
    ListWebhooksPaginatorName,
    PipelineExecutionStatusType,
    StageExecutionStatusType,
    StageRetryModeType,
    StageTransitionTypeType,
    TriggerTypeType,
    WebhookAuthenticationTypeType,
    ServiceName,
    PaginatorName,
)

def check_value(value: ActionCategoryType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_codepipeline.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_codepipeline.type_defs import (
    AWSSessionCredentialsTypeDef,
    AcknowledgeJobInputRequestTypeDef,
    AcknowledgeJobOutputTypeDef,
    AcknowledgeThirdPartyJobInputRequestTypeDef,
    AcknowledgeThirdPartyJobOutputTypeDef,
    ActionConfigurationPropertyTypeDef,
    ActionConfigurationTypeDef,
    ActionContextTypeDef,
    ActionDeclarationTypeDef,
    ActionExecutionDetailTypeDef,
    ActionExecutionFilterTypeDef,
    ActionExecutionInputTypeDef,
    ActionExecutionOutputTypeDef,
    ActionExecutionResultTypeDef,
    ActionExecutionTypeDef,
    ActionRevisionTypeDef,
    ActionStateTypeDef,
    ActionTypeArtifactDetailsTypeDef,
    ActionTypeDeclarationTypeDef,
    ActionTypeExecutorTypeDef,
    ActionTypeIdTypeDef,
    ActionTypeIdentifierTypeDef,
    ActionTypePermissionsTypeDef,
    ActionTypePropertyTypeDef,
    ActionTypeSettingsTypeDef,
    ActionTypeTypeDef,
    ActionTypeUrlsTypeDef,
    ApprovalResultTypeDef,
    ArtifactDetailTypeDef,
    ArtifactDetailsTypeDef,
    ArtifactLocationTypeDef,
    ArtifactRevisionTypeDef,
    ArtifactStoreTypeDef,
    ArtifactTypeDef,
    BlockerDeclarationTypeDef,
    CreateCustomActionTypeInputRequestTypeDef,
    CreateCustomActionTypeOutputTypeDef,
    CreatePipelineInputRequestTypeDef,
    CreatePipelineOutputTypeDef,
    CurrentRevisionTypeDef,
    DeleteCustomActionTypeInputRequestTypeDef,
    DeletePipelineInputRequestTypeDef,
    DeleteWebhookInputRequestTypeDef,
    DeregisterWebhookWithThirdPartyInputRequestTypeDef,
    DisableStageTransitionInputRequestTypeDef,
    EnableStageTransitionInputRequestTypeDef,
    EncryptionKeyTypeDef,
    ErrorDetailsTypeDef,
    ExecutionDetailsTypeDef,
    ExecutionTriggerTypeDef,
    ExecutorConfigurationTypeDef,
    FailureDetailsTypeDef,
    GetActionTypeInputRequestTypeDef,
    GetActionTypeOutputTypeDef,
    GetJobDetailsInputRequestTypeDef,
    GetJobDetailsOutputTypeDef,
    GetPipelineExecutionInputRequestTypeDef,
    GetPipelineExecutionOutputTypeDef,
    GetPipelineInputRequestTypeDef,
    GetPipelineOutputTypeDef,
    GetPipelineStateInputRequestTypeDef,
    GetPipelineStateOutputTypeDef,
    GetThirdPartyJobDetailsInputRequestTypeDef,
    GetThirdPartyJobDetailsOutputTypeDef,
    InputArtifactTypeDef,
    JobDataTypeDef,
    JobDetailsTypeDef,
    JobTypeDef,
    JobWorkerExecutorConfigurationTypeDef,
    LambdaExecutorConfigurationTypeDef,
    ListActionExecutionsInputRequestTypeDef,
    ListActionExecutionsOutputTypeDef,
    ListActionTypesInputRequestTypeDef,
    ListActionTypesOutputTypeDef,
    ListPipelineExecutionsInputRequestTypeDef,
    ListPipelineExecutionsOutputTypeDef,
    ListPipelinesInputRequestTypeDef,
    ListPipelinesOutputTypeDef,
    ListTagsForResourceInputRequestTypeDef,
    ListTagsForResourceOutputTypeDef,
    ListWebhookItemTypeDef,
    ListWebhooksInputRequestTypeDef,
    ListWebhooksOutputTypeDef,
    OutputArtifactTypeDef,
    PaginatorConfigTypeDef,
    PipelineContextTypeDef,
    PipelineDeclarationTypeDef,
    PipelineExecutionSummaryTypeDef,
    PipelineExecutionTypeDef,
    PipelineMetadataTypeDef,
    PipelineSummaryTypeDef,
    PollForJobsInputRequestTypeDef,
    PollForJobsOutputTypeDef,
    PollForThirdPartyJobsInputRequestTypeDef,
    PollForThirdPartyJobsOutputTypeDef,
    PutActionRevisionInputRequestTypeDef,
    PutActionRevisionOutputTypeDef,
    PutApprovalResultInputRequestTypeDef,
    PutApprovalResultOutputTypeDef,
    PutJobFailureResultInputRequestTypeDef,
    PutJobSuccessResultInputRequestTypeDef,
    PutThirdPartyJobFailureResultInputRequestTypeDef,
    PutThirdPartyJobSuccessResultInputRequestTypeDef,
    PutWebhookInputRequestTypeDef,
    PutWebhookOutputTypeDef,
    RegisterWebhookWithThirdPartyInputRequestTypeDef,
    ResponseMetadataTypeDef,
    RetryStageExecutionInputRequestTypeDef,
    RetryStageExecutionOutputTypeDef,
    S3ArtifactLocationTypeDef,
    S3LocationTypeDef,
    SourceRevisionTypeDef,
    StageContextTypeDef,
    StageDeclarationTypeDef,
    StageExecutionTypeDef,
    StageStateTypeDef,
    StartPipelineExecutionInputRequestTypeDef,
    StartPipelineExecutionOutputTypeDef,
    StopExecutionTriggerTypeDef,
    StopPipelineExecutionInputRequestTypeDef,
    StopPipelineExecutionOutputTypeDef,
    TagResourceInputRequestTypeDef,
    TagTypeDef,
    ThirdPartyJobDataTypeDef,
    ThirdPartyJobDetailsTypeDef,
    ThirdPartyJobTypeDef,
    TransitionStateTypeDef,
    UntagResourceInputRequestTypeDef,
    UpdateActionTypeInputRequestTypeDef,
    UpdatePipelineInputRequestTypeDef,
    UpdatePipelineOutputTypeDef,
    WebhookAuthConfigurationTypeDef,
    WebhookDefinitionTypeDef,
    WebhookFilterRuleTypeDef,
)

def get_structure() -> AWSSessionCredentialsTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-codepipeline` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-codepipeline docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codepipeline/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
