"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceMeteringService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace-metering-service](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemeteringservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceMeteringService extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace-metering-service](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemeteringservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'aws-marketplace';
        this.accessLevelList = {
            Write: [
                'BatchMeterUsage',
                'MeterUsage',
                'RegisterUsage',
                'ResolveCustomer'
            ]
        };
    }
    /**
     * Grants permission to post metering records for a set of customers for SaaS applications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_BatchMeterUsage.html
     */
    toBatchMeterUsage() {
        return this.to('BatchMeterUsage');
    }
    /**
     * Grants permission to emit metering records
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_MeterUsage.html
     */
    toMeterUsage() {
        return this.to('MeterUsage');
    }
    /**
     * Grants permission to to verify that the customer running your paid software is subscribed to your product on AWS Marketplace, enabling you to guard against unauthorized use. Meters software use per ECS task, per hour, with usage prorated to the second
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_RegisterUsage.html
     */
    toRegisterUsage() {
        return this.to('RegisterUsage');
    }
    /**
     * Grants permission to resolve a registration token to obtain a CustomerIdentifier and product code
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_ResolveCustomer.html
     */
    toResolveCustomer() {
        return this.to('ResolveCustomer');
    }
}
exports.AwsMarketplaceMeteringService = AwsMarketplaceMeteringService;
_a = JSII_RTTI_SYMBOL_1;
AwsMarketplaceMeteringService[_a] = { fqn: "iam-floyd.AwsMarketplaceMeteringService", version: "0.388.0" };
//# sourceMappingURL=data:application/json;base64,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