#!/usr/bin/python -tt

import os
import sys
from setuptools import setup

__version__ = '6.0.0a3'
__author__ = 'Ansible, Inc.'


with open('README.rst', 'r') as f:
    long_desc = f.read()

setup(
    name='ansible',
    version=__version__,
    description='Radically simple IT automation',
    long_description=long_desc,
    author=__author__,
    author_email='info@ansible.com',
    url='https://ansible.com/',
    project_urls={
        'Bug Tracker': 'https://github.com/ansible/ansible/issues',
        'Code of Conduct': 'https://docs.ansible.com/ansible/latest/community/code_of_conduct.html',
        'Documentation': 'https://docs.ansible.com/ansible/',
        'Mailing lists': 'https://docs.ansible.com/ansible/latest/community/communication.html#mailing-list-information',
        'Source Code': 'https://github.com/ansible/ansible',
    },
    license='GPLv3+',
    python_requires='>=3.8',
    packages=['ansible_collections'],

    exclude_package_data={
        'ansible_collections': [
            'amazon/aws/.*',
            'amazon/aws/docs/*',
            'amazon/aws/tests/*',
            'ansible/netcommon/.*',
            'ansible/netcommon/docs/*',
            'ansible/netcommon/tests/*',
            'ansible/posix/.*',
            'ansible/posix/docs/*',
            'ansible/posix/tests/*',
            'ansible/utils/.*',
            'ansible/utils/docs/*',
            'ansible/utils/tests/*',
            'ansible/windows/.*',
            'ansible/windows/docs/*',
            'ansible/windows/tests/*',
            'arista/eos/.*',
            'arista/eos/docs/*',
            'arista/eos/tests/*',
            'awx/awx/tests/*',
            'azure/azcollection/.*',
            'azure/azcollection/tests/*',
            'check_point/mgmt/tests/*',
            'chocolatey/chocolatey/tests/*',
            'cisco/aci/.*',
            'cisco/aci/tests/*',
            'cisco/asa/.*',
            'cisco/asa/docs/*',
            'cisco/asa/tests/*',
            'cisco/intersight/.*',
            'cisco/ios/.*',
            'cisco/ios/docs/*',
            'cisco/ios/tests/*',
            'cisco/iosxr/.*',
            'cisco/iosxr/docs/*',
            'cisco/iosxr/tests/*',
            'cisco/ise/.*',
            'cisco/ise/docs/*',
            'cisco/ise/tests/*',
            'cisco/meraki/tests/*',
            'cisco/mso/.*',
            'cisco/mso/tests/*',
            'cisco/nso/.*',
            'cisco/nso/tests/*',
            'cisco/nxos/.*',
            'cisco/nxos/docs/*',
            'cisco/nxos/tests/*',
            'cisco/ucs/.*',
            'cloud/common/tests/*',
            'cloudscale_ch/cloud/.*',
            'cloudscale_ch/cloud/tests/*',
            'community/aws/.*',
            'community/aws/docs/*',
            'community/aws/tests/*',
            'community/azure/.*',
            'community/azure/tests/*',
            'community/ciscosmb/.*',
            'community/ciscosmb/tests/*',
            'community/crypto/.*',
            'community/crypto/docs/*',
            'community/crypto/tests/*',
            'community/digitalocean/.*',
            'community/digitalocean/tests/*',
            'community/dns/.*',
            'community/dns/docs/*',
            'community/dns/tests/*',
            'community/docker/.*',
            'community/docker/docs/*',
            'community/docker/tests/*',
            'community/fortios/.*',
            'community/fortios/tests/*',
            'community/general/.*',
            'community/general/docs/*',
            'community/general/tests/*',
            'community/google/.*',
            'community/google/tests/*',
            'community/grafana/.*',
            'community/grafana/tests/*',
            'community/hashi_vault/.*',
            'community/hashi_vault/docs/*',
            'community/hashi_vault/tests/*',
            'community/hrobot/.*',
            'community/hrobot/docs/*',
            'community/hrobot/tests/*',
            'community/libvirt/.*',
            'community/libvirt/tests/*',
            'community/mongodb/.*',
            'community/mysql/.*',
            'community/mysql/tests/*',
            'community/network/.*',
            'community/network/tests/*',
            'community/okd/.*',
            'community/okd/docs/*',
            'community/okd/tests/*',
            'community/postgresql/.*',
            'community/postgresql/docs/*',
            'community/postgresql/tests/*',
            'community/proxysql/.*',
            'community/proxysql/tests/*',
            'community/rabbitmq/.*',
            'community/rabbitmq/tests/*',
            'community/routeros/.*',
            'community/routeros/docs/*',
            'community/routeros/tests/*',
            'community/sap/.*',
            'community/sap/tests/*',
            'community/skydive/.*',
            'community/skydive/tests/*',
            'community/sops/.*',
            'community/sops/docs/*',
            'community/sops/tests/*',
            'community/vmware/.*',
            'community/vmware/docs/*',
            'community/vmware/tests/*',
            'community/windows/.*',
            'community/windows/docs/*',
            'community/windows/tests/*',
            'community/zabbix/.*',
            'community/zabbix/docs/*',
            'community/zabbix/tests/*',
            'containers/podman/docs/*',
            'containers/podman/tests/*',
            'cyberark/conjur/.*',
            'cyberark/conjur/tests/*',
            'cyberark/pas/.*',
            'cyberark/pas/docs/*',
            'cyberark/pas/tests/*',
            'dellemc/enterprise_sonic/.*',
            'dellemc/enterprise_sonic/tests/*',
            'dellemc/openmanage/.*',
            'dellemc/openmanage/docs/*',
            'dellemc/openmanage/tests/*',
            'dellemc/os10/.*',
            'dellemc/os10/docs/*',
            'dellemc/os10/tests/*',
            'dellemc/os6/.*',
            'dellemc/os6/docs/*',
            'dellemc/os6/tests/*',
            'dellemc/os9/.*',
            'dellemc/os9/docs/*',
            'dellemc/os9/tests/*',
            'f5networks/f5_modules/.*',
            'f5networks/f5_modules/docs/*',
            'f5networks/f5_modules/tests/*',
            'frr/frr/.*',
            'frr/frr/docs/*',
            'frr/frr/tests/*',
            'gluster/gluster/.*',
            'gluster/gluster/tests/*',
            'google/cloud/.*',
            'google/cloud/tests/*',
            'hetzner/hcloud/.*',
            'hetzner/hcloud/tests/*',
            'hpe/nimble/.*',
            'hpe/nimble/tests/*',
            'ibm/qradar/.*',
            'ibm/qradar/docs/*',
            'ibm/qradar/tests/*',
            'infinidat/infinibox/.*',
            'infinidat/infinibox/docs/*',
            'infinidat/infinibox/tests/*',
            'infoblox/nios_modules/.*',
            'infoblox/nios_modules/tests/*',
            'inspur/sm/docs/*',
            'junipernetworks/junos/.*',
            'junipernetworks/junos/docs/*',
            'junipernetworks/junos/tests/*',
            'kubernetes/core/.*',
            'kubernetes/core/docs/*',
            'kubernetes/core/tests/*',
            'mellanox/onyx/.*',
            'mellanox/onyx/tests/*',
            'netapp/aws/.*',
            'netapp/aws/tests/*',
            'netapp/azure/.*',
            'netapp/azure/tests/*',
            'netapp/cloudmanager/.*',
            'netapp/cloudmanager/tests/*',
            'netapp/elementsw/.*',
            'netapp/elementsw/tests/*',
            'netapp/ontap/.*',
            'netapp/ontap/tests/*',
            'netapp/storagegrid/.*',
            'netapp/storagegrid/tests/*',
            'netapp/um_info/.*',
            'netapp/um_info/tests/*',
            'netapp_eseries/santricity/.*',
            'netapp_eseries/santricity/tests/*',
            'netbox/netbox/.*',
            'netbox/netbox/docs/*',
            'netbox/netbox/tests/*',
            'ngine_io/cloudstack/.*',
            'ngine_io/cloudstack/tests/*',
            'ngine_io/exoscale/.*',
            'ngine_io/exoscale/tests/*',
            'ngine_io/vultr/.*',
            'ngine_io/vultr/tests/*',
            'openstack/cloud/docs/*',
            'openvswitch/openvswitch/.*',
            'openvswitch/openvswitch/docs/*',
            'openvswitch/openvswitch/tests/*',
            'ovirt/ovirt/tests/*',
            'purestorage/flasharray/.*',
            'purestorage/flasharray/docs/*',
            'purestorage/flasharray/tests/*',
            'purestorage/flashblade/tests/*',
            'sensu/sensu_go/.*',
            'sensu/sensu_go/docs/*',
            'sensu/sensu_go/tests/*',
            'servicenow/servicenow/.*',
            'servicenow/servicenow/docs/*',
            'servicenow/servicenow/tests/*',
            'splunk/es/.*',
            'splunk/es/docs/*',
            'splunk/es/tests/*',
            't_systems_mms/icinga_director/.*',
            't_systems_mms/icinga_director/docs/*',
            'vmware/vmware_rest/.*',
            'vmware/vmware_rest/docs/*',
            'vmware/vmware_rest/tests/*',
            'vyos/vyos/.*',
            'vyos/vyos/docs/*',
            'vyos/vyos/tests/*',
            'wti/remote/docs/*',
        ],
    },
    include_package_data=True,
    install_requires=[
        'ansible-core ~= 2.13.0',
    ],
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Framework :: Ansible',
        'Intended Audience :: Developers',
        'Intended Audience :: Information Technology',
        'Intended Audience :: System Administrators',
        'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)',
        'Natural Language :: English',
        'Operating System :: POSIX',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Topic :: System :: Installation/Setup',
        'Topic :: System :: Systems Administration',
        'Topic :: Utilities',
    ],
    data_files=[],
    # Installing as zip files would break due to references to __file__
    zip_safe=False
)