def get_template_LEDET_inputs_sheet():
    '''
        Define the template for the input sheet of a LEDET input file
    '''

    template_LEDET_inputs_sheet = [
        # [None, None, 'Magnet Parameters'],  # Disabled since LEDET cannot cope with description in the first row
        ['T00', None, 'Initial temperature [K]'],
        ['l_magnet', None, 'Magnetic length [m]'],
        ['I00', None, 'Initial current [A]'],
        [None, None, None],
        [None, None, 'Conductor parameters'],
        ['GroupToCoilSection', None, 'Define the coil section where each group of cables is located'],
        ['polarities_inGroup', None, 'Polarity of the current in each group of strands'],
        ['nT', None, 'Number of half-turns in each group'],
        ['nStrands_inGroup', None, 'Number of strands in each cable belonging to a particular group'],
        ['l_mag_inGroup', None, 'length of each half turn [m] (default=l_magnet)'],
        ['ds_inGroup', None, 'strand diameter [m]'],
        ['f_SC_strand_inGroup', None, 'fraction of superconductor in the strands [-]'],
        ['f_ro_eff_inGroup', None, 'Effective transverse resistivity parameter (default=1)'],
        ['Lp_f_inGroup', None, 'Filament twist-pitch [m]'],
        ['RRR_Cu_inGroup', None, 'RRR of the conductor in each group of cables [-]'],
        ['SCtype_inGroup', None, 'type of superconductor (1=Nb-Ti, 2=Nb3Sn with Summers\' fit, 3 = BSCCO2212, 4 = Nb3Sn with Bordini\' fit)'],
        ['STtype_inGroup', None, 'type of stabilizer (1=Cu, 2=Ag, 3=Stainless steel, 4=Iron, 5=BeCu)'],
        ['insulationType_inGroup', None, 'Type of cable insulation (1=G10, 2=kapton)'],
        ['internalVoidsType_inGroup', None, 'Type of filler of voids between adjacent strands (1=G10, 2=kapton, 3=helium, 4=void)'],
        ['externalVoidsType_inGroup', None, 'Type of filler of voids between strands and insulation layesrs (1=G10, 2=kapton, 3=helium, 4=void)'],
        ['wBare_inGroup', None, 'bare cable width [m]'],
        ['hBare_inGroup', None, 'bare average cable height [m]'],
        ['wIns_inGroup', None, 'insulation thickness in the width direction [m]'],
        ['hIns_inGroup', None, 'insulation thickness in the height direction [m]'],
        ['Lp_s_inGroup', None, 'Strand twist-pitch [m]'],
        ['R_c_inGroup', None, 'Cross-contact resistance [Ohm]'],
        ['Tc0_NbTi_ht_inGroup', None, 'Tc0_NbTi_ht_inGroup [K]'],
        ['Bc2_NbTi_ht_inGroup', None, 'Bc2_NbTi_ht_inGroup [T]'],
        ['c1_Ic_NbTi_inGroup', None, 'c1_Ic_NbTi_inGroup [A]'],
        ['c2_Ic_NbTi_inGroup', None, 'c2_Ic_NbTi_inGroup [A/T]'],
        ['Tc0_Nb3Sn_inGroup', None, 'Tc0_Nb3Sn [K]'],
        ['Bc2_Nb3Sn_inGroup', None, 'Bc2_Nb3Sn [T]'],
        ['Jc_Nb3Sn0_inGroup', None, 'Jc_Nb3Sn0 [A*T^0.5/m^2] Based on short-sample measurements'],
        ['alpha_Nb3Sn0_inGroup', None, 'alpha parameter used when Bordini\'s Nb3Sn fit is selected'],
        ['f_scaling_Jc_BSCCO2212_inGroup', None, 'scaling factor for the Jc(T,B) when BSCCO-2212 fit is selected'],
        ['df_inGroup', None, 'filament diameter [m]'],
        ['selectedFit_inGroup', None, 'Jc fit type (only used for persistent-current calculation): 1= Jc=constant; 2= Nb-Ti Bottura; 3= Nb-Ti CUDI ; 4= Nb3Sn Summers'],
        ['fitParameters_inGroup', None, 'Jc fit parameters [consult this report for more information: https://edms.cern.ch/document/2418186 ]'],
        ['overwrite_f_internalVoids_inGroup', None, 'Fraction of cable cross-section occupied by voids between strands and strands'],
        ['overwrite_f_externalVoids_inGroup', None, 'Fraction of cable cross-section occupied by voids between strands and insulation layers'],
        ['f_RRR1_Cu_inGroup', None, 'First Cu fraction of wire/strand in conductor with non-uniform RRR'],
        ['f_RRR2_Cu_inGroup', None, 'Second Cu fraction of wire/strand in conductor with non-uniform RRR'],
        ['f_RRR3_Cu_inGroup', None, 'Third Cu fraction of wire/strand in conductor with non-uniform RRR'],
        ['RRR1_Cu_inGroup', None, 'RRR of the first Cu fraction of wire/strand in conductor with non-uniform RRR'],
        ['RRR2_Cu_inGroup', None, 'RRR of the second Cu fraction of wire/strand in conductor with non-uniform RRR'],
        ['RRR3_Cu_inGroup', None, 'RRR of the third Cu fraction of wire/strand in conductor with non-uniform RRR'],
        [None, None, None],
        [None, None, 'Conductor geometrical parameters (they only influence ISCC/ISCL)'],
        ['alphasDEG', None, 'Inclination of cables with respect to X axis (including transformations for mirror and rotation)'],
        ['rotation_block', None, 'Rotate cable by a certain angle [deg]'],
        ['mirror_block', None, 'Mirror cable along the bisector of its quadrant (0=no, 1=yes)'],
        ['mirrorY_block', None, 'Mirror cable along the Y axis (0=no, 1=yes)'],
        [None, None, None],
        [None, None, 'Electrical order of the half turns'],
        ['el_order_half_turns', None, 'Electrical order of the half turns'],
        [None, None, None],
        [None, None, 'Pairs defining thermally-connected half-turns'],
        ['iContactAlongWidth_From', None, 'Indices of the cables exchanging heat with iContactAlongWidth_To along the cable wide side'],
        ['iContactAlongWidth_To', None, 'Indices of the cables exchanging heat with iContactAlongWidth_From along the cable wide side'],
        ['iContactAlongHeight_From', None, 'Indices of the cables exchanging heat with iContactAlongHeight_To along the cable narrow side'],
        ['iContactAlongHeight_To', None, 'Indices of the cables exchanging heat with iContactAlongHeight_From along the cable narrow side'],
        [None, None, None],
        [None, None, 'Power supply control'],
        ['t_PC', None, 'Time when the power supply is switched off and the crowbar is switched on [s]'],
        ['t_PC_LUT', None, 'LUT controlling power supply, Time [s]'],
        ['I_PC_LUT', None, 'LUT controlling power supply, Current [A]'],
        [None, None, None],
        [None, None, 'Circuit parameters'],
        ['R_circuit', None, 'Resistance of the warm parts of the circuit [Ohm]'],
        ['R_crowbar', None, 'Resistance of crowbar of the power supply [Ohm]'],
        ['Ud_crowbar', None, 'Forward voltage drop of a diode or thyristor in the crowbar of the power supply [V]'],
        [None, None, None],
        [None, None, 'Energy-extraction system'],
        ['tEE', None, 'Time when the energy-extraction system is triggered [s]'],
        ['R_EE_triggered', None, 'Resistance of the energy-extraction system [Ohm]'],
        [None, None, None],
        [None, None, 'CLIQ system'],
        ['tCLIQ', None, 'Time when the CLIQ system is triggered [s]'],
        ['directionCurrentCLIQ', None, 'Direction of the introduced current change for the chosen CLIQ configuration'],
        ['nCLIQ', None, 'Number of CLIQ units'],
        ['U0', None, 'CLIQ charging voltage [V]'],
        ['C', None, 'Capacitance of the CLIQ capacitor bank [F]'],
        ['Rcapa', None, 'Resistance of the CLIQ leads [Ohm]'],
        [None, None, None],
        [None, None, 'Quench Heater system'],
        ['tQH', None, 'Time when the QH system is triggered [s]'],
        ['U0_QH', None, 'Charging voltage of the QH capacitor bank [V]'],
        ['C_QH', None, 'Capacitance of the QH capacitor bank [F]'],
        ['R_warm_QH', None, 'Resistance of the warm leads of the QH strip discharge circuit [Ohm]'],
        ['w_QH', None, 'Width of the QH strip [m]'],
        ['h_QH', None, 'Height of the QH strip [m]'],
        ['s_ins_QH', None, 'Thickness of the insulation layer between QH strip and coil insulation layer [m]'],
        ['type_ins_QH', None, 'Type of material of the insulation layer between QH strip and coil insulation layer (1=G10; 2=kapton)'],
        ['s_ins_QH_He', None, 'Thickness of the insulation layer between QH strip and helium bath [m]'],
        ['type_ins_QH_He', None, 'Type of material of the insulation layer between QH strip and helium bath (1=G10; 2=kapton)'],
        ['l_QH', None, 'Length of the QH strip [m]'],
        ['f_QH', None, 'Fraction of QH strip covered by heating stations (not-Cu-plated)'],
        ['iQH_toHalfTurn_From', None, 'Indices of the QH strips exchanging heat with half turns iContactAlongWidth_To'],
        ['iQH_toHalfTurn_To', None, 'Indices of the half turns exchanging heat with QH strips iContactAlongWidth_From'],
        [None, None, None],
        [None, None, 'Hot-spot temperature calculation (during post-processing)'],
        ['tQuench', None, 'Time from which the adiabatic hot-spot temperature calculation starts. For each coil section, calculate the adiabatic hot-spot temperature in the highest-field strand/cable [s]'],
        ['initialQuenchTemp', None, 'Initial quench temperature in the hot-spot temperature calculation [K]'],
        [None, None, None],
        [None, None, 'Variables for 2D+1D simulations'],
        ['iStartQuench', None, 'Indices of the half-turns that are set to quench at a given time'],
        ['tStartQuench', None, 'Time at which each selected half-turn quenches [s]'],
        ['lengthHotSpot_iStartQuench', None, 'Initial length of the hot-spot [m]'],
        ['fScaling_vQ_iStartQuench', None, 'Factor scaling the adiabatic quench propagation velocity calculated by LEDET at each time step for each half-turn'],
        [None, None, None],
        [None, None, 'Variables for 3D simulations'],
        ['sim3D_uThreshold', None, 'Quench detection voltage threshold [V]'],
        ['sim3D_f_cooling_down', None, 'Scaling factor for cooling to thermal sink - Conductor down side'],
        ['sim3D_f_cooling_up', None, 'Scaling factor for cooling to thermal sink - Conductor up side'],
        ['sim3D_f_cooling_left', None, 'Scaling factor for cooling to thermal sink - Conductor right side'],
        ['sim3D_f_cooling_right', None, 'Scaling factor for cooling to thermal sink - Conductor left side'],
        ['sim3D_fExToIns', None, 'Scaling factor for the heat exchange between bare conductor and insulation'],
        ['sim3D_fExUD', None, 'Scaling factor for the thermal diffusion between conductors along the wider conductor side (UD-->Up/Down)'],
        ['sim3D_fExLR', None, 'Scaling factor for the thermal diffusion between conductors along the narrower conductor side (LR-->Left/Right)'],
        ['sim3D_min_ds_coarse', None, 'Minimum spatial mesh size, in the coarse-mesh part [m]'],
        ['sim3D_min_ds_fine', None, 'Minimum spatial mesh size, in the fine-mesh part [m]'],
        ['sim3D_min_nodesPerStraightPart', None, 'Minimum number of nodes in each straight-section part [-]'],
        ['sim3D_min_nodesPerEndsPart', None, 'Minimum number of nodes in each end-section part [-]'],
        ['sim3D_idxFinerMeshHalfTurn', None, 'Indices of the half-turns with finer mesh (in LEDET half-turn order, NOT in electrical order) [-]'],
        ['sim3D_Tpulse_sPosition', None, 'Center of the temperature gaussian distribution, i.e. position where the quench starts [m]'],
        ['sim3D_Tpulse_peakT', None, 'Peak temperature of the gaussian distribution [K]'],
        ['sim3D_Tpulse_width', None, 'Width of the temperature gaussian distribution, i.e. 2*sigma [m]'],
        ['sim3D_tShortCircuit', None, 'Time at which the short-circuit occurs [s] (default=1e9 s)'],
        ['sim3D_coilSectionsShortCircuit', None, 'Vector of +1/-1 defining which coil sections are by-passed by the short-circuit: -1 indicates the coil section is by-passed'],
        ['sim3D_R_shortCircuit', None, 'Resistance of the short-circuit [Ohm] (default=1e9 Ohm)'],
        ['sim3D_shortCircuitPosition', None, 'Position of the short-circuit defined with a pair of values indicating the start and end of the conductor length that will receive the heat generated in the short-circuit [m]. For a simulation without short-circuit, set to the scalar 0 (default=0)'],
        ['sim3D_durationGIF', None, 'Duration of the animated GIF [s]'],
        ['sim3D_flag_saveFigures', None, 'Save figures showing the main results'],
        ['sim3D_flag_saveGIF', None, 'Save GIF showing the main results'],
        ['sim3D_flag_VisualizeGeometry3D', None, 'Visualize the 3D geometry'],
        ['sim3D_flag_SaveGeometry3D', None, 'Save figure showing the 3D Geometry'],
        [None, None, None],
        [None, None, 'Magnet inductance'],
        ['M_m', None, 'Self mutual inductance matrix [H/m]'],
        ['HalfTurnToInductanceBlock', None, 'Vector defining to which inductive block each half-turn belongs'],
        ['M_InductanceBlock_m', None, 'Extended self mutual inductance matrix [H/m]'],
        ['fL_I', None, 'Current levels at which the differential inductance is evaluated [A]'],
        ['fL_L', None, 'Ratio between differential inductance at different current levels and nominal inductance [-]'],
    ]
    return template_LEDET_inputs_sheet


def get_template_LEDET_options_sheet():
    '''
        Define the template for the options sheet of a LEDET input file
    '''

    template_LEDET_options_sheet = [
        # [None, None, 'Time Vector Definition'],  # Disabled since LEDET cannot cope with description in the first row
        ['time_vector_params', None,'Time Vector Definition. Parameters used to generate the time vector. Each triplet of numbers defines a time window: first element is the start time, second element is the time step in that window, third element is the end time. It must contain a number of elements multiple of 3. Any time point above t=1000 s will be ignored.'],
        [None, None, None],
        [None, None, 'Field-Map Files Options'],
        ['Iref', None, 'Reference current in ROXIE or other software [A]'],
        ['flagIron', None, 'Specify whether the magnetic-field map files are calculated including iron-yoke effect (=1, suffix "WithIron") or not (=0, suffix "NoIron")'],
        ['flagSelfField', None, 'Specify whether the magnetic-field map files are calculated including strand self field effect (=1, suffix "WithSelfField") or not (=0, suffix "NoSelfField")'],
        ['headerLines', None, 'Lines of header contained in the magnetic-field map files'],
        ['columnsXY', None, 'Columns containing the X and Y positions of each strand in the map files (positions given in mm)'],
        ['columnsBxBy', None, 'Columns containing the magnetic field in the X and Y direction at the reference current for each strand in the map files (magnetic field given in T)'],
        ['flagPlotMTF', None, 'Plot magnetic field distributions for each coil section (=1), or not (=0)'],
        ['fieldMapNumber', None, 'Number defining a set of magnetic-field maps, whose names should end with a suffix "_N", where N is  the set number'],
        [None, None, None],
        [None, None, 'Input Generation Options'],
        ['flag_typeWindings', None, 'Coil windings type. 0=Multipole coil 1=Solenoid, 101=Busbar. Default: 0'],
        ['flag_calculateInductanceMatrix', None, 'If set to >0, enables the automatic calculation of the self- and mutual inductances between each turn, and between each coil section. If set to 2, it also write an output txt file with the calculated values; this file is saved in the subfolder "Output\Txt Files".'],
        ['flag_useExternalInitialization', None, 'If set to 1, LEDET will look for an initialization file in a specified folder to load all input properties and magnetic field parameters; if the file is not there, it will generate it (default=0)'],
        ['flag_initializeVar', None, 'Initialize selected variables from a txt files. The variables are defined in the "Variables" sheet'],
        [None, None, None],
        [None, None, 'Input Simulation Options'],
        ['flag_fastMode', None, 'If set to 1, run the simulation in fast mode: faster and less heavy (about 75% less RAM needed), but not all variables are saved (RECOMMENDED)'],
        ['flag_controlCurrent', None, 'Set the currents in each coil section following a look-up table acquired from an external file. Make sure the simulation time-stepping is smaller than the time-stepping used in the file look-up table'],
        ['flag_automaticRefinedTimeStepping', None, 'If set to 1, the defined time vector is modified to have a finer time stepping around power-supply switching-off, and EE, CLIQ, and QH triggering, and quench start in the initial hot-spot (default: Yes)'],
        [None, None, None],
        [None, None, 'Simulation Physics Options'],
        ['flag_IronSaturation', None, 'If set to 1, include effects of iron-yoke saturation on the magnet inductance'],
        ['flag_InvertCurrentsAndFields', None, 'If set to 1, the polarities of all currents and magnetic transfer function parameters are inverted'],
        ['flag_ScaleDownSuperposedMagneticField', None, 'If set to 1, the magnetic field parameters to obtain the correct peak field in the conductor when superposing the magnetic fields generated by all coil sections'],
        ['flag_HeCooling', None, 'If set to 1, helium cooling is included in the simulation (conductive heat transfer only);  if set to 2, helium cooling is included in the simulation (conductive and simplified convective heat transfer)'],
        ['fScaling_Pex', None, 'Scale up or down the contribution of heat exchange (including heat exchange to helium bath)'],
        ['fScaling_Pex_AlongHeight', None, 'Scale up or down the contribution of heat exchange through the short side of the cables (useful to change the insulation between coil layers'],
        ['fScaling_MR', None, 'Factor arbitrarily scaling the contribution of magneto-resistivity to copper electrical resistivity (default=1, magneto-resistivity calculated following NIST, which gives a contribution of about 4.1E-11 Ohm*m/T for RRR=100)'],
        ['flag_scaleCoilResistance_StrandTwistPitch', None, 'If set to 1, take into account the increase of electrical resistance due to strand twist-pitch: sqrt(wBare^2+(Lp_s/2)^2)/(Lp_s/2) , where w=wBare cable width, Lp_s=strand twist-pitch; if set to 2, take into account the increases of electrical resistance, ohmic loss per unit length, inter-filament and inter-strand coupling loss per unit length, and fractions of superconductor and stabilizer in the cable bare cross-section due to strand twist-pitch (default=0)'],
        ['flag_separateInsulationHeatCapacity', None, 'If set to 1, the heat capacity of insulation layer is modeled separated from that of strands and impregnation (default: No)'],
        ['flag_persistentCurrents', None, 'Enable persistent-currents calculation (default=0)'],
        ['flag_ISCL', None, 'If set to 1, Inter-strand coupling loss (ISCL) are calculated and the effects of inter-strand coupling currents on the magnet inductance are included'],
        ['fScaling_Mif', None, 'Factor arbitrarily multiplying the parameters MifX and MifY related to the IFCC/IFCL (default=1)'],
        ['fScaling_Mis', None, 'Factor arbitrarily multiplying the parameters Mis related to the ISCC/ISCL (default=1)'],
        ['flag_StopIFCCsAfterQuench', None, 'If set to 1, IFCC in each strand are set artificially to 0 as soon as the strand/cable quenches'],
        ['flag_StopISCCsAfterQuench', None, 'If set to 1, ISCC in each cable are set artificially to 0 as soon as the strand/cable quenches'],
        ['tau_increaseRif', None, 'If this variable is defined AND the variable "flag_StopIFCCsAfterQuench" is set to 0, the equivalent resistances of IFCC loops are set to increase exponentially with time constant tau_increaseRif [s] after a quench'],
        ['tau_increaseRis', None, 'If this variable is defined AND the variable "flag_StopISCCsAfterQuench" is set to 0, the equivalent resistances of ISCC loops are set to increase exponentially with time constant tau_increaseRis [s] after a quench'],
        ['fScaling_RhoSS', None, 'Scale the resistivity of the stainless-steel used in the quench heaters (default=1)'],
        ['maxVoltagePC', None, 'Max voltage across the PC [V]'],
        ['minCurrentDiode', None, 'Minimum current below which the power supply switches off (Default: 10 A)'],
        ['flag_symmetricGroundingEE', None, 'if set to 1, symmetric grounding of the EE system is implemented (all voltages to ground reduced by R_EE*I_a) (default=0)'],
        ['flag_removeUc', None, 'If set to 1, remove CLIQ capacitor from the circuit (default: No)'],
        ['BtX_background', None, 'Uniform background field - X component [T]'],
        ['BtY_background', None, 'Uniform background field - Y component [T]'],
        [None, None, None],
        [None, None, 'Post-Processing Options'],
        ['flag_showFigures', None, 'Show figures showing the main results'],
        ['flag_saveFigures', None, 'Save figures showing the main results'],
        ['flag_saveMatFile', None, 'Save main simulation results in a mat file (0=do not save; 1=save most variables; 2=save only most relevant variables)'],
        ['flag_saveTxtFiles', None, 'Save selected variables in a txt files. The variables are defined in the "Variables" sheet'],
        ['flag_generateReport', None, 'Generate a report summarizing the simulation results (default: Yes)'],
        ['flag_hotSpotTemperatureInEachGroup', None, 'If set to 1, calculate the hot-spot temperature in each group instead of in each coil section (default: No)'],
        [None, None, None],
        [None, None, '3D Simulation Options'],
        ['flag_3D', None, 'If set to 1, the 3D model will run instead of the default 2D'],
        ['flag_adaptiveTimeStepping', None, 'If set to 1, adaptive time stepping will be enabled'],
        ['sim3D_flag_Import3DGeometry', None, 'Flag indicating that the 3D geometry and field map are imported from a csv file'],
        ['sim3D_import3DGeometry_modelNumber', None, 'Number indicating the input csv file containing the 3D geometry and field map'],
    ]
    return template_LEDET_options_sheet


def get_template_LEDET_plots_sheet():
    '''
        Define the template for the plots sheet of a LEDET input file
    '''

    template_LEDET_plots_sheet = [
        ['suffixPlot', None, 'Suffix to include in the figure name'],
        ['typePlot', None, 'Plot type: 1= Plot of overall variables (current, differential inductance, resistance, etc) versus time; 2= Plot of strand by strand or half-turn by half-turn variables (temperature, etc) versus time; 3= 2D Plot of variables at selected time; 4= 2D animated GIF of variables in the selected time window'],
        ['outputPlotSubfolderPlot', None, 'Output subfolder where the figure is saved'],
        ['variableToPlotPlot', None, 'Variable to plot'],
        ['selectedStrandsPlot', None, 'Selected groups of elements to plot (strands, half turns)'],
        ['selectedTimesPlot', None, 'Selected time window to plot. Examples: "1:n_time" plots the entire time range; "find(time_vector>=0&time_vector<=.05)" plots times between 10 and 50 ms; "find(time_vector>=.001" plots only time=1ms)'],
        ['labelColorBarPlot', None, 'Label of the variables to plot (Y axis in plots versus time; color bar label in 2D plots)'],
        ['minColorBarPlot', None, 'In 2D plots, minimum value to include in the color bar. Note: default value should be "min(min(variableToPlot))"'],
        ['maxColorBarPlot', None, 'In 2D plots, maxmum value to include in the color bar. Note: default value should be "max(max(variableToPlot))"'],
        ['MinMaxXYPlot', None, 'Minimum and maximum scales in the X and Y directions applied to some output figures. Note: if left blank, limits are automatically calculated'],
        ['flagSavePlot', None, 'If set to 0, plot is generated but not saved; if set to 1, plots are saved as TIF files (animated GIF\'s as GIF); if set to 2, plots versus time are also saved as FIG Matlab figures'],
        ['flagColorPlot', None, 'If set to 0, plots are in black and white; if set to 1, plots are in colors'],
        ['flagInvisiblePlot', None, 'If set to 0, plots are visible; if set to 1, plots are invisible but can still be saved'],
    ]
    return template_LEDET_plots_sheet


def get_template_LEDET_variables_sheet():
    '''
        Define the template for the variables sheet of a LEDET input file
    '''

    template_LEDET_variables_sheet = [
        ['variableToSaveTxt', None, 'Variables to save'],
        ['typeVariableToSaveTxt', None, 'Flag determining the variable type: Flag 1 saves the entire variable history; Flag 2 saves the variable final state. Histories and final states are saved in separate files.'],
        ['variableToInitialize', None, 'Variables to load from exchange files'],
    ]
    return template_LEDET_variables_sheet