(window.webpackJsonp=window.webpackJsonp||[]).push([[235],{1285:function(n,e){n.exports={attributes:{title:"PEFT",description:"The ArgillaPeftTrainer leverages the base features of transformers and uses the Low Rank Adaptation (LoRA) implementation of Parameter Efficient Fine-Tuning (PEFT).",links:[{linkText:"Argilla docs",linkLink:"https://docs.argilla.io/en/practical_guides/fine_tune.html#token-classification"},{linkText:"Transformers blog",linkLink:"https://huggingface.co/blog/peft"},{linkText:"Transformers docs",linkLink:"https://huggingface.co/docs/peft/index"}]},body:'*code snippet*\n\n```python\nfrom argilla.training import ArgillaTrainer\n\ntrainer = ArgillaTrainer(\n    name="<my_dataset_name>",\n    workspace="<my_workspace_name>",\n    framework="peft",\n    train_size=0.8\n)\ntrainer.update_config(lora_alpha=8, num_train_epochs=3)\ntrainer.train(output_dir="token-classification")\nrecords = trainer.predict("The ArgillaTrainer is great!", as_argilla_records=True)\n```\n\n*update training config*\n\n```python\n# `peft.LoraConfig`\ntrainer.update_config(\n    r=8,\n    target_modules=None,\n    lora_alpha=16,\n    lora_dropout=0.1,\n    fan_in_fan_out=False,\n    bias="none",\n    inference_mode=False,\n    modules_to_save=None,\n    init_lora_weights=True\n)\n# `transformers.AutoModelForTextClassification`\ntrainer.update_config(\n    pretrained_model_name_or_path = "distilbert-base-uncased",\n    force_download = False,\n    resume_download = False,\n    proxies = None,\n    token = None,\n    cache_dir = None,\n    local_files_only = False\n)\n# `transformers.TrainingArguments`\ntrainer.update_config(\n    per_device_train_batch_size = 8,\n    per_device_eval_batch_size = 8,\n    gradient_accumulation_steps = 1,\n    learning_rate = 5e-5,\n    weight_decay = 0,\n    adam_beta1 = 0.9,\n    adam_beta2 = 0.9,\n    adam_epsilon = 1e-8,\n    max_grad_norm = 1,\n    learning_rate = 5e-5,\n    num_train_epochs = 3,\n    max_steps = 0,\n    log_level = "passive",\n    logging_strategy = "steps",\n    save_strategy = "steps",\n    save_steps = 500,\n    seed = 42,\n    push_to_hub = False,\n    hub_model_id = "user_name/output_dir_name",\n    hub_strategy = "every_save",\n    hub_token = "1234",\n    hub_private_repo = False\n)\n```\n'}}}]);