# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pelican', 'pelican.plugins.pandoc_reader']

package_data = \
{'': ['*'],
 'pelican.plugins.pandoc_reader': ['templates/*',
                                   'test_content/*',
                                   'test_default_files/*']}

install_requires = \
['beautifulsoup4>=4.9.3,<5.0.0',
 'markdown-word-count>=0.0.1,<0.0.2',
 'pelican>=4.5,<5.0',
 'pyyaml>=5.3.1,<6.0.0']

extras_require = \
{'markdown': ['markdown>=3.2.2,<4.0.0']}

setup_kwargs = {
    'name': 'pelican-pandoc-reader',
    'version': '1.0.1',
    'description': "Pelican plugin for converting Pandoc's Markdown variant to HTML.",
    'long_description': 'Pandoc Reader: A Plugin for Pelican\n===================================\n\n[![Build Status](https://img.shields.io/github/workflow/status/pelican-plugins/pandoc-reader/build)](https://github.com/pelican-plugins/pandoc-reader/actions)\n[![PyPI Version](https://img.shields.io/pypi/v/pelican-pandoc-reader)](https://pypi.org/project/pelican-pandoc-reader/)\n![License](https://img.shields.io/pypi/l/pelican-pandoc-reader?color=blue)\n\nPandoc Reader is a [Pelican][] plugin that converts documents written in [Pandoc’s variant of Markdown][] into HTML.\n\nRequirements\n------------\n\nThis plugin requires a `pandoc` executable to be available on your `PATH`. We recommend using the latest version of Pandoc (2.11 and higher), as earlier versions are not supported.\n\nTo install this needed dependency, follow the [Pandoc installation instructions](https://pandoc.org/installing.html).\n\nInstallation\n------------\n\nThis plugin can be installed via:\n\n```bash\npython -m pip install pelican-pandoc-reader\n```\n\nConfiguration\n-------------\n\nThis plugin converts [Pandoc’s variant of Markdown][] into HTML. Conversion from other Markdown variants is supported but requires the use of [Pandoc default files][].\n\nConverting to output formats other than HTML is not supported.\n\n### Specifying File Metadata\n\nThe plugin expects all Markdown files to start with a YAML-formatted content header, as shown below.\n\n```yaml\n---\ntitle: "<post-title>"\nauthor: "<author-name>"\ndata: "<date>"\n---\n```\n\n… or …\n\n```yaml\n---\ntitle: "<post-title>"\nauthor: "<author-name>"\ndate: "<date>"\n...\n```\n\n> ⚠️ **Note:** The YAML-formatted header shown above is syntax specific to Pandoc for specifying content metadata. This is different from Pelican’s front-matter format. If you ever decide to stop using this plugin and switch to Pelican’s default Markdown handling, you may need to switch your front-matter metadata to [Python-Markdown’s Meta-Data format](https://python-markdown.github.io/extensions/meta_data/).\n\nIf you have files that use Pelican\'s front matter format, there is a script written by [Joseph Reagle](https://github.com/reagle) available that [converts Pelican\'s front matter to Pandoc\'s YAML header format](https://gist.github.com/reagle/5bc44ba9e2f1b961d1aaca9179fb403b).\n\nFor more information on Pandoc\'s YAML metadata block or Pelican\'s default metadata format please visit the links below:\n\n* [Pandoc’s YAML metadata blocks](https://pandoc.org/MANUAL.html#metadata-blocks)\n* [Pelican’s default metadata format](https://docs.getpelican.com/en/stable/content.html#file-metadata)\n\n### Specifying Pandoc Options\n\nThe plugin supports two **mutually exclusive** methods for passing options to Pandoc.\n\n#### Method One: Via Pelican Settings\n\nThe first method involves configuring two settings in your Pelican settings file (e.g., `pelicanconf.py`):\n\n* `PANDOC_ARGS`\n* `PANDOC_EXTENSIONS`\n\nIn the `PANDOC_ARGS` setting, you may specify any arguments supported by Pandoc, as shown below:\n\n```python\nPANDOC_ARGS = [\n    "--mathjax",\n    "--citeproc",\n]\n```\n\nIn the `PANDOC_EXTENSIONS` setting, you may enable/disable any number of the supported [Pandoc extensions](https://pandoc.org/MANUAL.html#extensions):\n\n```python\nPANDOC_EXTENSIONS = [\n    "+footnotes",   # Enabled extension\n    "-pipe_tables", # Disabled extension\n]\n```\n\n#### Method Two: Using Pandoc Default Files\n\nThe second method involves specifying the path(s) to one or more [Pandoc default files][], with all your preferences written in YAML format.\n\nThese paths should be set in your Pelican settings file by using the setting `PANDOC_DEFAULT_FILES`. The paths may be absolute or relative, but relative paths are recommended as they are more portable.\n\n```python\nPANDOC_DEFAULT_FILES = [\n    "<path/to/default/file_one.yaml>",\n    "<path/to/default/file_two.yaml>",\n]\n```\n\nHere is a minimal example of content that should be available in a Pandoc default file:\n\n```yaml\nreader: markdown\nwriter: html5\n```\n\nUsing default files has the added benefit of allowing you to use other Markdown variants supported by Pandoc, such as [CommonMark](https://commonmark.org/) and [GitHub-Flavored Markdown](https://docs.github.com/en/free-pro-team@latest/github/writing-on-github).\n\nPlease see [Pandoc default files][] for a more complete example.\n\n> ⚠️ **Note:** Neither method supports the `--standalone` or `--self-contained` arguments, which will yield an error if invoked.\n\n### Generating a Table of Contents\n\nIf you want to create a table of contents (ToC) for posts or pages, you may do so by specifying the `--toc` or `--table-of-contents` argument in the `PANDOC_ARGS` setting, as shown below:\n\n```python\nPANDOC_ARGS = [\n    "--toc",\n]\n```\n\n…\xa0or …\n\n```python\nPANDOC_ARGS = [\n    "--table-of-contents",\n]\n```\n\nTo add a ToC via a Pandoc default file, use the syntax below:\n\n```yaml\ntable-of-contents: true\n```\n\nThe table of contents will be available for use in templates using the `{{ article.toc }}` or `{{ page.toc }}` Jinja template variables.\n\n### Enabling Citations\n\nYou may enable citations by specifying the `-C` or `--citeproc` option.\n\nSet the `PANDOC_ARGS` and `PANDOC_EXTENSIONS` in your Pelican settings file as shown below:\n\n```python\nPANDOC_ARGS = [\n    "--citeproc",\n]\n```\n\n… or …\n\n```python\nPANDOC_ARGS = [\n    "-C",\n]\n```\n\nIf you are using a Pandoc default file, you need the following as a bare minimum to enable citations:\n\n```yaml\nreader: markdown\nwriter: html5\n\nciteproc: true\n```\n\nWithout these settings, citations will not be processed by the plugin.\n\nIt is not necessary to specify the `+citations` extension since it is enabled by default. However, if you were to disable citations by specifying `-citations` in `PANDOC_EXTENSIONS` or by setting `reader: markdown-citations` in your default file, citations will **not** work.\n\nYou may write your bibliography in any format supported by Pandoc with the appropriate extensions specified. However, you **must** name the bibliography file the same as your post.\n\nFor example, a post with the file name `my-post.md` should have a bibliography file called `my-post.bib`, `my-post.json`, `my-post.yaml` or `my-post.bibtex` in the same directory as your post, or in a subdirectory of the directory that your blog resides in. Failure to do so will prevent the references from being picked up.\n\n#### Known Issues with Citations\n\nIf enabling citations with a specific style, you need to specify a CSL (Citation Style Language) file, available from the [Zotero Style Repository](https://www.zotero.org/styles). For example, if you are using `ieee-with-url` style file, it may be specified in your Pelican settings file, as shown below:\n\n```python\nPANDOC_ARGS = [\n   "--csl=https://www.zotero.org/styles/ieee-with-url",\n]\n```\n\nOr in a Pandoc default file:\n\n```yaml\ncsl: "https://www.zotero.org/styles/ieee-with-url"\n```\n\nSpecifying a *remote* (that is, not local) CSL file as shown above dramatically increases the time taken to process Markdown content. To improve processing speed, it is _highly_ recommended that you use a local copy of the CSL file downloaded from Zotero.\n\nYou may then reference it in your Pelican settings file as shown below:\n\n```python\nPANDOC_ARGS = [\n   "--csl=path/to/file/ieee-with-url.csl",\n]\n```\n\nOr in a Pandoc default file:\n\n```yaml\ncsl: "path/to/file/ieee-with-url.csl"\n```\n\n### Calculating and Displaying Reading Time\n\nThis plugin may be used to calculate the estimated reading time of articles and pages by setting `CALCULATE_READING_TIME` to `True` in your Pelican settings file:\n\n```python\nCALCULATE_READING_TIME = True\n```\n\nYou may display the estimated reading time using the `{{ article.reading_time }}` or `{{ page.reading_time }}` template variables. The unit of time will be displayed as “minute” for reading times less than or equal to one minute, or “minutes” for those greater than one minute.\n\nThe reading time is calculated by dividing the number of words by the reading speed, which is the average number words read in a minute.\n\nThe default value for reading speed is set to 200 words per minute, but may be customized by setting `READING_SPEED` to the desired words per minute value in your Pelican settings file:\n\n```python\nREADING_SPEED = <words-per-minute>\n```\n\nThe number of words in a document is calculated using the [Markdown Word Count](https://github.com/gandreadis/markdown-word-count) package.\n\nContributing\n------------\n\nContributions are welcome and much appreciated. Every little bit helps. You can contribute by improving the documentation, adding missing features, and fixing bugs. You can also help out by reviewing and commenting on [existing issues][].\n\nTo start contributing to this plugin, review the [Contributing to Pelican][] documentation, beginning with the **Contributing Code** section.\n\nSpecial thanks to [Justin Mayer](https://justinmayer.com), [Erwin Janssen](https://github.com/ErwinJanssen), [Joseph Reagle](https://github.com/reagle) and [Deniz Turgut](https://github.com/avaris) for their improvements and feedback on this plugin.\n\n[existing issues]: https://github.com/pelican-plugins/pandoc-reader/issues\n[Contributing to Pelican]: https://docs.getpelican.com/en/latest/contribute.html\n\nLicense\n-------\n\nThis project is licensed under the AGPL-3.0 license.\n\n[Pelican]: https://getpelican.com\n[Pandoc’s variant of Markdown]: https://pandoc.org/MANUAL.html#pandocs-markdown\n[Pandoc default files]: https://pandoc.org/MANUAL.html#default-files\n',
    'author': 'Nandakumar Chandrasekhar',
    'author_email': 'navanitachora@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/pelican-plugins/pandoc-reader',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
