# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from cognite.seismic.protos import ingest_service_messages_pb2 as cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2
from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2


class IngestStub(object):
    """*
    Service for ingestion and metadata updates of SEG-Y files into Cognite Data Fusion (CDF) seismic datastore

    We use the word `File` to refer to a single seismic file/dataset/cube
    Surveys can have many files attached to them, with different attributes or processing stages, and every file must
    belong to a survey
    The expected order of ingestion is:

    1) Register a survey, if it does not exist

    2) Register a file
    Files are expected to be previously uploaded to a Google Cloud Storage (GCS) bucket at this point, and the service needs
    permission to this bucket in the form of a service account.
    The RegisterFile endpoint will request the survey name or id, bucket address and the CRS used in this file
    (e.g.: EDM50, WGS84), so be sure to have this information prior at hand.

    3) Ingest the file
    If the RegisterFile endpoint completes successfully, and your file is found in the bucket, you can now send a request to
    the IngestFile endpoint, and an asynchronous process will be started remotely to download and process the file.
    You can verify the status of this process by calling the Status endpoint  with the id returned in the IngestFile endpoint

    As soon as the status of the processing job is set to complete, data from the file will be available with the query service

    When a file is registered in a CDF project, this project owns the file. It is then allowed to share access with other
    CDF projects
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.RegisterSurvey = channel.unary_unary(
                '/com.cognite.seismic.Ingest/RegisterSurvey',
                request_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.RegisterSurveyRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.RegisterSurveyResponse.FromString,
                )
        self.RegisterFile = channel.unary_unary(
                '/com.cognite.seismic.Ingest/RegisterFile',
                request_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.RegisterFileRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.RegisterFileResponse.FromString,
                )
        self.IngestFile = channel.unary_unary(
                '/com.cognite.seismic.Ingest/IngestFile',
                request_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.IngestFileRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.IngestFileResponse.FromString,
                )
        self.Status = channel.unary_unary(
                '/com.cognite.seismic.Ingest/Status',
                request_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.StatusRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.StatusResponse.FromString,
                )
        self.DeleteFile = channel.unary_unary(
                '/com.cognite.seismic.Ingest/DeleteFile',
                request_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.DeleteFileRequest.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                )
        self.DeleteSurvey = channel.unary_unary(
                '/com.cognite.seismic.Ingest/DeleteSurvey',
                request_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.DeleteSurveyRequest.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                )
        self.EditFile = channel.unary_unary(
                '/com.cognite.seismic.Ingest/EditFile',
                request_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditFileRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditFileResponse.FromString,
                )
        self.EditSurvey = channel.unary_unary(
                '/com.cognite.seismic.Ingest/EditSurvey',
                request_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditSurveyRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditSurveyResponse.FromString,
                )
        self.ListFileAccess = channel.unary_unary(
                '/com.cognite.seismic.Ingest/ListFileAccess',
                request_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.ListFileAccessRequest.SerializeToString,
                response_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.ProjectListResponse.FromString,
                )
        self.EditFileAccess = channel.unary_unary(
                '/com.cognite.seismic.Ingest/EditFileAccess',
                request_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditFileAccessRequest.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                )
        self.StoreTrace = channel.unary_unary(
                '/com.cognite.seismic.Ingest/StoreTrace',
                request_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.StoreTraceRequest.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                )


class IngestServicer(object):
    """*
    Service for ingestion and metadata updates of SEG-Y files into Cognite Data Fusion (CDF) seismic datastore

    We use the word `File` to refer to a single seismic file/dataset/cube
    Surveys can have many files attached to them, with different attributes or processing stages, and every file must
    belong to a survey
    The expected order of ingestion is:

    1) Register a survey, if it does not exist

    2) Register a file
    Files are expected to be previously uploaded to a Google Cloud Storage (GCS) bucket at this point, and the service needs
    permission to this bucket in the form of a service account.
    The RegisterFile endpoint will request the survey name or id, bucket address and the CRS used in this file
    (e.g.: EDM50, WGS84), so be sure to have this information prior at hand.

    3) Ingest the file
    If the RegisterFile endpoint completes successfully, and your file is found in the bucket, you can now send a request to
    the IngestFile endpoint, and an asynchronous process will be started remotely to download and process the file.
    You can verify the status of this process by calling the Status endpoint  with the id returned in the IngestFile endpoint

    As soon as the status of the processing job is set to complete, data from the file will be available with the query service

    When a file is registered in a CDF project, this project owns the file. It is then allowed to share access with other
    CDF projects
    """

    def RegisterSurvey(self, request, context):
        """*
        Registers a new survey.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RegisterFile(self, request, context):
        """*
        Registers a new file in a (previously registered) survey.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def IngestFile(self, request, context):
        """*
        Sends a request for the ingestion of a registered file into the queue. Will return a job id which can be queried for status.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Status(self, request, context):
        """*
        Retrieves the status of an ingestion job.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeleteFile(self, request, context):
        """*
        Deletes a file
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeleteSurvey(self, request, context):
        """*
        Deletes a survey
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def EditFile(self, request, context):
        """*
        Updates file metadata
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def EditSurvey(self, request, context):
        """*
        Updates survey metadata
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListFileAccess(self, request, context):
        """*
        List projects that have access to a specific file.
        Only users in the CDF project that owns the file have access to this method
        DEPRECATED - multitenant file sharing is not supported anymore
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def EditFileAccess(self, request, context):
        """*
        Add or remove access to a file for CDF projects
        Only users in the CDF project that owns the file have access to this method
        DEPRECATED - multitenant file sharing is not supported anymore
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StoreTrace(self, request, context):
        """*
        Store a single trace to synthetic file/volume
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_IngestServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'RegisterSurvey': grpc.unary_unary_rpc_method_handler(
                    servicer.RegisterSurvey,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.RegisterSurveyRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.RegisterSurveyResponse.SerializeToString,
            ),
            'RegisterFile': grpc.unary_unary_rpc_method_handler(
                    servicer.RegisterFile,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.RegisterFileRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.RegisterFileResponse.SerializeToString,
            ),
            'IngestFile': grpc.unary_unary_rpc_method_handler(
                    servicer.IngestFile,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.IngestFileRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.IngestFileResponse.SerializeToString,
            ),
            'Status': grpc.unary_unary_rpc_method_handler(
                    servicer.Status,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.StatusRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.StatusResponse.SerializeToString,
            ),
            'DeleteFile': grpc.unary_unary_rpc_method_handler(
                    servicer.DeleteFile,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.DeleteFileRequest.FromString,
                    response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            ),
            'DeleteSurvey': grpc.unary_unary_rpc_method_handler(
                    servicer.DeleteSurvey,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.DeleteSurveyRequest.FromString,
                    response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            ),
            'EditFile': grpc.unary_unary_rpc_method_handler(
                    servicer.EditFile,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditFileRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditFileResponse.SerializeToString,
            ),
            'EditSurvey': grpc.unary_unary_rpc_method_handler(
                    servicer.EditSurvey,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditSurveyRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditSurveyResponse.SerializeToString,
            ),
            'ListFileAccess': grpc.unary_unary_rpc_method_handler(
                    servicer.ListFileAccess,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.ListFileAccessRequest.FromString,
                    response_serializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.ProjectListResponse.SerializeToString,
            ),
            'EditFileAccess': grpc.unary_unary_rpc_method_handler(
                    servicer.EditFileAccess,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditFileAccessRequest.FromString,
                    response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            ),
            'StoreTrace': grpc.unary_unary_rpc_method_handler(
                    servicer.StoreTrace,
                    request_deserializer=cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.StoreTraceRequest.FromString,
                    response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'com.cognite.seismic.Ingest', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class Ingest(object):
    """*
    Service for ingestion and metadata updates of SEG-Y files into Cognite Data Fusion (CDF) seismic datastore

    We use the word `File` to refer to a single seismic file/dataset/cube
    Surveys can have many files attached to them, with different attributes or processing stages, and every file must
    belong to a survey
    The expected order of ingestion is:

    1) Register a survey, if it does not exist

    2) Register a file
    Files are expected to be previously uploaded to a Google Cloud Storage (GCS) bucket at this point, and the service needs
    permission to this bucket in the form of a service account.
    The RegisterFile endpoint will request the survey name or id, bucket address and the CRS used in this file
    (e.g.: EDM50, WGS84), so be sure to have this information prior at hand.

    3) Ingest the file
    If the RegisterFile endpoint completes successfully, and your file is found in the bucket, you can now send a request to
    the IngestFile endpoint, and an asynchronous process will be started remotely to download and process the file.
    You can verify the status of this process by calling the Status endpoint  with the id returned in the IngestFile endpoint

    As soon as the status of the processing job is set to complete, data from the file will be available with the query service

    When a file is registered in a CDF project, this project owns the file. It is then allowed to share access with other
    CDF projects
    """

    @staticmethod
    def RegisterSurvey(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Ingest/RegisterSurvey',
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.RegisterSurveyRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.RegisterSurveyResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def RegisterFile(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Ingest/RegisterFile',
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.RegisterFileRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.RegisterFileResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def IngestFile(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Ingest/IngestFile',
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.IngestFileRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.IngestFileResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Status(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Ingest/Status',
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.StatusRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.StatusResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DeleteFile(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Ingest/DeleteFile',
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.DeleteFileRequest.SerializeToString,
            google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DeleteSurvey(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Ingest/DeleteSurvey',
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.DeleteSurveyRequest.SerializeToString,
            google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def EditFile(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Ingest/EditFile',
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditFileRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditFileResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def EditSurvey(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Ingest/EditSurvey',
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditSurveyRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditSurveyResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListFileAccess(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Ingest/ListFileAccess',
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.ListFileAccessRequest.SerializeToString,
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.ProjectListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def EditFileAccess(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Ingest/EditFileAccess',
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.EditFileAccessRequest.SerializeToString,
            google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def StoreTrace(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.cognite.seismic.Ingest/StoreTrace',
            cognite_dot_seismic_dot_protos_dot_ingest__service__messages__pb2.StoreTraceRequest.SerializeToString,
            google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
