"""This file contains text samples to test"""

ARABIC_TEXT = {
    'language': 'ar',
    'text': (
		"الترجمة المنتظمة هي تعيين من نظام واحد للكتابة إلى أخرى، وعادة حرف من حروف اللغة"
		" لحرف من حروف اللغة. معظم أنظمة الترجمة هي واحد الى واحد، لذلك القارئ الذي يعرف "
		"النظام يمكن إعادة الإملائي الأصلي. تعارض الترجمة إلى النسخ، التي تقوم بتعيين أصو"
		"ات لغة واحدة في نظام الكتابة. ومع ذلك، معظم أنظمة الترجمة خريطة الحروف النصي الم"
		"صدر إلى خطابات وضوحا مماثل في البرنامج النصي الهدف، بالنسبة لبعض الأزواج معين من"
		" المصدر واللغة الهدف. إذا كانت العلاقات بين الحروف والأصوات متشابهة في كلا اللغت"
		"ين، قد تكون الحروف قريبة جدا من النسخ. في الواقع، هناك بعض النظم الحروف / نسخ ال"
		"مختلطة التي لغة بحروف لغة أخرى جزءا من السيناريو الأصلي وتدوين بقية. بالنسبة لكث"
		"ير من الأزواج النصي، هناك واحد أو أكثر القياسية نظم الحروف. ومع ذلك، الحروف غير "
		"منتظمة أمر شائع."
    )}

AFRIKAANS_TEXT = {
    'language': 'af',
    'text': (
		"Sistematiese transliterasie is 'n kartering van 'n stelsel van skryf in 'n ander"
		", tipies grafeem om grafeem. Die meeste transliterasie stelsels is een-tot-een, "
		"so 'n leser wat die stelsel kan die oorspronklike spelling rekonstrueer weet. Tr"
		"ansliterasie is gekant teen transkripsie, wat die klanke van 'n taal kaarte in '"
		"n skrif stelsel. Tog, die meeste stelsels van transliterasie karteer die letters"
		" van die bron script om briewe insgelyks uitgespreek in die teiken script, vir '"
		"n paar spesifieke denim bron en doeltaal. As die verhouding tussen letters en kl"
		"anke is soortgelyk in beide tale, kan 'n transliterasie baie naby aan 'n transkr"
		"ipsie wees. In die praktyk is daar is 'n paar gemengde transliterasie / transkri"
		"psie stelsels wat 'n deel van die oorspronklike script translitereer en op skrif"
		" te stel vir die res. Vir baie script pare, daar is een of meer standaard transl"
		"iterasie stelsels. Maar onsistematies transliterasie is algemeen."
    )}

ALBANIAN_TEXT = {
    'language': 'sq',
    'text': (
		"transliterim sistematike është një hartë nga një sistem i të shkruarit në një tj"
		"etër, në mënyrë tipike grapheme për grapheme. Shumica e sistemeve transliterim j"
		"anë një-për-një, kështu që një lexues që e di të sistemit mund të rindërtojë dre"
		"jtshkrimin origjinale. Transliterim është kundër transkriptimit, të cilat hartat"
		" tingujt e një gjuhe në një sistem shkrim. Megjithatë, shumica e sistemeve të tr"
		"ansliterimit hartë shkronjat e shkrimit burim shkronjave shqiptuar në mënyrë të "
		"ngjashme në shkrimin e synuar, për një palë të veçantë të burimit dhe gjuhës syn"
		"uar. Nëse marrëdhëniet midis shkronjave dhe tingujve janë të ngjashme në të dy g"
		"juhët, një transliterim mund të jetë shumë afër një transkriptim. Në praktikë, k"
		"a disa sisteme të përziera transliterim / transkriptimi që transliterimin një pj"
		"esë të shkrimit fillestar dhe hedh në të pastër pjesën tjetër. Për shumë çifte s"
		"hkrimit, nuk është një ose më shumë standarde sistemet transliterim. Megjithatë,"
		" transliterim josistematik është e zakonshme."
    )}

AZERBAIJANI_TEXT = {
    'language': 'az',
    'text': (
		"Sistematik transliterasiya adətən grapheme üçün grapheme, başqa yazılı bir siste"
		"m bir mapping edir. Ən transliterasiya sistemləri orijinal yazım yenidən qurulma"
		"sı bilər sistemi bilən bir oxucu, belə ki, bir-bir var. Transliterasiya bir yazı"
		" sistemi bir dil səsləri xəritələr transkripsiyası, qarşı çıxır. Hələ, translite"
		"rasiya ən sistemləri mənbəyi və hədəf dil bəzi xüsusi cüt üçün hədəf script eyni"
		" tələffüz məktubları mənbə script məktubları xəritəsi. məktubları və səslər aras"
		"ında münasibətlər hər iki dildə oxşar varsa, transliterasiya bir transkripsiyası"
		" çox yaxın ola bilər. Təcrübədə, orijinal script bir hissəsini transliterate və "
		"istirahət uyarlamak bəzi qarışıq transliterasiya / transkripsiyası sistemi var. "
		"çox script cüt üçün bir və ya daha çox standart transliterasiya sistemləri var. "
		"Lakin, sistemsiz transliterasiya ümumi."
    )}

BASQUE_TEXT = {
    'language': 'eu',
    'text': (
		"Sistematikoa transliterazio idazkera sistema batetik mapping bat beste bat sartu"
		" da, normalean grafema to grafema. transliterazio sistema gehienak bat-bateko di"
		"ra, irakurleak bat sisteman jatorrizko ortografia berreraikitzeko ahal daki orai"
		"n. Transliterazioa transkripzioa, eta horrek hizkuntza bat soinuak mapak idatziz"
		" sistema bat sartu aurka. Hala ere, transliterazio-sistema mapa iturburua gidoia"
		" hizkiak antzera nabarmenagoa helburu gidoia ere, iturri eta xede hizkuntza pare"
		" zehatz batzuen letrak dira. letrak eta soinuak arteko harremanak bi hizkuntzeta"
		"n antzeko badira, transliterazio oso transkripzio bat hurbil daitezke. Praktikan"
		", zenbait mistoa transliterazio / transkripzio-sistemak jatorrizko gidoia zati b"
		"at transliteratu dela eta gainerakoak transkribatu daude. gidoia bikote askorent"
		"zat, transliterazio-sistemak bat edo gehiago estandarra ez da. Hala ere, unsyste"
		"matic transliterazio ohikoa da."
    )}

CATALAN_TEXT = {
    'language': 'ca',
    'text': (
		"transliteració sistemàtica és un mapatge d'un sistema d'escriptura a un altre, g"
		"eneralment grafema a grafema. La majoria dels sistemes de transliteració són una"
		"-un, de manera que un lector que coneix el sistema pot reconstruir l'ortografia "
		"original. Transliteració s'oposa a la transcripció i que correlaciona els sons d"
		"'una llengua a un sistema d'escriptura. Tot i així, la majoria dels sistemes de "
		"transliteració mapa les lletres de l'escriptura d'origen a les lletres pronuncia"
		"des de manera similar en el guió de destinació, per algun parell específic d'idi"
		"oma d'origen i de destinació. Si les relacions entre les lletres i els sons són "
		"similars en les dues llengües, una transliteració pot ser molt a prop d'una tran"
		"scripció. A la pràctica, hi ha alguns sistemes de transliteració / transcripció "
		"mixtes que Transliterate una part de el guió original i transcriure la resta. Pe"
		"r a molts parells de seqüències d'ordres, hi ha un o més sistemes de translitera"
		"ció estàndard. No obstant això, no sistemàtica transliteració és comú."
    )}

CORSICAN_TEXT = {
    'language': 'co',
    'text': (
		"inglesu sistimàticu hè una aerial da unu sistemu di scrittura in un altru, tipic"
		"amenti grapheme à grapheme. Most sistemi inglesu sò unu-in-una, tantu un lettore"
		" chì cunnosce u sistema pò reconstruct la ortografia originale. Inglesu hè cuntr"
		"aria à trasciziona, chì hè u populu corsu di una lingua in un sistema di scrittu"
		"ra. Ancora, più sistemi di inglesu mappa lu russu di lu meroìticu surghjente di "
		"littri prununzia simile in lu meroìticu testu, per qualchi paru specifichi di su"
		"rgente è lingua testu. Sè l 'rilazzioni tra russu e populu corsu sò simile à dui"
		" lingue, un inglesu pò esse assai vicinu à una trasciziona. In pratica, ci sò pa"
		"rechji sistemi inglesu / trasciziona mixte chì, transliterate una parti di u tes"
		"tu uriginale è transcribe u restu. Per parechje paghje scrittura, ci hè una o pi"
		"ù mudellu sistemi inglesu. Tuttavia, inglesu unsystematic hè cumuna."
    )}

CROATIAN_TEXT = {
    'language': 'hr',
    'text': (
		"Sustavno transliteracija je mapiranje iz jednog sustava u pisanom obliku u drugi"
		", obično grafem za grafem. Većina transliteracije sustavi su jedan-na-jedan, tak"
		"o da čitatelj koji poznaje sustav može rekonstruirati izvorni oblik. Translitera"
		"cija razliku od transkripcije, koja mapira zvukove jednog jezika u sustav pisanj"
		"a. Ipak, većina sustava transliteracije kartu slova izvornog pisma na slova izre"
		"čenih slično u ciljnoj pismu, za neki određeni par izvorni i ciljni jezik. Ako s"
		"u odnosi između slova i zvukova su slični u oba jezika, transliteracija može bit"
		"i vrlo blizu transkripcije. U praksi postoje neki mješoviti transliteraciju / tr"
		"anskripcija sustavi koji prekodirati dio originalnog pisma i prepisati ostatak. "
		"Za mnoge skripte parova, postoji jedno ili više standardnih transliteracije sust"
		"ava. Međutim, nesustavno transliteracija zajedničko."
    )}

CZECH_TEXT = {
    'language': 'cs',
    'text': (
		"Systematické přepis je mapování z jednoho systému psaní do druhého, obvykle graf"
		"ém na grafém. Většina přepisu systémy jsou one-to-one, takže čtenář, který zná s"
		"ystém lze rekonstruovat původní pravopis. Přepis je proti přepisu, která mapuje "
		"zvuky jednoho jazyka do systému psaní. Přesto, že většina systémů přepisu mapují"
		" dopisy ve zdrojovém skriptu do dopisů vyslovují podobně jako v cílovém skriptu "
		"pro nějakou specifickou dvojicí zdroje a cílového jazyka. Zda jsou vztahy mezi p"
		"ísmeny a zvuky jsou podobné v obou jazycích, přepis může být velmi blízko k tran"
		"skripci. V praxi existují smíšené přepis / transkripční systémy, které přepsat č"
		"ást původního scénáře a přepsat zbytek. Pro mnoho párů skriptu, tam je jeden neb"
		"o více standardních přepisu systémy. Nicméně, nesystémové přepis je běžné."
    )}

DANISH_TEXT = {
    'language': 'da',
    'text': (
		"Systematisk omskrivning er en kortlægning fra et system af indskrivningen i en a"
		"nden, typisk Grapheme at grafem. De fleste translitteration systemer er en-til-e"
		"n, så en læser, der kender systemet kan rekonstruere den oprindelige stavemåde. "
		"Translitteration er imod transskription, der kortlægger lyden af ​​et sprog til "
		"et skriftsystem. Alligevel fleste systemer af translitteration kortlægge bogstav"
		"erne i kilden script til breve udtales på samme måde i målet scriptet, for nogle"
		" specifikke par kilde- og målsprog. Hvis forholdet mellem bogstaver og lyde er e"
		"ns i begge sprog, kan en translitteration være meget tæt på en transskription. I"
		" praksis er der nogle blandede translitteration / transskription systemer, der o"
		"mskrive en del af den oprindelige manuskript og transskribere resten. For mange "
		"script par, der er en eller flere standard translitteration systemer. Men usyste"
		"matisk omskrivning er fælles."
    )}

DUTCH_TEXT = {
    'language': 'nl',
    'text': (
		"Systematische transcriptie is een afbeelding van een systeem om te schrijven naa"
		"r een andere, typisch handschrift naar handschrift. De meeste transcriptie syste"
		"men zijn een-op-een, dus een lezer die het systeem kan de oorspronkelijke spelli"
		"ng te reconstrueren kent. Transliteratie is tegen transcriptie, die de klanken v"
		"an de ene taal kaarten in een schrift. Toch, de meeste systemen van transcriptie"
		" in kaart de letters van de bron script om letters op dezelfde manier uitgesprok"
		"en in het doel script, voor een aantal specifieke paar bron- en doeltaal. Als de"
		" relatie tussen letters en klanken zijn vergelijkbaar in beide talen, kan een tr"
		"anscriptie zeer dicht bij een transcriptie. In de praktijk zijn er enkele gemeng"
		"de transcriptie / transcriptiesystemen dat een deel van het oorspronkelijke schr"
		"ift translitereren transcriberen en de rest. Voor veel script paren, is er één o"
		"f meer standaard transcriptie systemen. Echter, niet-systematische transcriptie "
		"is gemeenschappelijk."
    )}

ENGLISH_TEXT = {
    'language': 'en',
    'text': (
		"Systematic transliteration is a mapping from one system of writing into another,"
		" typically grapheme to grapheme. Most transliteration systems are one-to-one, so"
		" a reader who knows the system can reconstruct the original spelling. Transliter"
		"ation is opposed to transcription, which maps the sounds of one language in'to' a "
		"writing system. Still, most systems of transliteration map the letters of the so"
		"urce script to letters pronounced similarly in the target script, for some speci"
		"fic pair of source and target language. I'f' the relations between letters and sou"
		"nds are similar in both languages, 'a' transliteration may be very close to a tran"
		"scription. In practice, there are some mixed transliteration/transcription syste"
		"ms that transliterate a part of the original script and transcribe the rest. For"
		" many script pairs, there is one or more standard transliteration systems. Howev"
		"er, unsystematic transliteration is common."
    )}

ESPERANTO_TEXT = {
    'language': 'eo',
    'text': (
		"Sistema transliterumo estas surĵeto de unu sistemo de skribo en alian, kutime gr"
		"afemo al grafemo. Plej transliterumo sistemoj estas unu-al-unu, do leganto kiu s"
		"cias la sistemo povas rekonstrui la originalan ortografion. Transliteration kont"
		"raŭas transskribo, kiu mapas la sonojn de unu lingvo en skribsistemo. Ankoraŭ, p"
		"lej sistemoj de transliterado mapi la literoj de la fonto skribo al literoj pron"
		"oncata simile en la celon skribo, por iu specifa paro de fonto kaj cellingvon. S"
		"e la rilatoj inter literoj kaj sonoj estas similaj en ambaŭ lingvoj, translitera"
		"ción eble tre proksimaj al transskribo. Praktike, estas kelkaj miksitaj translit"
		"erumo / transskribo sistemoj kiuj transliteran parto de la originala skripto kaj"
		" transskribi la reston. Dum multaj skribo paroj, ekzistas unu aŭ pli normo trans"
		"literumo sistemoj. Tamen, unsystematic transliterumo estas ofta."
    )}

ESTONIAN_TEXT = {
    'language': 'et',
    'text': (
		"Süstemaatiline transliteratsioon on kaardistamise ühest süsteemi kirjalikult tei"
		"se, tavaliselt Grapheme et Grapheme. Enamik transliteratsiooni süsteemid on üks-"
		"ühele, nii lugeja, kes teab süsteem võib rekonstrueerida algse õigekirja. Transl"
		"iteratsioonitöötlus erinevalt transkriptsiooni, mis kaardistab helide ühest keel"
		"est kirjalikult süsteemi. Siiski, enamik süsteeme transliteratsiooni map tähtede"
		"ga allika skripti tähed hääldatakse sarnaselt eesmärgi skripti, mõne konkreetse "
		"paari lähte- ja sihtkeele. Kui suhted tähed ja helid on sarnane mõlemas keeles, "
		"transliteratsiooni võib olla väga lähedal transkriptsiooni. Praktikas on mõned s"
		"egatud transliteratsioon / transkriptsiooni süsteeme, mis Translitteroida osa al"
		"gupärane kirjaviis ja transkribeerida puhata. Paljude skripti paari, seal on üks"
		" või mitu standard transliteratsiooni süsteemid. Kuid süsteemitult transliterats"
		"ioon ühist."
    )}

FILIPINO_TEXT = {
    'language': 'tl',
    'text': (
		"Systematic transliteration ay isang paggawa ng mga mapa mula sa isang sistema ng"
		" pagsulat sa isa pang, karaniwang Grapheme na Grapheme. Karamihan sa translitera"
		"tion system ay isa-sa-isa, kaya ang isang reader na nakakaalam ng system ay maaa"
		"ring buuin muli ang orihinal na pagbabaybay. Transliteration ay taliwas sa trans"
		"cription, na mga mapa ang mga tunog ng isang wika sa isang sistema ng pagsulat. "
		"Still, karamihan sa mga sistema ng transliteration i-map ang mga titik ng source"
		" script na titik binibigkas katulad sa target na script, para sa ilang tiyak na "
		"mga pares ng pinagmulan at target na wika. Kung ang relasyon sa pagitan ng mga t"
		"itik at mga tunog ay katulad sa parehong wika, ang isang literal na pagsasalin a"
		"y maaaring maging napaka-malapit sa isang transcription. Sa pagsasagawa, mayroon"
		"g ilang mga halo-halong transliteration / transcription system na transliterasyo"
		"n ng isang bahagi ng orihinal na script at isulat sa ibang papel ang natitira. P"
		"ara sa maraming mga pares script, mayroong isa o higit pang mga karaniwang trans"
		"literation sistema. Gayunman, hindi maparaan transliteration ay pangkaraniwan."
    )}

FINNISH_TEXT = {
    'language': 'fi',
    'text': (
		"Systemaattinen translitterointi on kuvaus yhdestä järjestelmästä kirjoittamisen "
		"toiseen, tyypillisesti grapheme jotta grapheme. Useimmat translitteroinnin järje"
		"stelmät ovat yksi-yhteen, niin lukija, joka tuntee järjestelmän voi rekonstruoid"
		"a alkuperäisen oikeinkirjoituksen. Translitterointi vastustaa transkription, jok"
		"a kartoittaa äänet yhden kielen osaksi kirjoitusjärjestelmän. Silti useimmat jär"
		"jestelmät translitterointijärjestelmän kartta kirjaimet lähteen script kirjaimet"
		" lausutaan samalla kohde käsikirjoituksen, sillä tiettyjä lähde- ja kohdekielen."
		" Jos suhteiden kirjaimet ja äänet ovat samanlaiset molemmilla kielillä, translit"
		"teraatio voi olla hyvin lähellä transkription. Käytännössä on olemassa joitakin "
		"sekoitettu translitteroinnin / transskriptiosysteemejä että translitteroida osa "
		"alkuperäisen käsikirjoituksen ja puhtaaksi loput. Monille käsikirjoitus paria, o"
		"n yksi tai useampi standardi translitterointia järjestelmiä. Kuitenkin epäjärjes"
		"telmällinen translitterointi on yhteinen."
    )}

FRENCH_TEXT = {
    'language': 'fr',
    'text': (
		"translittération systématique est une application d'un système d'écriture à une "
		"autre, typiquement à graphème graphèmes. La plupart des systèmes de translittéra"
		"tion sont un à un, donc un lecteur qui connaît le système peut reconstituer l'or"
		"thographe d'origine. Translittération est opposé à la transcription, qui associe"
		" les sons d'une langue dans un système d'écriture. Pourtant, la plupart des syst"
		"èmes de translittération carte les lettres du script source à lettres prononcé d"
		"e la même dans le script cible, pour une paire spécifique de la source et la lan"
		"gue cible. Si les relations entre les lettres et les sons sont similaires dans l"
		"es deux langues, une translittération peut être très proche d'une transcription."
		" Dans la pratique, il existe des systèmes translittération / transcription mixte"
		"s qui translittération une partie du script original et de retranscrire le reste"
		". Pour beaucoup de paires de script, il y a un ou plusieurs systèmes de translit"
		"tération standard. Cependant, translittération est commun non systématique."
    )}

GALICIAN_TEXT = {
    'language': 'gl',
    'text': (
		"transliteración sistemática é un mapeamento a partir dun sistema de escrita para"
		" outro, normalmente grafema para grafema. A maioría dos sistemas de transliterac"
		"ión son un a un, para un lector que coñece o sistema pode reconstruír a grafia o"
		"rixinal. Transliteración oponse á transcrición, que mapea os sons dunha lingua a"
		" un sistema de escritura. Aínda así, a maioría dos sistemas de transliteración m"
		"apear as letras do guión fonte para letras pronunciadas do mesmo xeito no guión "
		"de destino, para algúns par específico de fonte e lingua. As relacións entre let"
		"ras e sons son semellantes en ambas as linguas, unha transliteración pode estar "
		"moi preto dunha transcrición. Na práctica, hai algúns sistemas de transliteració"
		"n / transcrición mixtos que Transliterate unha parte do guión orixinal e transcr"
		"ibir o resto. Para moitos pares de guión, hai un ou máis estándar sistemas de tr"
		"ansliteración. Con todo, transliteración assistemática é común."
    )}

GERMAN_TEXT = {
    'language': 'de',
    'text': (
		"Systematic Transliteration ist eine Abbildung von einem System zum Schreiben in "
		"eine andere, in der Regel Graphem Graphem. Die meisten Umschrift Systeme sind ei"
		"ne Eins-zu-eins, so ein Leser, der das System kennt, kann die ursprüngliche Schr"
		"eibweise rekonstruieren. Umschrift auf Transkription gegenüber, die Karten die K"
		"länge einer Sprache in einem Schreibsystem. Dennoch sind die meisten Systeme der"
		" Umschrift ausgesprochen ähnlich im Ziel Skript für einige spezifische Paar von "
		"Quell- und Zielsprache, die Buchstaben des Quell Skript Buchstaben zuordnen. Wen"
		"n die Beziehungen zwischen Buchstaben und Lauten in beiden Sprachen ähnlich sind"
		", kann eine Umschrift zu einer Transkription sehr nahe sein. In der Praxis gibt "
		"es einige gemischte Umschrift / Transkriptionssysteme, die einen Teil des ursprü"
		"nglichen Skript transkribieren und den Rest transkribieren. Für viele Skriptpaar"
		"e gibt es eine oder mehrere Standard Umschrift Systeme. Allerdings unsystematisc"
		"h Umschrift ist üblich."
    )}

CREOLE_TEXT = {
    'language': 'ht',
    'text': (
		"Sistematik Transliteration se yon kat soti nan yon sistèm nan ekri nan yon lòt, "
		"tipikman grafèm grafèm. Pifò sistèm Transliteration se youn-a-youn, se konsa yon"
		" lektè ki konnen sistèm nan ka rekonstwi òtograf orijinal la. Tradiksyon se te o"
		"poze ak transcription, ki kat son yo pale yon sèl lang nan yon sistèm ekri. Touj"
		"ou, pi sistèm nan Transliteration kat lèt yo nan script la sous nan lèt pwononse"
		" Menm jan an tou nan script la sib, pou kèk pè espesifik nan sous ak lang sib. S"
		"i relasyon ki genyen ant lèt ak son yo sanble nan tou de lang, yon Transliterati"
		"on pouvwa gen anpil fèmen nan yon transcription. Nan pratik, gen kèk sistèm Tran"
		"sliteration / transcription nasyon ki translitere yon pati nan script la orijina"
		"l ak transkripsyon rès la. Pou pè script anpil, gen yon sèl oswa plis estanda si"
		"stèm Transliteration. Sepandan, unsystematic Transliteration se komen."
    )}

HAUSA_TEXT = {
    'language': 'ha',
    'text': (
		"-Din-din kalma da wani harshen ne a Taswirar daga daya tsarin rubuce-rubuce a ci"
		"kin wani, yawanci grapheme zuwa grapheme. Mai kalma da wani harshen tsarin ne da"
		"ya-to-daya, don haka mai karatu wanda ya san tsarin iya sake gina asali kuskure."
		" Kalma da wani harshen da aka yi tsayayya da kwafi, wanda maps sauti na daya da "
		"harshen cikin wani rubutu. Duk da haka, mafi tsarin kalma da wani harshen map da"
		" haruffa na tushen rubutun zuwa haruffa furta kamar wancan a cikin manufa rubutu"
		"n, domin wasu takamaiman biyu daga tushen da kuma manufa harshe. Idan dangantaka"
		" tsakanin haruffa da sautuna ne irin wannan a duka biyu harsuna, a kalma da wani"
		" harshen iya zama sosai a kusa da wani kwafi. A yi, akwai wasu gauraye kalma da "
		"wani harshen / kwafi tsarin cewa transliterate wani ɓangare na asali rubutun da "
		"rubũtunsa da sauran. Domin da yawa rubutun nau'i-nau'i, akwai daya ko fiye da mi"
		"sali kalma da wani harshen tsarin. Duk da haka, unsystematic kalma da wani harsh"
		"en da na kowa."
    )}

HUNGARIAN_TEXT = {
    'language': 'hu',
    'text': (
		"Szisztematikus átírás egy leképezés egy írásrendszert egy másik, jellemzően graf"
		"éma a graféma. A legtöbb átírási rendszerek egy-egy, így egy olvasó, aki tudja, "
		"hogy a rendszer képes rekonstruálni az eredeti helyesírást. Az átírás ellenzi tr"
		"anszkripció, ami leképezi a hangok egyik nyelvről egy írásrendszert. Mégis, a le"
		"gtöbb rendszerek átírási térkép a betűket a forrás szkript levelek ejtik hasonló"
		"an a cél script, néhány különleges pár forrás- és célnyelvi. Ha a kapcsolatokat "
		"a betűk és a hangok hasonlóak mindkét nyelven, átírás közel lehet a transzkripci"
		"ó. A gyakorlatban vannak olyan vegyes átírás / transzkripciós rendszerek átír eg"
		"y része az eredeti forgatókönyvet, és átírja a többit. Sok script pár, van egy v"
		"agy több standard átírási rendszereket. Azonban rendszertelen átírási gyakori."
    )}

ICELANDIC_TEXT = {
    'language': 'is',
    'text': (
		"Kerfisbundin umritun er kortlagning frá einu kerfi skrifa í annað, oftast kennt "
		"við kennt. Flest umritun kerfi eru einn-á-einn, þannig að lesanda sem þekkir ker"
		"fið geta endurgera upprunalegu stafsetningu. Umritun er öfugt við umritun, sem k"
		"ortunum hljóð einu tungumáli í skrifa kerfi. Enn, flest kerfi umritun kortleggja"
		" stafina uppspretta handriti bréfum áberandi á svipaðan hátt í miða handriti, fy"
		"rir einhverjum tilteknum par af uppruna og markmálinu. Ef samskipti bókstöfum og"
		" hljóðum eru svipuð í báðum tungumálum, umritun getur verið mjög nálægt því að u"
		"mritun. Í reynd eru nokkur blönduð umritun / uppskrift kerfi sem umrita hluti af"
		" upprunalegu handriti og skrifa restina. Fyrir mörgum pörum handrit, það er ein "
		"eða fleiri stöðluð umritun kerfi. Hins vegar óskipulegan umritun er algengt."
    )}

IGBO_TEXT = {
    'language': 'ig',
    'text': (
		"Ịhazi ndegharị bụ a nkewa site na otu usoro nke edere n'ime ọzọ, a na grapheme k"
		"a grapheme. Kasị ndegharị usoro bụ otu-na-otu, otú a na-agụ onye maara usoro nwe"
		"re ike ikwu ụzọ mbụ nsupe. Ndegharị-emegide transcription, nke map ụda nke otu a"
		"sụsụ n'ime a ide usoro. Ma, ọtụtụ usoro ndegharị map akwụkwọ ozi nke isi iyi scr"
		"ipt ka akwụkwọ ozi akpọ n'otu aka ahụ, na lekwasịrị script, n'ihi na ụfọdụ kpọmk"
		"wem ụzọ nke isi na lekwasịrị asụsụ. Ọ bụrụ na ndị mmekọahụ n'etiti akwụkwọ ozi n"
		"a ụda yiri nke asụsụ abụọ, a ndegharị nwere ike ịbụ nnọọ nso a transcription. Na"
		" omume, e nwere ụfọdụ mbuaha ndegharị / transcription systems na transliterate a"
		" akụkụ nke mbụ edemede na transcribe ndị ọzọ. N'ihi na ọtụtụ ndị script ụzọ abụọ"
		", e nwere otu onye ma ọ bụ karịa ọkọlọtọ ndegharị usoro. Otú ọ dị, unsystematic "
		"ndegharị bụ."
    )}

INDONESIAN_TEXT = {
    'language': 'id',
    'text': (
		"transliterasi sistematis adalah pemetaan dari satu sistem penulisan ke yang lain"
		", biasanya grafem ke grafem. Kebanyakan sistem transliterasi adalah satu-ke-satu"
		", sehingga pembaca yang tahu sistem dapat merekonstruksi ejaan aslinya. Translit"
		"erasi menentang transkripsi, yang memetakan suara satu bahasa ke dalam sistem pe"
		"nulisan. Namun, sebagian besar sistem transliterasi memetakan huruf dari source "
		"script untuk huruf diucapkan sama dalam naskah sasaran, untuk beberapa pasangan "
		"tertentu sumber dan bahasa target. Jika hubungan antara huruf dan suara yang sam"
		"a pada kedua bahasa, transliterasi mungkin sangat dekat dengan transkripsi. Dala"
		"m prakteknya, ada beberapa sistem transliterasi / transkripsi campuran yang tran"
		"sliterasi bagian dari naskah asli dan menuliskan sisanya. Bagi banyak pasangan n"
		"askah, ada satu atau lebih standar sistem transliterasi. Namun, transliterasi ti"
		"dak sistematis adalah umum."
    )}

IRISH_TEXT = {
    'language': 'ga',
    'text': (
		"Is transliteration córasach ar mapála ó chóras amháin na scríbhneoireachta istea"
		"ch i gceann eile, de ghnáth grapheme a grapheme. Tá formhór na gcóras transliter"
		"ation duine le duine, mar sin léitheoir a bhfuil aithne aige ar an gcóras is féi"
		"dir athfhoirgniú an litriú bunaidh. Traslitrithe gcoinne trascríobh, a mhapálann"
		" na fuaimeanna na teanga amháin isteach i gcóras scríbhneoireachta. Fós, córais "
		"is de transliteration léarscáil ar na litreacha an script foinse do litreacha pr"
		"onounced dul céanna sa sprioc script, i gcás roinnt péire ar leith de foinse agu"
		"s sprioctheanga. Má tá an caidreamh idir litreacha agus fuaimeanna den chineál c"
		"éanna sa dá theanga, is féidir traslitriú a bheith an-gar do trascríobh. Go prai"
		"ticiúil, tá roinnt córais transliteration / trascríobh measctha a Transliterate "
		"cuid den script bunaidh agus transcribe an chuid eile. I gcás go leor péirí scri"
		"pt, tá córais transliteration níos caighdeánaí amháin nó. Mar sin féin, tá trans"
		"literation unsystematic coitianta."
    )}

ITALIAN_TEXT = {
    'language': 'it',
    'text': (
		"traslitterazione sistematica è una mappatura da un sistema di scrittura in un al"
		"tro, in genere grafema a grafema. La maggior parte dei sistemi di traslitterazio"
		"ne sono uno-a-uno, in modo da un lettore che conosce il sistema è in grado di ri"
		"costruire la grafia originaria. La traslitterazione si oppone alla trascrizione,"
		" che mappa i suoni di una lingua in un sistema di scrittura. Eppure, la maggior "
		"parte dei sistemi di traslitterazione mappa lettere di script source alle letter"
		"e pronunciate in modo simile nello script di destinazione, per qualche coppia sp"
		"ecifica di origine e lingua di destinazione. Se i rapporti tra lettere e suoni s"
		"ono simili in entrambe le lingue, una traslitterazione può essere molto vicino a"
		" una trascrizione. In pratica, ci sono alcuni sistemi di traslitterazione / tras"
		"crizione misti che traslitterare una parte del copione originale e trascrivere i"
		"l resto. Per molte coppie di script, v'è uno o più standard sistemi di traslitte"
		"razione. Tuttavia, traslitterazione non sistematico è comune."
    )}

KURDISH_TEXT = {
    'language': 'ku',
    'text': (
		"transliteration sîstematîk a Maşallah ji yek sîstema nivîsandina nav din e, bi p"
		"iranî tirsok bo tirsok. Piraniya pergalên transliteration yek-bi-yek in, da ku x"
		"wendevan ku sîstema dikarin spelling original avedankirina dizane. Wergerê lê ji"
		" bo jibergirtin, ku maps dengên yek ziman nav pergala nivîsandinê dijî. Dîsa jî,"
		" pirraniya sîstemên transliteration Nexşa tîpên alfabeya çavkanî bi tîpên wesan "
		"di skrîptê de hatine hedef tê bilêvkirin, ji bo hin pair taybetî yên source û zi"
		"manê hedef. Eger têkiliyên di navbera nameyan û dengên her du zimanan de dişibin"
		" hev in, a transliteration Dibe ku pir nêzîkî jibergirtin. Di pratîkê de, hin sî"
		"stemên transliteration / jibergirtin pirreng ku transliterate beşek ji script or"
		"îjînal û deşîfre din hene. Ji bo gelek cotên script, e yek an standard zêdetir s"
		"îstemên transliteration hene. Lê belê, transliteration unsystematic hevpar e."
    )}

LATIN_TEXT = {
    'language': 'la',
    'text': (
		"Nomina Systematica Translation est mapping ratio de uno in aliud scribere, graph"
		"eme est typically grapheme. Most Translation systems sint unius ad unum, sic eni"
		"m legit et scit enim ratio potest in originali robustam dulcemque reficiendam or"
		"thographiam. Transliteration enim opponitur transcribenda, quod maps est autem s"
		"onitus verbis in scripto ratio. Adhuc, maxime systems Translation of map litteri"
		"s scriptum est fons litterarum locutus est scriptor scopum nec in hoc quod, quib"
		"usdam certis de fonte par et scopum lingua. Si similes effecit inter libros utri"
		"usque linguae de vicina transcribenda Translation simus. In usu sunt quaedam mix"
		"ta Translation / systems qui transcriptum transliterate originali pars ex transc"
		"ribit legere poterant, et cetera. Quia multi legere paria, ibi est una aut magis"
		" vexillum Translation systems. Sed libris Translation commune est."
    )}

LATVIAN_TEXT = {
    'language': 'lv',
    'text': (
		"Sistemātiska transliterācija ir kartēšanas no vienas sistēmas rakstiski uz citu,"
		" parasti Grafēma uz Grafēma. Vairums transliterācijas sistēmas ir viens pret vie"
		"nu, tāpēc lasītāju, kurš zina sistēmu, var rekonstruēt oriģinālo rakstību. Trans"
		"literāciju pretstatā transkripcijas, kas kartes skaņas vienas valodas rakstīšana"
		"s sistēmā. Joprojām lielākā daļa sistēmas transliterācijas kartētu burtus avota "
		"skriptu uz vēstulēm izruna ir līdzīga mērķa skriptu, kādu konkrētu pāri avota un"
		" mērķa valodu. Ja attiecības starp burtu un skaņu ir līdzīgas abās valodās, tran"
		"sliterācija var būt ļoti tuvu transkripcija. Praksē ir daži jauktas transliterāc"
		"ija / transkripcijas sistēmas, kas transliterēt daļu no oriģinālā rakstībā un tr"
		"anskribēt pārējo. Daudziem skriptu pāriem, ir viena vai vairākas standarta trans"
		"literācijas sistēmām. Tomēr nesistemātiska transliterācija kopīgs."
    )}

LITHUANIAN_TEXT = {
    'language': 'lt',
    'text': (
		"Sistemingai transliteracija yra kartografavimas iš vienos sistemos rašymo į kitą"
		", paprastai grafemos į grafemos. Dauguma transliteracijos sistemos yra vienas pr"
		"ie vieno, todėl skaitytojas, kuris žino sistema gali rekonstruoti originalią raš"
		"ybą. Transliteracija nepritaria transkripcija, kuri žemėlapiai vienos kalbos gar"
		"sus į rašymo sistemą. Vis dėlto, dauguma sistemos transliteracijos žemėlapį šalt"
		"inio scenarijų laiškus raidžių tariamos panašiai tikslinės scenarijų, kai konkre"
		"čios poros šaltinį ir tikslinę kalbą. Jei tarp raidžių ir garsų santykiai yra pa"
		"našūs abiem kalbomis, transliteracijos gali būti labai arti transkripcijos. Prak"
		"tikoje yra keletas mišrių transliteracija / transkripcijos sistemas, kurios tran"
		"sliteracija originalaus scenarijaus dalis ir užrašius poilsio. Jau daugelį scena"
		"rijų poromis, yra vienas ar daugiau standartinių transliteracijos sistemos. Tači"
		"au, nesisteminis transliteracija yra bendra."
    )}

MALAGASY_TEXT = {
    'language': 'mg',
    'text': (
		"Systematic Transliteration dia saritany avy amin'ny rafitra iray nanoratana ho n"
		"y iray hafa, matetika grapheme ny grapheme. Ny ankamaroan'ny rafitra Translitera"
		"tion dia iray-to-ny iray, Dia toy izany ny mpamaky izay mahafantatra ny rafitra "
		"am-boalohany dia afaka hanangana indray ny tsipelina. Transliteration dia manohi"
		"tra ny transcription, izay Manapa ny feon'ny fiteny iray an-tsoratra rafitra. Na"
		" izany aza, ny ankamaroan'ny rafitra Transliteration sarintany ny taratasy avy a"
		"min'ny loharanom-baovao nanonona soratra amin'ny taratasy koa ao amin'ny soratra"
		" kendrena, ho an'ny sasany mpivady manokana ny loharano sy ny ampinga lehibe fit"
		"eny. Raha ny fifandraisana eo amin'ny taratasy sy ny feo dia mitovy amin'ny fite"
		"ny roa, dia Transliteration Mety ho tena akaiky ny transcription. Amin'ny fomba "
		"fanao, misy mifangaro Transliteration / transcription rafitra izay transliterate"
		" anisan'ny soratra tany am-boalohany, ary hanoratra ny sisa. Ho an'ny maro teny "
		"tsiroaroa, dia misy fitsipika iray na maromaro Transliteration rafitra. Na izany"
		" aza, unsystematic Transliteration mahazatra."
    )}

MALAY_TEXT = {
    'language': 'ms',
    'text': (
		"transliterasi sistematik adalah pemetaan dari satu sistem penulisan kepada yang "
		"lain, biasanya grapheme untuk grafem. Kebanyakan sistem transliterasi adalah sat"
		"u-sama-satu, jadi pembaca yang tahu sistem boleh membina semula ejaan asal. Tran"
		"sliteration menentang transkripsi, yang memetakan bunyi satu bahasa kepada siste"
		"m tulisan. Namun, kebanyakan sistem transliterasi memetakan huruf skrip sumber u"
		"ntuk huruf dilafazkan sama dalam tulisan sasaran, bagi sesetengah pasangan terte"
		"ntu sumber dan bahasa sasaran. Jika hubungan antara huruf dan bunyi adalah sama "
		"dalam kedua-dua bahasa, transliterasi yang boleh menjadi sangat dekat dengan tra"
		"nskripsi a. Dalam amalan, terdapat beberapa campuran sistem transliterasi / tran"
		"skripsi yang mengalih huruf sebahagian daripada skrip asal dan menyalin yang lai"
		"n. Bagi kebanyakan pasangan skrip, terdapat satu atau lebih standard sistem tran"
		"sliterasi. Walau bagaimanapun, transliterasi sistematik adalah perkara biasa."
    )}

MALTESE_TEXT = {
    'language': 'mt',
    'text': (
		"trażlitterazzjoni sistematika hija immappjar minn sistema tal-kitba għal ieħor, "
		"tipikament grapheme għall grapheme. Sistemi trasliterazzjoni aktar huma wieħed g"
		"ħal wieħed, hekk qarrej li jaf is-sistema tista 'tirrikostitwixxi l-ortografija "
		"oriġinali. Transliterazzjoni huwa kontra traskrizzjoni, li mapep l-ħsejjes tal-l"
		"ingwa waħda f'sistema miktub. Still, ħafna sistemi ta 'trasliterazzjoni mappa l-"
		"ittri tas-sors l-iskrittura għall-ittri ppronunzjata bl-istess mod fl-iskrittura"
		" mira, għal xi par speċifiku ta' sors u l-lingwa mira. Jekk ir-relazzjonijiet be"
		"jn l-ittri u ħsejjes huma simili fiż-żewġ lingwi, tranżlitterazzjoni jista 'jkun"
		" qrib ħafna għal traskrizzjoni. Fil-prattika, hemm xi sistemi mħallta trażlitter"
		"azzjoni / traskrizzjoni li ssir it parti mill-kitba oriġinali u tifformulaha l-b"
		"qija. Għal ħafna pari iskript, hemm sistemi aktar standard waħda jew trasliteraz"
		"zjoni. Madankollu, trażlitterazzjoni unsystematic huwa komuni."
    )}

NORWEGIAN_TEXT = {
    'language': 'no',
    'text': (
		"Systematisk translitterasjon er en kartlegging fra ett system for å skrive inn i"
		" en annen, vanligvis grafem til grafem. De fleste translitterasjon systemer er e"
		"n-til-en, så en leser som kjenner systemet kan rekonstruere den opprinnelige sta"
		"vemåten. Translitterasjon er imot transkripsjon, som kart lyden av ett språk til"
		" et skriftlig system. Likevel, de fleste systemer av translitterasjon kart bokst"
		"avene kilden manuset til bokstaver uttales på samme måte i målet manuset, for no"
		"en bestemt par av kilde- og målspråket. Hvis forholdet mellom bokstaver og lyder"
		" er lik på begge språk, kan en omskrivning være svært nær en transkripsjon. I pr"
		"aksis er det noen blandede omskrivning / transkripsjonssystemer som translittere"
		"rer en del av den opprinnelige manuset og transkribere resten. For mange script "
		"parene, det er en eller flere standard translitterasjon systemer. Imidlertid er "
		"usystematisk translitterasjon vanlig."
    )}

POLISH_TEXT = {
    'language': 'pl',
    'text': (
		"Systematyczne transliteracji jest odwzorowaniem z jednego systemu pisma do drugi"
		"ego, zwykle grafem do grafem. Większość systemów transliteracji są jeden do jedn"
		"ego, więc czytelnik, który zna system może odtworzyć oryginalną pisownię. Transl"
		"iteracja jest przeciwny do transkrypcji, która odwzorowuje dźwięki jednego język"
		"a na system pisania. Mimo to, większość systemów transliteracji map litery skryp"
		"tu źródłowego do litery wymawiane podobnie w skrypcie docelowej, z jakiegoś konk"
		"retnego źródła pary i języka docelowego. Jeśli stosunki między literami i dźwięk"
		"i są podobne w obu językach, transliteracji mogą być bardzo blisko do transkrypc"
		"ji. W praktyce istnieją pewne mieszane systemy transliteracji / transkrypcyjne ż"
		"e Transliterate część oryginalnego skryptu i rozpisać resztę. Dla wielu par skry"
		"ptów, istnieje jeden lub więcej standardowych systemów transliteracji. Jednak ni"
		"esystematyczne transliteracji jest powszechne."
    )}

PORTUGUESE_TEXT = {
    'language': 'pt',
    'text': (
		"transliteração sistemática é um mapeamento a partir de um sistema de escrita par"
		"a outro, normalmente Grafema para Grafema. A maioria dos sistemas de translitera"
		"ção são um-para-um, para um leitor que conhece o sistema pode reconstruir a graf"
		"ia original. Transliteração se opõe à transcrição, que mapeia os sons de uma lín"
		"gua para um sistema de escrita. Ainda assim, a maioria dos sistemas de translite"
		"ração mapear as letras do roteiro fonte para letras pronunciadas da mesma forma "
		"no script de destino, para alguns par específico de fonte e língua-alvo. Se as r"
		"elações entre letras e sons são semelhantes em ambas as línguas, uma translitera"
		"ção pode estar muito perto de uma transcrição. Na prática, existem alguns sistem"
		"as de transliteração / transcrição mistos que Transliterate uma parte do roteiro"
		" original e transcrever o resto. Para muitos pares de script, há um ou mais padr"
		"ão sistemas de transliteração. No entanto, transliteração assistemática é comum."
    )}

ROMANIAN_TEXT = {
    'language': 'ro',
    'text': (
		"transliterație sistematică este o mapare de la un sistem de scriere în altul, în"
		" mod tipic grapheme la grapheme. Cele mai multe sisteme de transliterare sunt un"
		"u-la-unu, astfel încât un cititor care cunoaște sistemul poate reconstitui ortog"
		"rafia originală. Transliterația se opune transcrierii, care mapează sunetele din"
		"tr-o limbă într-un sistem de scriere. Cu toate acestea, cele mai multe sisteme d"
		"e transliterare hartă literele script sursă la litere pronunțate în mod similar,"
		" în script-ul țintă, pentru unele perechi specifice de sursă și limba țintă. În "
		"cazul în care relațiile dintre litere și sunete sunt similare în ambele limbi, o"
		" transliterare poate fi foarte aproape de o transcriere. În practică, există une"
		"le sisteme de transliterație / transcriere mixte, care transcrie o parte din scr"
		"ipt-ul original și transcrie restul. Pentru mai multe perechi de script, există "
		"unul sau mai multe sisteme standard de transliterație. Cu toate acestea, transli"
		"terația nesistematic este comună."
    )}

GREEK_TEXT = {
    'language': 'el',
    'text': (
		"Συστηματική μεταγραφής είναι μια χαρτογράφηση από το ένα σύστημα γραφής σε ένα ά"
		"λλο, τυπικά γραφηματικές να grapheme. Τα περισσότερα συστήματα μεταγραφή είναι έ"
		"να-προς-ένα, έτσι έναν αναγνώστη που γνωρίζει το σύστημα μπορεί να ανακατασκευάσ"
		"ει την αρχική ορθογραφία. Η μεταγραφή είναι σε αντίθεση με τη μεταγραφή, η οποία"
		" χαρτογραφεί τους ήχους μιας γλώσσας σε ένα σύστημα γραφής. Παρόλα αυτά, τα περι"
		"σσότερα συστήματα της μεταγραφής χαρτογραφήσει τις επιστολές του σεναρίου πηγή γ"
		"ια τα γράμματα προφέρονται με παρόμοιο τρόπο στο σενάριο στόχο, για κάποιο συγκε"
		"κριμένο ζεύγος πηγής και της γλώσσας-στόχου. Αν οι σχέσεις μεταξύ των γραμμάτων "
		"και των ήχων είναι παρόμοια και στις δύο γλώσσες, η μεταγραφή μπορεί να είναι πο"
		"λύ κοντά σε μια μεταγραφή. Στην πράξη, υπάρχουν μερικές μικτά συστήματα εταγρα /"
		" μεταγραφής που η μεταγραφή ένα μέρος του αρχικού σεναρίου και μεταγράψει το υπό"
		"λοιπο. Για πολλά ζευγάρια το σενάριο, υπάρχει ένα ή περισσότερα τυποποιημένα συσ"
		"τήματα μεταγραφής. Ωστόσο, ανοργάνωτες μεταγραφή είναι κοινή."
    )}

SLOVAK_TEXT = {
    'language': 'sk',
    'text': (
		"Systematické prepis je mapovanie z jedného systému písania do druhého, zvyčajne "
		"grafém na grafém. Väčšina prepisu systémy sú one-to-one, takže čitateľ, ktorý po"
		"zná systém možno rekonštruovať pôvodnú pravopis. Prepis je proti prepisu, ktorá "
		"mapuje zvuky jedného jazyka do systému písania. Napriek tomu, že väčšina systémo"
		"v prepisu mapujú listy v zdrojovom skripte do listov vyslovujú podobne ako v cie"
		"ľovom skriptu pre nejakú špecifickú dvojicou zdroje a cieľového jazyka. Či sú vz"
		"ťahy medzi písmenami a zvuky sú podobné v oboch jazykoch, prepis môže byť veľmi "
		"blízko k transkripcii. V praxi existujú zmiešané prepis / transkripčný systémy, "
		"ktoré prepísať časť pôvodného scenára a prepísať zvyšok. Pre mnoho párov skriptu"
		", tam je jeden alebo viac štandardných prepisu systémy. Avšak, nesystémové prepi"
		"s je bežné."
    )}

SLOVENIAN_TEXT = {
    'language': 'sl',
    'text': (
		"Sistematično Transkripcija je preslikava iz enega sistema pisanja v drugega, obi"
		"čajno grafem za grafem. Večina transkripcije sistemi so ena-na-ena, tako da bral"
		"ec, ki pozna sistem lahko rekonstrukcijo prvotne črkovanje. Prečrkovanje nasprot"
		"uje prepisu, ki preslika zvoke enega jezika v sistemu pisanje. Kljub temu pa več"
		"ina sistemov za transkripcijo map črke vira scenarij za črkami izrazito prav v c"
		"iljni scenarij, za določene par vira in ciljni jezik. Če so odnosi med črkami in"
		" zvoki podobna v obeh jezikih, lahko prečrkovanje zelo blizu prepis. V praksi ob"
		"stajajo mešane Transkripcija / prepisu sistemi, ki prečrkovanje del izvirnega sc"
		"enarija in prepis ostalo. Za mnoge skript parov, je ena ali več standardnih tran"
		"skripcije sistemi. Vendar pa nesistematično prečrkovanje je skupna."
    )}

SOMALI_TEXT = {
    'language': 'so',
    'text': (
		"tarjumaadda nidaamsan waa naqshadeynta ka mid ah habka of qoraal kale, caadi aha"
		"an grapheme in grapheme. nidaamyada tarjumaadda intooda badan waa mid ka mid-ka-"
		"mid ah, si akhristaha a yaa garanaya nidaamka dib kartaa higaada asalka ah. Tarj"
		"umaadda waxaa ka soo horjeeda qoraal, taas oo maps dhawaaqyada isku af nidaamka "
		"qoraal ah. Weli, nidaamyada inta badan tarjumaadda khariidada warqadihii script "
		"isha si xarfaha loogu dhawaaqo si la mid ah in script bartilmaameedka, qaar ka m"
		"id ah labada ciyaaryahan gaar ah isha iyo afka bartilmaameedka. Haddii xiriirka "
		"u dhexeeya xarfaha iyo dhawaaqa mid ah labada luuqadood waa, tarjumaadda waxaa l"
		"aga yaabaa in aad ugu dhow in ay qoraal ah. In dhaqanka, waxaa jira qaar ka mid "
		"ah hababka tarjumaadda / qoraal oo isku darsanaa oo transliterate qayb ka mid ah"
		" script asalka ah oo ay shakiyaan kuwa intiisa kale. Waayo, lammaane badan scrip"
		"t, waxaa jira hal ama in ka badan caadiga ah nidaamka tarjumaadda. Si kastaba ha"
		" ahaatee, tarjumaadda unsystematic waa wax caadi ah."
    )}

SPANISH_TEXT = {
    'language': 'es',
    'text': (
		"transliteración sistemática es un mapeo de un sistema de escritura a otro, por l"
		"o general grafema a grafema. La mayoría de los sistemas de transliteración son u"
		"no-a-uno, por lo que un lector que conoce el sistema puede reconstruir la ortogr"
		"afía original. Transliteración se opone a la transcripción y que correlaciona lo"
		"s sonidos de un idioma a un sistema de escritura. Aún así, la mayoría de los sis"
		"temas de transliteración mapa las letras de la escritura de origen a las letras "
		"pronunciadas de manera similar en el guión de destino, por algún par específico "
		"de idioma de origen y de destino. Si las relaciones entre las letras y los sonid"
		"os son similares en las dos lenguas, una transliteración puede ser muy cerca de "
		"una transcripción. En la práctica, hay algunos sistemas de transliteración / tra"
		"nscripción mixtos que Transliterate una parte del guión original y transcribir e"
		"l resto. Para muchos pares de secuencias de comandos, hay uno o más sistemas de "
		"transliteración estándar. Sin embargo, no sistemática transliteración es común."
    )}

SUNDANESE_TEXT = {
    'language': 'su',
    'text': (
		"transliterasi sistimatis mangrupakeun pemetaan tina hiji sistem tulisan kana sej"
		"en, ilaharna grapheme mun grapheme. Paling sistem transliterasi mangrupakeun hij"
		"i-ka-hiji, jadi hiji maca anu weruh sistem tiasa ngarekonstruksikeun ejaan aslin"
		"a. Transliterasi keur sabalikna transkripsi nu peta sora tina hiji basa kana sis"
		"tem tulisan. Leungit, paling sistem transliterasi peta nu hurup tina Aksara sumb"
		"er pikeun hurup dibaca kitu dina naskah target, pikeun sababaraha pasangan husus"
		" tina sumber na basa target. Mun hubungan antara hurup jeung sora nu sarupa dina"
		" duanana basa, transliterasi hiji bisa jadi deukeut pisan transkripsi a. Dina pr"
		"akték, aya sababaraha sistim transliterasi / transkripsi dicampur yén transliter"
		"ate bagian tina Aksara aslina tur nranskripsikeun sésana. Pikeun loba pasang Aks"
		"ara, aya salah sahiji atawa leuwih standar sistem transliterasi. Sanajan kitu, t"
		"ransliterasi unsystematic geus ilahar."
    )}

SWAHILI_TEXT = {
    'language': 'sw',
    'text': (
		"Utaratibu ya tafsiri kubadilisha kutoka mfumo mmoja wa kuandika hadi nyingine, k"
		"awaida Kiunganishi Kinachounganisha kwa Kiunganishi Kinachounganisha. Wengi tafs"
		"iri kwa mifumo ni moja kwa moja, hivyo msomaji ambaye anajua mfumo unaweza upya "
		"herufi ya awali. Tafsiri kwa kinyume na transcription, ambayo ramani sauti wa lu"
		"gha moja katika mfumo wa maandishi. Hata hivyo, mifumo zaidi ya tafsiri kwa rama"
		"ni barua ya script chanzo barua hutamkwa vile vile katika lengo script, kwa baad"
		"hi ya jozi maalum ya chanzo na lugha lengwa. Kama uhusiano kati barua na sauti n"
		"i sawa katika lugha zote mbili, tafsiri kwa inaweza kuwa karibu sana na transcri"
		"ption. Katika mazoezi, kuna baadhi ya mchanganyiko ya tafsiri / transcription mi"
		"fumo kunukuu sehemu ya script ya awali na kunukuu mapumziko. Kwa jozi nyingi scr"
		"ipt, kuna moja au zaidi ya kiwango mifumo ya tafsiri. Hata hivyo, unsystematic y"
		"a tafsiri ya kawaida."
    )}

SWEDISH_TEXT = {
    'language': 'sv',
    'text': (
		"Systematisk omskrivning är en kartläggning från ett system för att skriva in en "
		"annan, oftast grafem till grafem. De flesta tran system är en-till-en, så en läs"
		"are som känner till systemet kan rekonstruera den ursprungliga stavningen. Omskr"
		"ivning motsätter sig transkription, som kartlägger ljudet av ett språk till ett "
		"skriftsystem. Ändå har de flesta system för transkription kartlägga bokstäverna "
		"i käll manus till bokstäver uttalas på liknande sätt i målet manus, för vissa sp"
		"ecifika par av käll- och målspråket. Om förhållandet mellan bokstäver och ljud ä"
		"r lika på båda språken, kan en transkribering vara mycket nära en transkription."
		" I praktiken finns det några blandade translitte / transkriptionssystem som tran"
		"skribera en del av den ursprungliga manus och transkriberar resten. För många ma"
		"nus par, det finns ett eller flera vanliga transystem. Dock är osystematisk omsk"
		"rivning vanligt."
    )}

TURKISH_TEXT = {
    'language': 'tr',
    'text': (
		"Sistematik çevirisi tipik Grapheme için Grapheme, birbiri içine yazı bir sistemd"
		"en bir eşleme olduğunu. Çoğu çevirisi sistemleri orijinal yazımı tekrar oluştura"
		"bilir sistemini bilen bir okuyucu böylece, bire-bir bulunmaktadır. Transliterasy"
		"on bir yazı sistemine bir dilin sesleri eşleyen transkripsiyonu karşıdır. Yine d"
		"e, alfabede en sistemleri kaynak ve hedef dilin bazı özel çifti için, hedef komu"
		"t benzer telaffuz harflere kaynak script harfleri map. harfler ve sesler arasınd"
		"aki ilişkiler her iki dilde benzerse, bir harf çevirisi olan bir transkripsiyon "
		"çok yakın olabilir. Uygulamada, orijinal senaryonun bir parçası çevirisini ve di"
		"nlenme uyarlamak biraz karışık çevirisi / transkripsiyon sistemleri vardır. Birç"
		"ok komut çiftleri için, bir veya daha fazla standart çevirisi sistemleri vardır."
		" Ancak, sistemsiz çevirisi yaygındır."
    )}

UZBEK_TEXT = {
    'language': 'uz',
    'text': (
		"Sistematik transliteratsiya, odatda grapheme uchun grapheme, boshqasiga yozma bi"
		"ri tizimidan bir xaritalash hisoblanadi. Eng transliteratsiya tizimlari original"
		" tilida yozilib rekonstruksiya mumkin tizimini biladi bir o'quvchi, shuning uchu"
		"n, bir-to-biri. Transliteratsiya bir yozuv tizimiga bir tilning tovushlar, xarit"
		"alar transkripsiyonunun, muxolifdir. Shunday bo'lsa-da, transliteratorlar eng ti"
		"zimlari manba va maqsad til ayrim maxsus juftlik uchun, maqsadli yozuvida ham xu"
		"ddi shunday tarzda talaffuz harflar uchun manba ssenariysi harflarni xaritasi. h"
		"arflar va tovushlar o'rtasidagi munosabatlar har ikkala tilda ham shunga o'xshas"
		"h bo'lsa, tarjima, bir nusxa ko'chirish juda yaqin bo'lishi mumkin. Amalda, orig"
		"inal ssenariysi bir qismini transliterate va dam ko'chirmoq ba'zi aralash transl"
		"iteratsiya / nusxa ko'chirish tizimlari mavjud. ko'p skript juft uchun, bir yoki"
		" bir necha standart transliteratsiya tizimlari bor. Biroq, unsystematic translit"
		"eratsiya keng tarqalgan."
    )}

VIETNAMESE_TEXT = {
    'language': 'vi',
    'text': (
		"phiên âm có hệ thống là một ánh xạ từ một trong những hệ thống chữ viết thành kh"
		"ác, thường grapheme để grapheme. Hầu hết các hệ thống phiên âm là one-to-one, do"
		" đó, một độc giả người hiểu biết hệ thống có thể tái tạo lại cách viết ban đầu. "
		"Ngữ được trái ngược với phiên mã, mà bản đồ các âm thanh của ngôn ngữ này sang m"
		"ột hệ thống văn bản. Tuy nhiên, hầu hết các hệ thống phiên âm bản đồ các chữ cái"
		" của kịch bản nguồn để chữ phát âm tương tự như trong kịch bản mục tiêu, đối với"
		" một số cặp cụ thể của nguồn và ngôn ngữ đích. Nếu mối quan hệ giữa các chữ cái "
		"và âm thanh tương tự trong cả hai ngôn ngữ, một phiên âm có thể rất gần đến một "
		"phiên mã. Trong thực tế, có một số hệ thống phiên âm / sao chép lẫn lộn rằng tra"
		"nsliterate một phần của kịch bản gốc và ghi lại phần còn lại. Đối với nhiều cặp "
		"kịch bản, có một hoặc nhiều tiêu chuẩn hệ thống phiên âm. Tuy nhiên, phiên âm kh"
		"ông có hệ thống là phổ biến."
    )}

WELSH_TEXT = {
    'language': 'cy',
    'text': (
		"trawslythrennu Systematig yn mapio o un system o ysgrifennu i mewn i un arall, f"
		"el arfer graffem i graffem. Rhan fwyaf o systemau trawslythrennu yn un-i-un, fel"
		"ly darllenydd sy'n adnabod y system yn gallu ail-greu y sillafiad gwreiddiol. Tr"
		"awslythrennu yn gwrthwynebu trawsgrifiad, sy'n mapio'r seiniau un iaith i system"
		" ysgrifennu. Still, y rhan fwyaf o systemau trawslythrennu fapio llythyrau y sgr"
		"ipt ffynhonnell i lythyrau amlwg yn yr un modd yn y sgript targed, ar gyfer rhai"
		" pâr penodol o ffynhonnell a'r iaith darged. Os bydd y berthynas rhwng llythrenn"
		"au a seiniau yn debyg yn y ddwy iaith, gall trawslythreniad fod yn agos iawn at "
		"trawsgrifio. Yn ymarferol, mae rhai systemau drawslythrennu / trawsgrifio cymysg"
		" sy'n drawslythrennu rhan o'r sgript wreiddiol ac yn trawsgrifio y gweddill. I l"
		"awer o barau sgript, mae un neu ragor o safon systemau drawslythrennu. Fodd bynn"
		"ag, trawslythreniad ansystematig yn gyffredin."
    )}

XHOSA_TEXT = {
    'language': 'xh',
    'text': (
		"lokuguqulwa ngendlela i mapping evela kwenye inkqubo yokubhala ukuya kwenye, ngo"
		"kokuqhelekileyo emoshakeleyo ukuba emoshakeleyo. kwiindlela ezininzi unobumba ez"
		"i-one-to-one, ngoko umfundi oyaziyo inkqubo ingadala kutsha upelo yokuqala. Ukug"
		"uqulwa eliphikisa ukhutshelo, leyo Ibeka izandi zolwimi olunye kwinkqubo yokubha"
		"la. Kunjalo, iinkqubo ezininzi unobumba mephu oonobumba kwemvelaphi leempendulo "
		"koonobumba libizwe okufanayo script wetekeni, kuba abanye sibini ezithile lesixh"
		"obo kunye nolwimi target. Ukuba ubudlelwane phakathi koonobumba izandi ezifanayo"
		" zombini iilwimi, ukuguqulwa ibe kufutshane kakhulu Ukubhalwa. Ukuziqhelisa, kuk"
		"ho ezinye iindlela unobumba / ukhutshelo Indibandiba ekutayipheni yinxalenye lee"
		"mpendulo lokuqala azikhuphele abanye. Kuba ngababini ezininzi script, kukho iink"
		"qubo enye okanye umgangatho ngaphezulu ukuguqulwa. Noko ke, unobumba unsystemati"
		"c yinto eqhelekileyo."
    )}

YORUBA_TEXT = {
    'language': 'yo',
    'text': (
		"Ifinufindo transliteration ni a aworan lati ọkan eto ti kikọ sinu miiran, ojo me"
		"lo grapheme to grapheme. Ọpọ transliteration šiše wa ni ọkan-si-ọkan, ki a RSS t"
		"i o mo awọn eto le reconstruct awọn atilẹba Akọtọ. Transliteration ti wa ni o lo"
		"di si transcription, eyi ti o maapu awọn ohun ti ọkan ede sinu a kikọ eto. Ṣi, j"
		"ulọ awọn ọna šiše ti transliteration ya awọn lẹta ti awọn orisun akosile to lẹta"
		" oyè bakanna ni afojusun akosile, fun diẹ ninu awọn kan pato bata ti orisun ati "
		"afojusun ede. Ti o ba ti ajosepo laarin awọn lẹta ati awọn ohun wa ni iru ninu a"
		"wọn mejeeji ede, a transliteration le jẹ gidigidi sunmo si a transcription. Ni a"
		"sa, nibẹ ni o wa diẹ ninu awọn adalu transliteration / transcription ọna šiše ti"
		" transliterate apa kan ninu awọn atilẹba akosile ati transcribe awọn iyokù. Fun "
		"ọpọlọpọ akosile orisii, nibẹ ni ọkan tabi diẹ ẹ sii boṣewa transliteration awọn "
		"ọna šiše. Sibẹsibẹ, unsystematic transliteration jẹ wọpọ."
    )}

ZULU_TEXT = {
    'language': 'zu',
    'text': (
		"kwamaletha izinhlelo kuyinto kumephu kusukela kusistimu eyodwa yokuloba kolunye,"
		" ngokuvamile grapheme ukuze grapheme. Iningi kwamaletha izinhlelo ungomunye nobu"
		"so, ngakho umfundi owazi isistimu ingakwazi kabusha isipelingi yasekuqaleni. Uku"
		"guqulwa kuqhathaniswa umbhalo, okuyinto amamephu imisindo yolimi umuntu ku isimi"
		"so sokubhala. Noma kunjalo, izinhlelo iningi kwamaletha kumephu izinhlamvu zombh"
		"alo umthombo izinhlamvu liphinyiselwe efanayo e iskripthi target, kwabanye pair "
		"ezithile omthombo target ulimi. Uma uhlobano phakathi izinhlamvu nemisindo zifan"
		"a ngazo zombili lezi zilimi, ukuguqulwa be kakhulu cimeza ukuba Ukulotshwa. Ekus"
		"ebenteni, kukhona ezinye okuxubile kwamaletha / umbhalo izinhlelo ukuthi Humusha"
		" ingxenye iskripthi yasekuqaleni futhi ukubhala lonke. Kwabaningi iskripthi ngaz"
		"imbili, kukhona oyedwa noma indinganiso kwamaletha izinhlelo. Nokho, ukuhumusha "
		"unsystematic kuvamile."
    )}

PERSIAN_TEXT = {
    'language': 'fa',
    'text': (
		"ترجمه سیستماتیک یک نگاشت از یک سیستم نوشتن را به دیگری است، به طور معمول از حروف"
		" الفباء به حروف الفباء. اکثر سیستم های ترجمه یک به یک هستند، بنابراین یک خواننده"
		" که سیستم می تواند املای اصلی بازسازی می داند. ترجمه با رونویسی، که نقشه تلفن ها"
		"ی موبایل از یک زبان به زبان یک نظام نوشتاری مخالف است. با این حال، بسیاری از سیس"
		"تم های ترجمه نقشه حروف اسکریپت منبع به حروف به طور مشابه در اسکریپت هدف تلفظ، بر"
		"ای برخی از جفت خاص از زبان مبدأ و مقصد. اگر روابط بین حروف و صداها در هر دو زبان"
		" مشابه هستند، یک ترجمه ممکن است بسیار نزدیک به یک رونویسی. در عمل، برخی از سیستم"
		" های ترجمه / رونویسی مخلوط که بحرف بخشی از فیلمنامه اصلی و نوشتن بقیه وجود دارد."
		" برای بسیاری از جفت اسکریپت، است یک یا چند سیستم استاندارد ترجمه وجود دارد. با ا"
		"ین حال، ترجمه غیر سیستماتیک شایع است."
    )}

TEXT_SAMPLES = [
	ARABIC_TEXT,
	AFRIKAANS_TEXT,
	ALBANIAN_TEXT,
	AZERBAIJANI_TEXT,
	BASQUE_TEXT,
	CATALAN_TEXT,
	CORSICAN_TEXT,
	CROATIAN_TEXT,
	CZECH_TEXT,
	DANISH_TEXT,
	DUTCH_TEXT,
	ENGLISH_TEXT,
	ESPERANTO_TEXT,
	ESTONIAN_TEXT,
	FILIPINO_TEXT,
	FINNISH_TEXT,
	FRENCH_TEXT,
	GALICIAN_TEXT,
	GERMAN_TEXT,
	CREOLE_TEXT,
	HAUSA_TEXT,
	HUNGARIAN_TEXT,
	ICELANDIC_TEXT,
	IGBO_TEXT,
	INDONESIAN_TEXT,
	IRISH_TEXT,
	ITALIAN_TEXT,
	KURDISH_TEXT,
	LATIN_TEXT,
	LATVIAN_TEXT,
	LITHUANIAN_TEXT,
	MALAGASY_TEXT,
	MALAY_TEXT,
	MALTESE_TEXT,
	NORWEGIAN_TEXT,
	POLISH_TEXT,
	PORTUGUESE_TEXT,
	ROMANIAN_TEXT,
	GREEK_TEXT,
	SLOVAK_TEXT,
	SLOVENIAN_TEXT,
	SOMALI_TEXT,
	SPANISH_TEXT,
	SUNDANESE_TEXT,
	SWAHILI_TEXT,
	SWEDISH_TEXT,
	TURKISH_TEXT,
	UZBEK_TEXT,
	VIETNAMESE_TEXT,
	WELSH_TEXT,
	XHOSA_TEXT,
	YORUBA_TEXT,
	ZULU_TEXT,
	PERSIAN_TEXT,
]
