# -*- coding: utf-8 -*-
# Generated by Django 1.11.24 on 2019-09-20 21:11
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import leprikon.models.fields
import leprikon.models.subjects


def set_subject_registration_type(apps, schema_editor):
    Subject = apps.get_model('leprikon', 'Subject')
    Subject.objects.filter(max_group_members_count__gt=0).update(
        registration_type='G',
        min_participants_count=0,
        max_participants_count=0,
    )


def create_subject_registration_groups(apps, schema_editor):
    SubjectRegistration = apps.get_model('leprikon', 'SubjectRegistration')
    SubjectRegistrationGroup = apps.get_model('leprikon', 'SubjectRegistrationGroup')
    SubjectRegistrationGroup.objects.bulk_create(
        SubjectRegistrationGroup(
            registration=registration,
            target_group_id=registration.target_group_id,
            name=registration.group_name,
            first_name=registration.group_leader_first_name,
            last_name=registration.group_leader_last_name,
            street=registration.group_leader_street,
            city=registration.group_leader_city,
            postal_code=registration.group_leader_postal_code,
            phone=registration.group_leader_phone,
            email=registration.group_leader_email,
            school_id=registration.group_school_id,
            school_other=registration.group_school_other,
            school_class=registration.group_school_class,
        )
        for registration in SubjectRegistration.objects.filter(subject__registration_type='G')
    )


class Migration(migrations.Migration):

    dependencies = [
        ('leprikon', '0033_target_groups'),
    ]

    operations = [
        migrations.AlterField(
            model_name='subject',
            name='age_groups',
            field=models.ManyToManyField(related_name='subjects', to='leprikon.AgeGroup', verbose_name='age groups'),
        ),
        migrations.AlterField(
            model_name='subject',
            name='target_groups',
            field=models.ManyToManyField(related_name='subjects', to='leprikon.TargetGroup', verbose_name='target groups'),
        ),
        migrations.AlterField(
            model_name='subject',
            name='max_group_members_count',
            field=models.PositiveIntegerField(help_text='Group member details only include name and note.', verbose_name='maximal group members count per registration'),
        ),
        migrations.AlterField(
            model_name='subject',
            name='min_group_members_count',
            field=models.PositiveIntegerField(help_text='Group member details only include name and note.', verbose_name='minimal group members count per registration'),
        ),
        migrations.AddField(
            model_name='subject',
            name='registration_type',
            field=models.CharField(choices=[('P', 'participants'), ('G', 'groups')], default='P', max_length=1, verbose_name='registration type'),
            preserve_default=False,
        ),
        migrations.RunPython(set_subject_registration_type),
        migrations.CreateModel(
            name='SubjectRegistrationGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('registration', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='group', to='leprikon.SubjectRegistration', verbose_name='registration')),
                ('target_group', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.TargetGroup', verbose_name='target group')),
                ('name', models.CharField(blank=True, null=True, max_length=150, verbose_name='group name')),
                ('first_name', models.CharField(max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(max_length=30, verbose_name='last name')),
                ('street', models.CharField(max_length=150, verbose_name='street')),
                ('city', models.CharField(max_length=150, verbose_name='city')),
                ('postal_code', leprikon.models.fields.PostalCodeField(verbose_name='postal code')),
                ('phone', models.CharField(max_length=30, verbose_name='phone')),
                ('email', leprikon.models.fields.EmailField(max_length=254, verbose_name='email address')),
                ('school', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.School', verbose_name='school')),
                ('school_other', models.CharField(blank=True, default='', max_length=150, verbose_name='other school')),
                ('school_class', models.CharField(blank=True, default='', max_length=30, verbose_name='class')),
                ('answers', models.TextField(blank=True, default='{}', editable=False, verbose_name='additional answers')),
            ],
            options={
                'verbose_name': 'registered group',
                'verbose_name_plural': 'registered groups',
            },
            bases=(leprikon.models.subjects.SchoolMixin, leprikon.models.subjects.PersonMixin, models.Model),
        ),
        migrations.RunPython(create_subject_registration_groups),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_age_group',
            new_name='age_group',
        ),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_birth_num',
            new_name='birth_num',
        ),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_citizenship',
            new_name='citizenship',
        ),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_city',
            new_name='city',
        ),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_email',
            new_name='email',
        ),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_first_name',
            new_name='first_name',
        ),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_gender',
            new_name='gender',
        ),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_health',
            new_name='health',
        ),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_last_name',
            new_name='last_name',
        ),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_phone',
            new_name='phone',
        ),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_postal_code',
            new_name='postal_code',
        ),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_school',
            new_name='school',
        ),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_school_class',
            new_name='school_class',
        ),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_school_other',
            new_name='school_other',
        ),
        migrations.RenameField(
            model_name='subjectregistrationparticipant',
            old_name='participant_street',
            new_name='street',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='group_leader_city',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='group_leader_email',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='group_leader_first_name',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='group_leader_last_name',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='group_leader_phone',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='group_leader_postal_code',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='group_leader_street',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='group_name',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='group_school',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='group_school_class',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='group_school_other',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='target_group',
        ),
    ]
