# -*- coding: utf-8 -*-
# Generated by Django 1.11.24 on 2019-10-20 20:32
from __future__ import unicode_literals

from django.db import migrations, models


def set_participants_instructed(apps, schema_editor):
    Subject = apps.get_model('leprikon', 'Subject')
    for subject in Subject.objects.iterator():
        all_instructed = set()
        for journal_entry in subject.journal_entries.all():
            instructed = {
                participant
                for participant in journal_entry.participants.all()
                if participant not in all_instructed
            }
            journal_entry.participants_instructed.set(instructed)
            all_instructed.update(instructed)


class Migration(migrations.Migration):

    dependencies = [
        ('leprikon', '0035_on_delete'),
    ]

    operations = [
        migrations.AddField(
            model_name='journalentry',
            name='participants_instructed',
            field=models.ManyToManyField(blank=True, related_name='instructed', to='leprikon.SubjectRegistrationParticipant', verbose_name='participants instructed about safety and internal rules'),
        ),
        migrations.RunPython(set_participants_instructed),
    ]
