# Generated by Django 4.0.3 on 2022-04-06 20:24

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('reviewpanel', '0005_presentation_options'),
    ]

    operations = [
        migrations.AlterField(
            model_name='cohortmember',
            name='object_id',
            field=models.UUIDField(db_index=True),
        ),
        migrations.AlterField(
            model_name='score',
            name='object_id',
            field=models.UUIDField(db_index=True),
        ),
        migrations.CreateModel(
            name='Metric',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.SlugField(allow_unicode=True, max_length=20)),
                ('type', models.CharField(choices=[('count', 'count'), ('avg', 'average'), ('stddev', 'standard deviation'), ('max', 'maximum'), ('min', 'minimum')], default='count', max_length=16)),
                ('count_value', models.PositiveIntegerField(blank=True, null=True)),
                ('count_is_divisor', models.BooleanField(default=False)),
                ('boolean_invert', models.BooleanField(default=False)),
                ('position', models.PositiveIntegerField(default=1)),
                ('admin_enabled', models.BooleanField(default=True)),
                ('panelist_enabled', models.BooleanField(default=False)),
                ('cohort', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='reviewpanel.cohort')),
                ('input', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='inputs', related_query_name='input', to='reviewpanel.input')),
            ],
            options={
                'ordering': ['input', 'position', 'pk'],
            },
        ),
        migrations.AddConstraint(
            model_name='metric',
            constraint=models.UniqueConstraint(fields=('input', 'name'), name='unique_metric_name'),
        ),
    ]
