# spicedsun

![Version 0.0.1](https://img.shields.io/badge/version-0.0.1-informational)

Calculation of solar data using NASA’s SPICE toolbox.

This data includes:
- Azimuth angle (in degrees)
- Zenith angle (in degrees)

## Requirements

- numpy>=1.22.2
- spiceypy>=5.0.0

## Installation

```sh
pip install spicedsun
```

### Kernels

In order to use the package, a directory with all the kernels must be downloaded.

That directory must contain the following kernels:
- [https://naif.jpl.nasa.gov/pub/naif/JUNO/kernels/spk/de421.bsp](https://naif.jpl.nasa.gov/pub/naif/JUNO/kernels/spk/de421.bsp)
- [https://naif.jpl.nasa.gov/pub/naif/pds/wgc/kernels/pck/earth_070425_370426_predict.bpc](https://naif.jpl.nasa.gov/pub/naif/pds/wgc/kernels/pck/earth_070425_370426_predict.bpc)
- [https://naif.jpl.nasa.gov/pub/naif/generic_kernels/fk/planets/earth_assoc_itrf93.tf](https://naif.jpl.nasa.gov/pub/naif/generic_kernels/fk/planets/earth_assoc_itrf93.tf)
- [https://naif.jpl.nasa.gov/pub/naif/generic_kernels/pck/earth_latest_high_prec.bpc](https://naif.jpl.nasa.gov/pub/naif/generic_kernels/pck/earth_latest_high_prec.bpc)
- [https://naif.jpl.nasa.gov/pub/naif/generic_kernels/lsk/naif0011.tls](https://naif.jpl.nasa.gov/pub/naif/generic_kernels/lsk/naif0011.tls)
- [https://naif.jpl.nasa.gov/pub/naif/generic_kernels/pck/pck00010.tpc](https://naif.jpl.nasa.gov/pub/naif/generic_kernels/pck/pck00010.tpc)

## Usage

If one wanted to obtain the solar azimuth and zenith at Izaña Atmospheric Observatory, on
2022-01-17 at 15:00:00 (UTC), we could use the following snippet of code:

```python
import spicedsun as sps

lat = 28.309283
lon = -16.499143
alt = 2373
dts = ["2022-01-17 15:00:00"]
sds = sps.get_sun_datas(lat, lon, alt, dts, "./kernels")
az = sds[0].azimuth
ze = sds[0].zenith
```
Note that the kernels directory is called "kernels" and is located in the directory where the
previous code is executed.
