# Generated by Django 3.1.3 on 2020-11-09 12:54

import django.utils.timezone
from django.db import migrations, models

import drf_auth_service.common.helpers


class Migration(migrations.Migration):
    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='SSOUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('username', models.CharField(max_length=200, unique=True)),
                ('register_type', models.CharField(choices=[('email', 'Email'), ('phone_number', 'Phone number'),
                                                            ('phone_number_code', 'Phone number code'),
                                                            ('nickname', 'Nickname')], default='email',
                                                   max_length=100)),
            ],
            options={
                'db_table': '"users"',
                'abstract': False,
                'swappable': 'AUTH_USER_MODEL',
            },
        ),
        migrations.CreateModel(
            name='ActivationCode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('key', models.CharField(db_index=True, max_length=64, unique=True)),
                ('key_type', models.CharField(
                    choices=[('reset_password', 'Reset password'), ('confirm_account', 'Confirm account')],
                    default='reset_password', max_length=30)),
            ],
            options={
                'db_table': '"activation_codes"',
            },
        ),
        migrations.CreateModel(
            name='Config',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('key', models.CharField(max_length=200)),
                ('type', models.CharField(max_length=200)),
                ('value', models.TextField()),
            ],
            options={
                'db_table': '"configs"',
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300)),
                ('description', models.CharField(max_length=300)),
            ],
            options={
                'db_table': '"roles"',
            },
        ),
        migrations.CreateModel(
            name='Scope',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.TextField()),
                ('name', models.CharField(max_length=50)),
                ('code', models.CharField(max_length=200)),
            ],
            options={
                'db_table': '"scopes"',
            },
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('secret_token',
                 models.CharField(default=drf_auth_service.common.helpers.generate_token, max_length=200, unique=True)),
                ('public_token',
                 models.CharField(default=drf_auth_service.common.helpers.generate_token, max_length=200, unique=True)),
            ],
            options={
                'db_table': '"services"',
            },
        ),
        migrations.CreateModel(
            name='Social',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('label', models.CharField(max_length=100)),
                ('identifier', models.CharField(max_length=100)),
                ('social_type', models.CharField(
                    choices=[('facebook', 'Facebook'), ('google-oauth2', 'Google'), ('apple-id', 'Apple')],
                    max_length=20)),
            ],
            options={
                'db_table': '"socials"',
            },
        ),
        migrations.CreateModel(
            name='UserBlock',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('ip', models.CharField(max_length=50, null=True)),
                ('reason', models.CharField(max_length=254, null=True)),
            ],
            options={
                'db_table': '"user_blocks"',
            },
        ),
        migrations.CreateModel(
            name='UserLogs',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', models.CharField(max_length=200)),
                ('type_log', models.CharField(
                    choices=[('login_by_credentials', 'Login By Credentials'), ('refresh_token', 'Refresh Token'),
                             ('logout', 'Logout'), ('register', 'Register'), ('token_sent', 'Token Sent'),
                             ('token_confirmed', 'Token Confirmed')], max_length=50)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('service', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='service_logs',
                                              to='drf_auth_service.service')),
            ],
            options={
                'db_table': '"user_logs"',
            },
        ),
    ]
