# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from data_repo_client.api_client import ApiClient
from data_repo_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DataRepositoryServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_access_url(self, object_id, access_id, **kwargs):  # noqa: E501
        """Get a URL for fetching bytes.  # noqa: E501

        Returns a URL that can be used to fetch the object bytes. This method only needs to be called when using an `AccessMethod` that contains an `access_id` (e.g., for servers that use signed URLs for fetching object bytes).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access_url(object_id, access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: An `id` of a Data Object (required)
        :param str access_id: An `access_id` from the `access_methods` list of a Data Object (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DRSAccessURL
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_access_url_with_http_info(object_id, access_id, **kwargs)  # noqa: E501

    def get_access_url_with_http_info(self, object_id, access_id, **kwargs):  # noqa: E501
        """Get a URL for fetching bytes.  # noqa: E501

        Returns a URL that can be used to fetch the object bytes. This method only needs to be called when using an `AccessMethod` that contains an `access_id` (e.g., for servers that use signed URLs for fetching object bytes).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access_url_with_http_info(object_id, access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: An `id` of a Data Object (required)
        :param str access_id: An `access_id` from the `access_methods` list of a Data Object (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DRSAccessURL, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'object_id',
            'access_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_access_url" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and ('object_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['object_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `object_id` when calling `get_access_url`")  # noqa: E501
        # verify the required parameter 'access_id' is set
        if self.api_client.client_side_validation and ('access_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['access_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `access_id` when calling `get_access_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'object_id' in local_var_params:
            path_params['object_id'] = local_var_params['object_id']  # noqa: E501
        if 'access_id' in local_var_params:
            path_params['access_id'] = local_var_params['access_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['googleoauth']  # noqa: E501

        return self.api_client.call_api(
            '/ga4gh/drs/v1/objects/{object_id}/access/{access_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DRSAccessURL',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_object(self, object_id, **kwargs):  # noqa: E501
        """Get info about an `Object`.  # noqa: E501

        Returns object metadata, and a list of access methods that can be used to fetch object bytes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_object(object_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: (required)
        :param bool expand: If false and the object_id refers to a bundle, then the ContentsObject array contains only those objects directly contained in the bundle. That is, if the bundle contains other bundles, those other bundles are not recursively included in the result. If true and the object_id refers to a bundle, then the entire set of objects in the bundle is expanded. That is, if the bundle contains another bundles, then those other bundles are recursively expanded and included in the result. Recursion continues through the entire sub-tree of the bundle. If the object_id refers to a blob, then the query parameter is ignored.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DRSObject
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_object_with_http_info(object_id, **kwargs)  # noqa: E501

    def get_object_with_http_info(self, object_id, **kwargs):  # noqa: E501
        """Get info about an `Object`.  # noqa: E501

        Returns object metadata, and a list of access methods that can be used to fetch object bytes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_object_with_http_info(object_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: (required)
        :param bool expand: If false and the object_id refers to a bundle, then the ContentsObject array contains only those objects directly contained in the bundle. That is, if the bundle contains other bundles, those other bundles are not recursively included in the result. If true and the object_id refers to a bundle, then the entire set of objects in the bundle is expanded. That is, if the bundle contains another bundles, then those other bundles are recursively expanded and included in the result. Recursion continues through the entire sub-tree of the bundle. If the object_id refers to a blob, then the query parameter is ignored.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DRSObject, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'object_id',
            'expand'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_object" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and ('object_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['object_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `object_id` when calling `get_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'object_id' in local_var_params:
            path_params['object_id'] = local_var_params['object_id']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params and local_var_params['expand'] is not None:  # noqa: E501
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['googleoauth']  # noqa: E501

        return self.api_client.call_api(
            '/ga4gh/drs/v1/objects/{object_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DRSObject',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_service_info(self, **kwargs):  # noqa: E501
        """Get information about this implementation.  # noqa: E501

        May return service version and other information. [dd]NOTE: technically, this has been removed from DRS V1.0. It will be added back when there is a common service_info across ga4gh. I don't expect it to be too different, so just leaving this info call in place.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_service_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DRSServiceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_service_info_with_http_info(**kwargs)  # noqa: E501

    def get_service_info_with_http_info(self, **kwargs):  # noqa: E501
        """Get information about this implementation.  # noqa: E501

        May return service version and other information. [dd]NOTE: technically, this has been removed from DRS V1.0. It will be added back when there is a common service_info across ga4gh. I don't expect it to be too different, so just leaving this info call in place.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_service_info_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DRSServiceInfo, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_service_info" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['googleoauth']  # noqa: E501

        return self.api_client.call_api(
            '/ga4gh/drs/v1/service-info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DRSServiceInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_access_url(self, object_id, access_id, drs_passport_request_model, **kwargs):  # noqa: E501
        """Get a URL for fetching bytes through POST'ing a Passport  # noqa: E501

        Returns a URL that can be used to fetch the bytes of a `DrsObject`. This method only needs to be called when using an `AccessMethod` that contains an `access_id` (e.g., for servers that use signed URLs for fetching object bytes). Method is a POST to accomodate a JWT GA4GH Passport sent in the formData in order to authorize access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_access_url(object_id, access_id, drs_passport_request_model, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: An `id` of a Data Object (required)
        :param str access_id: An `access_id` from the `access_methods` list of a Data Object (required)
        :param DRSPassportRequestModel drs_passport_request_model: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DRSAccessURL
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_access_url_with_http_info(object_id, access_id, drs_passport_request_model, **kwargs)  # noqa: E501

    def post_access_url_with_http_info(self, object_id, access_id, drs_passport_request_model, **kwargs):  # noqa: E501
        """Get a URL for fetching bytes through POST'ing a Passport  # noqa: E501

        Returns a URL that can be used to fetch the bytes of a `DrsObject`. This method only needs to be called when using an `AccessMethod` that contains an `access_id` (e.g., for servers that use signed URLs for fetching object bytes). Method is a POST to accomodate a JWT GA4GH Passport sent in the formData in order to authorize access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_access_url_with_http_info(object_id, access_id, drs_passport_request_model, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: An `id` of a Data Object (required)
        :param str access_id: An `access_id` from the `access_methods` list of a Data Object (required)
        :param DRSPassportRequestModel drs_passport_request_model: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DRSAccessURL, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'object_id',
            'access_id',
            'drs_passport_request_model'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_access_url" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and ('object_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['object_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `object_id` when calling `post_access_url`")  # noqa: E501
        # verify the required parameter 'access_id' is set
        if self.api_client.client_side_validation and ('access_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['access_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `access_id` when calling `post_access_url`")  # noqa: E501
        # verify the required parameter 'drs_passport_request_model' is set
        if self.api_client.client_side_validation and ('drs_passport_request_model' not in local_var_params or  # noqa: E501
                                                        local_var_params['drs_passport_request_model'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `drs_passport_request_model` when calling `post_access_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'object_id' in local_var_params:
            path_params['object_id'] = local_var_params['object_id']  # noqa: E501
        if 'access_id' in local_var_params:
            path_params['access_id'] = local_var_params['access_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'drs_passport_request_model' in local_var_params:
            body_params = local_var_params['drs_passport_request_model']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['googleoauth']  # noqa: E501

        return self.api_client.call_api(
            '/ga4gh/drs/v1/objects/{object_id}/access/{access_id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DRSAccessURL',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_object(self, object_id, drs_passport_request_model, **kwargs):  # noqa: E501
        """Get info about a DrsObject through POST'ing a Passport.  # noqa: E501

        Returns object metadata, and a list of access methods that can be used to fetch object bytes.  Method is a POST to accomodate a JWT GA4GH Passport sent in the formData in order to authorize access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_object(object_id, drs_passport_request_model, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: (required)
        :param DRSPassportRequestModel drs_passport_request_model: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DRSObject
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_object_with_http_info(object_id, drs_passport_request_model, **kwargs)  # noqa: E501

    def post_object_with_http_info(self, object_id, drs_passport_request_model, **kwargs):  # noqa: E501
        """Get info about a DrsObject through POST'ing a Passport.  # noqa: E501

        Returns object metadata, and a list of access methods that can be used to fetch object bytes.  Method is a POST to accomodate a JWT GA4GH Passport sent in the formData in order to authorize access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_object_with_http_info(object_id, drs_passport_request_model, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str object_id: (required)
        :param DRSPassportRequestModel drs_passport_request_model: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DRSObject, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'object_id',
            'drs_passport_request_model'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_object" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'object_id' is set
        if self.api_client.client_side_validation and ('object_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['object_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `object_id` when calling `post_object`")  # noqa: E501
        # verify the required parameter 'drs_passport_request_model' is set
        if self.api_client.client_side_validation and ('drs_passport_request_model' not in local_var_params or  # noqa: E501
                                                        local_var_params['drs_passport_request_model'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `drs_passport_request_model` when calling `post_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'object_id' in local_var_params:
            path_params['object_id'] = local_var_params['object_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'drs_passport_request_model' in local_var_params:
            body_params = local_var_params['drs_passport_request_model']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['googleoauth']  # noqa: E501

        return self.api_client.call_api(
            '/ga4gh/drs/v1/objects/{object_id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DRSObject',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
