from setuptools import setup, find_packages

with open("README.md", "r") as fh:
    long_description = fh.read()

setup(
    name="japscandownloader",
    version="1.0.4",
    author="Harkame",
    description="Script to download mangas from JapScan",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/Harkame/JapScanDownloader",
    packages=find_packages(),
    classifiers=["Programming Language :: Python",],
    install_requires=[
        "lxml==4.5.1",
        "pillow==7.1.2",
        "pyyaml==5.3.1",
        "selenium==3.141.0",
        "tqdm==4.46.0",
        "urllib3==1.25.9",
    ],
    dependency_links=[],
    extras_require={
        "dev": [
            "appdirs==1.4.4",
            "attrs==19.3.0",
            "beautifulsoup4==4.9.1",
            "black==19.10b0; python_version >= '3.6'",
            "cached-property==1.5.1",
            "cerberus==1.3.2",
            "certifi==2020.4.5.1",
            "chardet==3.0.4",
            "click==7.1.2",
            "cloudscraper==1.2.38",
            "colorama==0.4.3",
            "coverage==5.1",
            "distlib==0.3.0",
            "idna==2.9",
            "importlib-metadata==1.6.0; python_version < '3.8'",
            "more-itertools==8.3.0",
            "nose==1.3.7",
            "numpy==1.18.4",
            "orderedmultidict==1.0.1",
            "packaging==19.2",
            "pathspec==0.8.0",
            "pep517==0.8.2",
            "pip-shims==0.5.2",
            "pipenv-setup==3.0.1",
            "pipfile==0.0.2",
            "plette[validation]==0.2.3",
            "pluggy==0.13.1",
            "py==1.8.1",
            "pyparsing==2.4.7",
            "pytest==5.4.2",
            "pytest-cov==2.8.1",
            "python-dateutil==2.8.1",
            "regex==2020.5.14",
            "requests==2.23.0",
            "requests-toolbelt==0.9.1",
            "requirementslib==1.5.8",
            "six==1.14.0",
            "soupsieve==2.0.1",
            "toml==0.10.1",
            "tomlkit==0.6.0",
            "typed-ast==1.4.1",
            "typing==3.7.4.1",
            "urllib3==1.25.9",
            "vistir==0.5.1",
            "wcwidth==0.1.9",
            "wheel==0.34.2",
            "zipp==3.1.0; python_version < '3.8'",
        ]
    },
    entry_points={
        "console_scripts": ["japscandownloader = japscandownloader.main:main"],
    },
)
