# Generated by Django 2.2.1 on 2019-06-02 22:26

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import markupfield.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='BlackListedDomain',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('domain', models.CharField(db_index=True, max_length=200)),
            ],
            options={
                'ordering': ('domain',),
            },
        ),
        migrations.CreateModel(
            name='TreeComment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('path', models.CharField(max_length=255, unique=True)),
                ('depth', models.PositiveIntegerField()),
                ('numchild', models.PositiveIntegerField(default=0)),
                ('user_name', models.CharField(blank=True, max_length=50, verbose_name="user's name")),
                ('user_email', models.EmailField(blank=True, max_length=254, verbose_name="user's email address")),
                ('user_url', models.URLField(blank=True, verbose_name="user's URL")),
                ('comment', markupfield.fields.MarkupField(rendered_field=True, verbose_name='comment')),
                ('comment_markup_type', models.CharField(choices=[('', '--'), ('markdown', 'markdown'), ('Draft.js', 'Draft.js')], default='Draft.js', max_length=30)),
                ('submit_date', models.DateTimeField(db_index=True, default=django.utils.timezone.now, verbose_name='date/time submitted')),
                ('_comment_rendered', models.TextField(editable=False)),
                ('ip_address', models.GenericIPAddressField(blank=True, null=True, unpack_ipv4=True, verbose_name='IP address')),
                ('is_public', models.BooleanField(default=True, help_text='Uncheck this box to make the comment effectively disappear from the site.', verbose_name='is public')),
                ('is_removed', models.BooleanField(default=False, help_text='Check this box if the comment is inappropriate. A "This comment has been removed" message will be displayed instead.', verbose_name='is removed')),
                ('followup', models.BooleanField(blank=True, default=False, help_text='Notify follow-up comments')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='treecomment_comments', to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CommentAssociation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
                ('object_pk', models.TextField(verbose_name='object ID')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='content_type_set_for_commentassociation', to='contenttypes.ContentType', verbose_name='content type')),
                ('root', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='django_comments_tree.TreeComment')),
                ('site', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
            ],
        ),
        migrations.CreateModel(
            name='TreeCommentFlag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('flag', models.CharField(db_index=True, max_length=30, verbose_name='flag')),
                ('flag_date', models.DateTimeField(default=None, verbose_name='date')),
                ('comment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='flags', to='django_comments_tree.TreeComment', verbose_name='comment')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='treecomment_flags', to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'comment flag',
                'verbose_name_plural': 'comment flags',
                'unique_together': {('user', 'comment', 'flag')},
            },
        ),
    ]
