# Python Client

Client for iv4XR [plugin](https://github.com/iv4xr-project/iv4xr-se-plugin). It can be used to control
the [Space Engineers](https://www.spaceengineersgame.com/)
game. The plugin is developed by [GoodAI](https://www.goodai.com/).

As an alternative there is more advanced client
in [Kotlin](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/JvmClient).

## Installation

The client itself doesn't have any dependencies, but some examples do:

- [Maze generator example](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/PythonClient/examples/maze.py)
  uses a great maze generator library [mazelib](https://github.com/john-science/mazelib)
- Cucumber test uses [behave](https://behave.readthedocs.io/en/stable/)
- [PNG](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/PythonClient/examples/png.py)
  uses [Pillow](https://github.com/python-pillow/Pillow).

If you want to install those dependencies, simply install them through pip:

```
pip install -r requirements.txt
```

## Basic usage

To use the client, you have to have Space Engineers game with
a [running iv4XR plugin](https://github.com/iv4xr-project/iv4xr-se-plugin/#how-to-run-the-game-with-plugin).

To connect to a local game with a running plugin:

```
from spaceengineers.proxy import SpaceEngineersProxy
se = SpaceEngineersProxy.localhost()
# Example - go to "Load game" screen (game has to be in the main menu):
se.Screens.MainMenu.LoadGame()
```

For more API, take a look
at [api.py](https://github.com/iv4xr-project/iv4xr-se-plugin/blob/main/PythonClient/spaceengineers/api.py).
Class `SpaceEngineers` being the root of the API tree.

See [examples directory](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/PythonClient/examples) for more.

## Limitations

- All API calls have to be made either with all arguments named or all arguments positional (named arguments are
  recommended). Mixture is not allowed and will cause an error.
- All default values have to be provided.

## Background

The client is simple wrapper around [JSON-RPC](https://www.jsonrpc.org/specification)
protocol.
Files [models.py](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/PythonClient/spaceengineers/models.py)
and [api.py](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/PythonClient/spaceengineers/api.py) are
generated by
[kotlin client](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/JvmClient/src/jvmMain/kotlin/spaceEngineers/util/generator/python)
.

## Cucumber implementation

The project includes a single feature file
[C284491.feature](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/PythonClient/features/C284491.feature)
. This file has been copied from kotlin client. By implementing steps it showcases re-usability of
[gherkin](https://cucumber.io/docs/gherkin/reference/)

Type `behave` from the root of the project to run the test (behave needs to be installed, see
[Installation](#installation)). Or you can right-click the feature file in PyCharm and select `Run`.

## Useful links

- [Kotlin client](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/PythonClient/../JvmClient)
- [Basics](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/PythonClient/../JvmClient/docs/Basics.MD)
- [Blocks](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/PythonClient/../JvmClient/docs/Blocks.MD)
- [Movement](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/PythonClient/../JvmClient/docs/Movement.MD)
- [Screens](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/PythonClient/../JvmClient/docs/Screens.MD)
- [Automated testing](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/PythonClient/../JvmClient/docs/Automated-Testing.MD)
- [Multiplayer](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/PythonClient/../JvmClient/docs/Multiplayer.MD)
- [Ownership](https://github.com/iv4xr-project/iv4xr-se-plugin/tree/main/PythonClient/../JvmClient/docs/Ownership.MD)
