# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: services/provider/v1/access-management.proto, services/provider/v1/provider.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ...account import v1 as __account_v1__
from ...common import v1 as __common_v1__


if TYPE_CHECKING:
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class ParticipantType(betterproto.Enum):
    """Type of participant being invited to ecosystem"""

    participant_type_individual = 0
    """Participant is an individual"""

    participant_type_organization = 1
    """Participant is an organization"""


class InvitationStatusResponseStatus(betterproto.Enum):
    Error = 0
    """Onboarding resulted in error"""

    InvitationSent = 1
    """The participant has been invited"""

    Completed = 2
    """The participant has been onboarded"""

    Expired = 3
    """The invite has expired"""


class IonOptionsIonNetwork(betterproto.Enum):
    TestNet = 0
    MainNet = 1


class IndyOptionsIndyNetwork(betterproto.Enum):
    Danube = 0
    SovrinBuilder = 1
    SovrinStaging = 2
    Sovrin = 3
    IdUnionTest = 4
    IdUnion = 5
    IndicioTest = 6
    IndicioDemo = 7
    Indicio = 8


@dataclass(eq=False, repr=False)
class AddRoleAssignmentRequest(betterproto.Message):
    """Role management"""

    role: str = betterproto.string_field(1)
    """Role to assign"""

    email: str = betterproto.string_field(2, group="account")
    """
    Email address of account to assign role. Mutually exclusive with `walletId`
    and `didUri`.
    """

    wallet_id: str = betterproto.string_field(3, group="account")
    """
    Wallet ID of account to assign role to. Mutually exclusive with `email` and
    `didUri`.
    """

    did_uri: str = betterproto.string_field(4, group="account")
    """
    DID URI of the account to assign role. Mutually exclusive with `email` and
    `walletId`.
    """


@dataclass(eq=False, repr=False)
class AddRoleAssignmentResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RemoveRoleAssignmentRequest(betterproto.Message):
    role: str = betterproto.string_field(1)
    """Role to unassign"""

    email: str = betterproto.string_field(2, group="account")
    """
    Email address of account to unassign role. Mutually exclusive with
    `walletId` and `didUri`.
    """

    wallet_id: str = betterproto.string_field(3, group="account")
    """
    Wallet ID of account to unassign role. Mutually exclusive with `email` and
    `didUri`.
    """

    did_uri: str = betterproto.string_field(4, group="account")
    """
    DID URI of the account to unassign role. Mutually exclusive with `email`
    and `walletId`.
    """


@dataclass(eq=False, repr=False)
class RemoveRoleAssignmentResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ListRoleAssignmentsRequest(betterproto.Message):
    """Request to fetch the list of roles assigned to the current account"""

    email: str = betterproto.string_field(2, group="account")
    """
    Email address of account to list roles. Mutually exclusive with `walletId`
    and `didUri`.
    """

    wallet_id: str = betterproto.string_field(3, group="account")
    """
    Wallet ID of account to list roles. Mutually exclusive with `email` and
    `didUri`.
    """

    did_uri: str = betterproto.string_field(4, group="account")
    """
    DID URI of the account to list roles. Mutually exclusive with `email` and
    `walletId`.
    """


@dataclass(eq=False, repr=False)
class ListRoleAssignmentsResponse(betterproto.Message):
    roles: List[str] = betterproto.string_field(1)
    """List of roles"""


@dataclass(eq=False, repr=False)
class ListAvailableRolesRequest(betterproto.Message):
    """Request to fetch the available roles in the current ecosystem"""

    pass


@dataclass(eq=False, repr=False)
class ListAvailableRolesResponse(betterproto.Message):
    roles: List[str] = betterproto.string_field(1)
    """List of roles"""


@dataclass(eq=False, repr=False)
class InviteRequest(betterproto.Message):
    """Request to invite a participant to an ecosystem"""

    participant: "ParticipantType" = betterproto.enum_field(1)
    """Type of participant being invited (individual/organization)"""

    description: str = betterproto.string_field(2)
    """Description of invitation"""

    details: "__account_v1__.AccountDetails" = betterproto.message_field(3)
    """Account details of invitee"""

    def __post_init__(self) -> None:
        warnings.warn("InviteRequest is deprecated", DeprecationWarning)
        super().__post_init__()


@dataclass(eq=False, repr=False)
class InviteRequestDidCommInvitation(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class InviteResponse(betterproto.Message):
    """Response to `InviteRequest`"""

    invitation_id: str = betterproto.string_field(10)
    """ID of created invitation"""

    invitation_code: str = betterproto.string_field(11)
    """Invitation code -- must be passed back in `LoginRequest`"""

    def __post_init__(self) -> None:
        warnings.warn("InviteResponse is deprecated", DeprecationWarning)
        super().__post_init__()


@dataclass(eq=False, repr=False)
class InvitationStatusRequest(betterproto.Message):
    """Request details for the status of an invitation"""

    invitation_id: str = betterproto.string_field(1)
    """ID of invitation, received from `InviteResponse`"""

    def __post_init__(self) -> None:
        warnings.warn("InvitationStatusRequest is deprecated", DeprecationWarning)
        super().__post_init__()


@dataclass(eq=False, repr=False)
class InvitationStatusResponse(betterproto.Message):
    """Response to `InvitationStatusRequest`"""

    status: "InvitationStatusResponseStatus" = betterproto.enum_field(1)
    """Status of invitation"""

    status_details: str = betterproto.string_field(2)
    """Human-readable string with details about invitation status"""

    def __post_init__(self) -> None:
        warnings.warn("InvitationStatusResponse is deprecated", DeprecationWarning)
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Ecosystem(betterproto.Message):
    """Details of an ecosystem"""

    id: str = betterproto.string_field(1)
    """URN of the ecosystem"""

    name: str = betterproto.string_field(2)
    """Globally unique name for the ecosystem"""

    description: str = betterproto.string_field(3)
    """Ecosystem description"""

    uri: str = betterproto.string_field(4)
    """External URL associated with the organization or ecosystem entity"""

    webhooks: List["WebhookConfig"] = betterproto.message_field(5)
    """Configured webhooks, if any"""

    display: "EcosystemDisplay" = betterproto.message_field(6)
    """Display details"""

    domain: str = betterproto.string_field(7)
    """Domain"""

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("uri"):
            warnings.warn("Ecosystem.uri is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class WebhookConfig(betterproto.Message):
    """Webhook configured on an ecosystem"""

    id: str = betterproto.string_field(1)
    """UUID of the webhook"""

    destination_url: str = betterproto.string_field(2)
    """HTTPS URL to POST webhook calls to"""

    events: List[str] = betterproto.string_field(4)
    """Events the webhook is subscribed to"""

    status: str = betterproto.string_field(5)
    """
    Last known status of webhook (whether or not Trinsic can successfully reach
    destination)
    """


@dataclass(eq=False, repr=False)
class Grant(betterproto.Message):
    """A grant authorizing `actions` on a `resourceId`"""

    resource_id: str = betterproto.string_field(1)
    """the urn of the resource"""

    actions: List[str] = betterproto.string_field(2)
    """list of actions that are allowed"""

    child_grants: List["Grant"] = betterproto.message_field(3)
    """any child grants"""


@dataclass(eq=False, repr=False)
class CreateEcosystemRequest(betterproto.Message):
    """Request to create an ecosystem"""

    name: str = betterproto.string_field(1)
    """
    Globally unique name for the Ecosystem. This name will be part of the
    ecosystem-specific URLs and namespaces. Allowed characters are lowercase
    letters, numbers, underscore and hyphen. If not passed, ecosystem name will
    be auto-generated.
    """

    description: str = betterproto.string_field(2)
    """Ecosystem description"""

    uri: str = betterproto.string_field(3)
    """External URL associated with your organization or ecosystem entity"""

    details: "__account_v1__.AccountDetails" = betterproto.message_field(4)
    """The account details of the owner of the ecosystem"""

    domain: str = betterproto.string_field(5)
    """New domain URL"""

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("uri"):
            warnings.warn(
                "CreateEcosystemRequest.uri is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class CreateEcosystemResponse(betterproto.Message):
    """Response to `CreateEcosystemRequest`"""

    ecosystem: "Ecosystem" = betterproto.message_field(1)
    """Details of the created ecosystem"""

    profile: "__account_v1__.AccountProfile" = betterproto.message_field(2)
    """Account profile for auth of the owner of the ecosystem"""

    confirmation_method: "__account_v1__.ConfirmationMethod" = betterproto.enum_field(3)
    """Indicates if confirmation of account is required."""


@dataclass(eq=False, repr=False)
class UpdateEcosystemRequest(betterproto.Message):
    """Request to update an ecosystem's metadata"""

    description: str = betterproto.string_field(1)
    """New description of the ecosystem"""

    uri: str = betterproto.string_field(2)
    """
    New external URL associated with the organization or ecosystem entity
    """

    domain: str = betterproto.string_field(3)
    """New domain URL"""

    display: "EcosystemDisplayRequest" = betterproto.message_field(5)
    """New name string name = 4; Display details"""

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("uri"):
            warnings.warn(
                "UpdateEcosystemRequest.uri is deprecated", DeprecationWarning
            )
        if self.is_set("display"):
            warnings.warn(
                "UpdateEcosystemRequest.display is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class EcosystemDisplayRequest(betterproto.Message):
    light: "EcosystemDisplayDetailsRequest" = betterproto.message_field(2)
    """
    Removed the Dark after discussion with team, as we don't provide a dark UI
    anywhere (yet) in our platform. EcosystemDisplayDetailsRequest dark = 1;
    """


@dataclass(eq=False, repr=False)
class EcosystemDisplayDetailsRequest(betterproto.Message):
    color: str = betterproto.string_field(4)
    """string id = 1; string name = 2;    string logo_url = 3;"""

    logo_data: bytes = betterproto.bytes_field(5)
    logo_format: str = betterproto.string_field(6)
    """MIME type of the file"""


@dataclass(eq=False, repr=False)
class UpdateEcosystemResponse(betterproto.Message):
    """Response to `UpdateEcosystemRequest`"""

    ecosystem: "Ecosystem" = betterproto.message_field(1)
    """Current ecosystem metadata, post-update"""


@dataclass(eq=False, repr=False)
class EcosystemDisplay(betterproto.Message):
    light: "EcosystemDisplayDetails" = betterproto.message_field(2)
    """
    Removed the Dark after discussion with team, as we don't provide a dark UI
    anywhere (yet) in our platform.    EcosystemDisplayDetails dark = 1;
    """


@dataclass(eq=False, repr=False)
class EcosystemDisplayDetails(betterproto.Message):
    logo_url: str = betterproto.string_field(3)
    """string id = 1; string name = 2;"""

    color: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class AddWebhookRequest(betterproto.Message):
    """Request to add a webhook to an ecosystem"""

    destination_url: str = betterproto.string_field(1)
    """Destination to post webhook calls to. Must be a reachable HTTPS URL."""

    secret: str = betterproto.string_field(2)
    """
    Secret string used for HMAC-SHA256 signing of webhook payloads to verify
    that a webhook comes from Trinsic
    """

    events: List[str] = betterproto.string_field(3)
    """Events to subscribe to. Default is "*" (all events)"""


@dataclass(eq=False, repr=False)
class AddWebhookResponse(betterproto.Message):
    """Response to `AddWebhookRequest`"""

    ecosystem: "Ecosystem" = betterproto.message_field(1)
    """Ecosystem data with new webhook"""


@dataclass(eq=False, repr=False)
class DeleteWebhookRequest(betterproto.Message):
    """Request to delete a webhook from an ecosystem"""

    webhook_id: str = betterproto.string_field(1)
    """ID of webhook to delete"""


@dataclass(eq=False, repr=False)
class DeleteWebhookResponse(betterproto.Message):
    """Response to `DeleteWebhookRequest`"""

    ecosystem: "Ecosystem" = betterproto.message_field(1)
    """Ecosystem data after removal of webhook"""


@dataclass(eq=False, repr=False)
class EcosystemInfoRequest(betterproto.Message):
    """Request to fetch information about an ecosystem"""

    pass


@dataclass(eq=False, repr=False)
class EcosystemInfoResponse(betterproto.Message):
    """Response to `InfoRequest`"""

    ecosystem: "Ecosystem" = betterproto.message_field(1)
    """Ecosystem corresponding to current ecosystem in the account token"""


@dataclass(eq=False, repr=False)
class GetPublicEcosystemInfoRequest(betterproto.Message):
    """Request to fetch information about an ecosystem"""

    ecosystem_id: str = betterproto.string_field(1)

    def __post_init__(self) -> None:
        warnings.warn("GetPublicEcosystemInfoRequest is deprecated", DeprecationWarning)
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GetPublicEcosystemInfoResponse(betterproto.Message):
    """Response to `InfoRequest`"""

    ecosystem: "PublicEcosystemInformation" = betterproto.message_field(1)
    """Ecosystem corresponding to requested `ecosystem_id`"""

    def __post_init__(self) -> None:
        warnings.warn(
            "GetPublicEcosystemInfoResponse is deprecated", DeprecationWarning
        )
        super().__post_init__()


@dataclass(eq=False, repr=False)
class PublicEcosystemInformation(betterproto.Message):
    name: str = betterproto.string_field(1)
    """Public name of this ecosystem"""

    domain: str = betterproto.string_field(2)
    """Public domain for the owner of this ecosystem"""

    domain_verified: bool = betterproto.bool_field(3)
    """Trinsic verified the domain is owned by the owner of this ecosystem"""

    style_display: "EcosystemDisplay" = betterproto.message_field(4)
    """Style display information"""

    description: str = betterproto.string_field(5)
    """Description of the ecosystem"""

    def __post_init__(self) -> None:
        warnings.warn("PublicEcosystemInformation is deprecated", DeprecationWarning)
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GetOberonKeyRequest(betterproto.Message):
    """
    Request to fetch the Trinsic public key used to verify authentication token
    validity
    """

    pass


@dataclass(eq=False, repr=False)
class GetOberonKeyResponse(betterproto.Message):
    """Response to `GetOberonKeyRequest`"""

    key: str = betterproto.string_field(1)
    """Oberon Public Key as RAW base64-url encoded string"""


@dataclass(eq=False, repr=False)
class RetrieveDomainVerificationRecordRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RetrieveDomainVerificationRecordResponse(betterproto.Message):
    """
    Response message containing a TXT record content for domain url
    verification
    """

    verification_record_name: str = betterproto.string_field(1)
    """TXT record name to use for domain verification"""

    verification_record_value: str = betterproto.string_field(2)
    """TXT code for domain verification"""


@dataclass(eq=False, repr=False)
class RefreshDomainVerificationStatusRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RefreshDomainVerificationStatusResponse(betterproto.Message):
    domain: str = betterproto.string_field(1)
    """Domain URL verified"""

    domain_verified: bool = betterproto.bool_field(2)
    """Specifies if the above `domain` was successfully verified"""


@dataclass(eq=False, repr=False)
class SearchWalletConfigurationsRequest(betterproto.Message):
    """Search for issuers/holders/verifiers"""

    query_filter: str = betterproto.string_field(1)
    """SQL filter to execute. `SELECT * FROM _ WHERE [**queryFilter**]`"""

    continuation_token: str = betterproto.string_field(2)
    """
    Token provided by previous `SearchResponse` if more data is available for
    query
    """


@dataclass(eq=False, repr=False)
class SearchWalletConfigurationResponse(betterproto.Message):
    results: List["WalletConfiguration"] = betterproto.message_field(1)
    """Results matching the search query"""

    has_more: bool = betterproto.bool_field(2)
    """
    Whether more results are available for this query via `continuation_token`
    """

    continuation_token: str = betterproto.string_field(4)
    """Token to fetch next set of results via `SearchRequest`"""


@dataclass(eq=False, repr=False)
class WalletConfiguration(betterproto.Message):
    """Strongly typed information about wallet configurations"""

    name: str = betterproto.string_field(1)
    email: str = betterproto.string_field(2)
    sms: str = betterproto.string_field(3)
    wallet_id: str = betterproto.string_field(4)
    public_did: str = betterproto.string_field(5)
    config_type: str = betterproto.string_field(6)


@dataclass(eq=False, repr=False)
class IonOptions(betterproto.Message):
    """Options for creation of DID on the ION network"""

    network: "IonOptionsIonNetwork" = betterproto.enum_field(1)
    """ION network on which DID should be published"""


@dataclass(eq=False, repr=False)
class IndyOptions(betterproto.Message):
    """Options for creation of DID on the SOV network"""

    network: "IndyOptionsIndyNetwork" = betterproto.enum_field(1)
    """SOV network on which DID should be published"""


@dataclass(eq=False, repr=False)
class UpgradeDidRequest(betterproto.Message):
    """Request to upgrade a wallet"""

    email: str = betterproto.string_field(1, group="account")
    """
    Email address of account to upgrade. Mutually exclusive with `walletId` and
    `didUri`.
    """

    wallet_id: str = betterproto.string_field(2, group="account")
    """
    Wallet ID of account to upgrade. Mutually exclusive with `email` and
    `didUri`.
    """

    did_uri: str = betterproto.string_field(6, group="account")
    """
    DID URI of the account to upgrade. Mutually exclusive with `email` and
    `walletId`.
    """

    method: "__common_v1__.SupportedDidMethod" = betterproto.enum_field(3)
    """DID Method to which wallet should be upgraded"""

    ion_options: "IonOptions" = betterproto.message_field(4, group="options")
    """Configuration for creation of DID on ION network"""

    indy_options: "IndyOptions" = betterproto.message_field(5, group="options")
    """Configuration for creation of DID on INDY network"""


@dataclass(eq=False, repr=False)
class UpgradeDidResponse(betterproto.Message):
    """Response to `UpgradeDIDRequest`"""

    did: str = betterproto.string_field(1)
    """New DID of wallet"""


class AccessManagementStub(betterproto.ServiceStub):
    async def add_role_assignment(
        self,
        add_role_assignment_request: "AddRoleAssignmentRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "AddRoleAssignmentResponse":
        return await self._unary_unary(
            "/services.provider.v1.AccessManagement/AddRoleAssignment",
            add_role_assignment_request,
            AddRoleAssignmentResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def remove_role_assignment(
        self,
        remove_role_assignment_request: "RemoveRoleAssignmentRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "RemoveRoleAssignmentResponse":
        return await self._unary_unary(
            "/services.provider.v1.AccessManagement/RemoveRoleAssignment",
            remove_role_assignment_request,
            RemoveRoleAssignmentResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def list_role_assignments(
        self,
        list_role_assignments_request: "ListRoleAssignmentsRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "ListRoleAssignmentsResponse":
        return await self._unary_unary(
            "/services.provider.v1.AccessManagement/ListRoleAssignments",
            list_role_assignments_request,
            ListRoleAssignmentsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def list_available_roles(
        self,
        list_available_roles_request: "ListAvailableRolesRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "ListAvailableRolesResponse":
        return await self._unary_unary(
            "/services.provider.v1.AccessManagement/ListAvailableRoles",
            list_available_roles_request,
            ListAvailableRolesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class ProviderStub(betterproto.ServiceStub):
    async def create_ecosystem(
        self,
        create_ecosystem_request: "CreateEcosystemRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "CreateEcosystemResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/CreateEcosystem",
            create_ecosystem_request,
            CreateEcosystemResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_ecosystem(
        self,
        update_ecosystem_request: "UpdateEcosystemRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "UpdateEcosystemResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/UpdateEcosystem",
            update_ecosystem_request,
            UpdateEcosystemResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def add_webhook(
        self,
        add_webhook_request: "AddWebhookRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "AddWebhookResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/AddWebhook",
            add_webhook_request,
            AddWebhookResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_webhook(
        self,
        delete_webhook_request: "DeleteWebhookRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "DeleteWebhookResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/DeleteWebhook",
            delete_webhook_request,
            DeleteWebhookResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def ecosystem_info(
        self,
        ecosystem_info_request: "EcosystemInfoRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "EcosystemInfoResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/EcosystemInfo",
            ecosystem_info_request,
            EcosystemInfoResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_public_ecosystem_info(
        self,
        get_public_ecosystem_info_request: "GetPublicEcosystemInfoRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "GetPublicEcosystemInfoResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/GetPublicEcosystemInfo",
            get_public_ecosystem_info_request,
            GetPublicEcosystemInfoResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def invite(
        self,
        invite_request: "InviteRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "InviteResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/Invite",
            invite_request,
            InviteResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def invitation_status(
        self,
        invitation_status_request: "InvitationStatusRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "InvitationStatusResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/InvitationStatus",
            invitation_status_request,
            InvitationStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_oberon_key(
        self,
        get_oberon_key_request: "GetOberonKeyRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "GetOberonKeyResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/GetOberonKey",
            get_oberon_key_request,
            GetOberonKeyResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def upgrade_did(
        self,
        upgrade_did_request: "UpgradeDidRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "UpgradeDidResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/UpgradeDID",
            upgrade_did_request,
            UpgradeDidResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def retrieve_domain_verification_record(
        self,
        retrieve_domain_verification_record_request: "RetrieveDomainVerificationRecordRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "RetrieveDomainVerificationRecordResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/RetrieveDomainVerificationRecord",
            retrieve_domain_verification_record_request,
            RetrieveDomainVerificationRecordResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def refresh_domain_verification_status(
        self,
        refresh_domain_verification_status_request: "RefreshDomainVerificationStatusRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "RefreshDomainVerificationStatusResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/RefreshDomainVerificationStatus",
            refresh_domain_verification_status_request,
            RefreshDomainVerificationStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def search_wallet_configurations(
        self,
        search_wallet_configurations_request: "SearchWalletConfigurationsRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "SearchWalletConfigurationResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/SearchWalletConfigurations",
            search_wallet_configurations_request,
            SearchWalletConfigurationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class AccessManagementBase(ServiceBase):
    async def add_role_assignment(
        self, add_role_assignment_request: "AddRoleAssignmentRequest"
    ) -> "AddRoleAssignmentResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def remove_role_assignment(
        self, remove_role_assignment_request: "RemoveRoleAssignmentRequest"
    ) -> "RemoveRoleAssignmentResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_role_assignments(
        self, list_role_assignments_request: "ListRoleAssignmentsRequest"
    ) -> "ListRoleAssignmentsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_available_roles(
        self, list_available_roles_request: "ListAvailableRolesRequest"
    ) -> "ListAvailableRolesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_add_role_assignment(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.add_role_assignment(request)
        await stream.send_message(response)

    async def __rpc_remove_role_assignment(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.remove_role_assignment(request)
        await stream.send_message(response)

    async def __rpc_list_role_assignments(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.list_role_assignments(request)
        await stream.send_message(response)

    async def __rpc_list_available_roles(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.list_available_roles(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/services.provider.v1.AccessManagement/AddRoleAssignment": grpclib.const.Handler(
                self.__rpc_add_role_assignment,
                grpclib.const.Cardinality.UNARY_UNARY,
                AddRoleAssignmentRequest,
                AddRoleAssignmentResponse,
            ),
            "/services.provider.v1.AccessManagement/RemoveRoleAssignment": grpclib.const.Handler(
                self.__rpc_remove_role_assignment,
                grpclib.const.Cardinality.UNARY_UNARY,
                RemoveRoleAssignmentRequest,
                RemoveRoleAssignmentResponse,
            ),
            "/services.provider.v1.AccessManagement/ListRoleAssignments": grpclib.const.Handler(
                self.__rpc_list_role_assignments,
                grpclib.const.Cardinality.UNARY_UNARY,
                ListRoleAssignmentsRequest,
                ListRoleAssignmentsResponse,
            ),
            "/services.provider.v1.AccessManagement/ListAvailableRoles": grpclib.const.Handler(
                self.__rpc_list_available_roles,
                grpclib.const.Cardinality.UNARY_UNARY,
                ListAvailableRolesRequest,
                ListAvailableRolesResponse,
            ),
        }


class ProviderBase(ServiceBase):
    async def create_ecosystem(
        self, create_ecosystem_request: "CreateEcosystemRequest"
    ) -> "CreateEcosystemResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_ecosystem(
        self, update_ecosystem_request: "UpdateEcosystemRequest"
    ) -> "UpdateEcosystemResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def add_webhook(
        self, add_webhook_request: "AddWebhookRequest"
    ) -> "AddWebhookResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_webhook(
        self, delete_webhook_request: "DeleteWebhookRequest"
    ) -> "DeleteWebhookResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def ecosystem_info(
        self, ecosystem_info_request: "EcosystemInfoRequest"
    ) -> "EcosystemInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_public_ecosystem_info(
        self, get_public_ecosystem_info_request: "GetPublicEcosystemInfoRequest"
    ) -> "GetPublicEcosystemInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def invite(self, invite_request: "InviteRequest") -> "InviteResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def invitation_status(
        self, invitation_status_request: "InvitationStatusRequest"
    ) -> "InvitationStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_oberon_key(
        self, get_oberon_key_request: "GetOberonKeyRequest"
    ) -> "GetOberonKeyResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def upgrade_did(
        self, upgrade_did_request: "UpgradeDidRequest"
    ) -> "UpgradeDidResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def retrieve_domain_verification_record(
        self,
        retrieve_domain_verification_record_request: "RetrieveDomainVerificationRecordRequest",
    ) -> "RetrieveDomainVerificationRecordResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def refresh_domain_verification_status(
        self,
        refresh_domain_verification_status_request: "RefreshDomainVerificationStatusRequest",
    ) -> "RefreshDomainVerificationStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def search_wallet_configurations(
        self, search_wallet_configurations_request: "SearchWalletConfigurationsRequest"
    ) -> "SearchWalletConfigurationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create_ecosystem(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.create_ecosystem(request)
        await stream.send_message(response)

    async def __rpc_update_ecosystem(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.update_ecosystem(request)
        await stream.send_message(response)

    async def __rpc_add_webhook(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.add_webhook(request)
        await stream.send_message(response)

    async def __rpc_delete_webhook(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.delete_webhook(request)
        await stream.send_message(response)

    async def __rpc_ecosystem_info(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.ecosystem_info(request)
        await stream.send_message(response)

    async def __rpc_get_public_ecosystem_info(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_public_ecosystem_info(request)
        await stream.send_message(response)

    async def __rpc_invite(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.invite(request)
        await stream.send_message(response)

    async def __rpc_invitation_status(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.invitation_status(request)
        await stream.send_message(response)

    async def __rpc_get_oberon_key(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.get_oberon_key(request)
        await stream.send_message(response)

    async def __rpc_upgrade_did(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.upgrade_did(request)
        await stream.send_message(response)

    async def __rpc_retrieve_domain_verification_record(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()
        response = await self.retrieve_domain_verification_record(request)
        await stream.send_message(response)

    async def __rpc_refresh_domain_verification_status(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()
        response = await self.refresh_domain_verification_status(request)
        await stream.send_message(response)

    async def __rpc_search_wallet_configurations(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()
        response = await self.search_wallet_configurations(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/services.provider.v1.Provider/CreateEcosystem": grpclib.const.Handler(
                self.__rpc_create_ecosystem,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateEcosystemRequest,
                CreateEcosystemResponse,
            ),
            "/services.provider.v1.Provider/UpdateEcosystem": grpclib.const.Handler(
                self.__rpc_update_ecosystem,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateEcosystemRequest,
                UpdateEcosystemResponse,
            ),
            "/services.provider.v1.Provider/AddWebhook": grpclib.const.Handler(
                self.__rpc_add_webhook,
                grpclib.const.Cardinality.UNARY_UNARY,
                AddWebhookRequest,
                AddWebhookResponse,
            ),
            "/services.provider.v1.Provider/DeleteWebhook": grpclib.const.Handler(
                self.__rpc_delete_webhook,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteWebhookRequest,
                DeleteWebhookResponse,
            ),
            "/services.provider.v1.Provider/EcosystemInfo": grpclib.const.Handler(
                self.__rpc_ecosystem_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                EcosystemInfoRequest,
                EcosystemInfoResponse,
            ),
            "/services.provider.v1.Provider/GetPublicEcosystemInfo": grpclib.const.Handler(
                self.__rpc_get_public_ecosystem_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetPublicEcosystemInfoRequest,
                GetPublicEcosystemInfoResponse,
            ),
            "/services.provider.v1.Provider/Invite": grpclib.const.Handler(
                self.__rpc_invite,
                grpclib.const.Cardinality.UNARY_UNARY,
                InviteRequest,
                InviteResponse,
            ),
            "/services.provider.v1.Provider/InvitationStatus": grpclib.const.Handler(
                self.__rpc_invitation_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                InvitationStatusRequest,
                InvitationStatusResponse,
            ),
            "/services.provider.v1.Provider/GetOberonKey": grpclib.const.Handler(
                self.__rpc_get_oberon_key,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetOberonKeyRequest,
                GetOberonKeyResponse,
            ),
            "/services.provider.v1.Provider/UpgradeDID": grpclib.const.Handler(
                self.__rpc_upgrade_did,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpgradeDidRequest,
                UpgradeDidResponse,
            ),
            "/services.provider.v1.Provider/RetrieveDomainVerificationRecord": grpclib.const.Handler(
                self.__rpc_retrieve_domain_verification_record,
                grpclib.const.Cardinality.UNARY_UNARY,
                RetrieveDomainVerificationRecordRequest,
                RetrieveDomainVerificationRecordResponse,
            ),
            "/services.provider.v1.Provider/RefreshDomainVerificationStatus": grpclib.const.Handler(
                self.__rpc_refresh_domain_verification_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                RefreshDomainVerificationStatusRequest,
                RefreshDomainVerificationStatusResponse,
            ),
            "/services.provider.v1.Provider/SearchWalletConfigurations": grpclib.const.Handler(
                self.__rpc_search_wallet_configurations,
                grpclib.const.Cardinality.UNARY_UNARY,
                SearchWalletConfigurationsRequest,
                SearchWalletConfigurationResponse,
            ),
        }
