# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: services/event/v1/event.proto
# plugin: python-betterproto
from dataclasses import dataclass

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase


class EventType(betterproto.Enum):
    """All event types"""

    PING = 0
    LOG = 1
    GOVERNANCE_FRAMEWORK_CREATED = 5
    GOVERNANCE_FRAMEWORK_MEMBER_REGISTERED = 6
    GOVERNANCE_FRAMEWORK_MEMBER_UNREGISTERED = 7
    TEMPLATE_CREATED = 10
    TEMPLATE_DELETED = 11
    WALLET_CREATED = 15
    ITEM_RECEIVED = 16
    CREDENTIAL_ISSUED = 17


@dataclass(eq=False, repr=False)
class ApiCall(betterproto.Message):
    source: str = betterproto.string_field(1)
    request: bytes = betterproto.bytes_field(2)
    response: bytes = betterproto.bytes_field(3)


@dataclass(eq=False, repr=False)
class PingV1(betterproto.Message):
    """Webhook test event"""

    id: str = betterproto.string_field(1)
    """UUID of this ping"""

    webhook_id: str = betterproto.string_field(2)
    """UUID of the webhook receiving the ping"""

    timestamp: str = betterproto.string_field(3)
    """
    Timestamp ping was requested, in ISO 8601 format (ex.
    `2022-07-07T08:09:10.11Z`)
    """

    message: str = betterproto.string_field(4)
    """Arbitrary message specified when ping was requested"""

    ecosystem_id: str = betterproto.string_field(5)
    """Ecosystem where this event originated, if any."""


@dataclass(eq=False, repr=False)
class GovernanceFrameworkCreatedV1(betterproto.Message):
    """Entity Governance Framework created and attached to ecosystem"""

    id: str = betterproto.string_field(1)
    """UUID of the governance framework"""

    ecosystem_id: str = betterproto.string_field(2)
    """UUID of the ecosystem that owns this EGF"""

    trust_registry: str = betterproto.string_field(3)
    """Trust registry associated with this EGF"""

    governing_authority: str = betterproto.string_field(4)
    """Wallet ID of the authority for this EGF"""

    type: str = betterproto.string_field(5)
    """Type of EGF"""

    name: str = betterproto.string_field(6)
    """User-friendly name for the EGF"""

    description: str = betterproto.string_field(7)
    """Description of the EGF"""

    governance_framework: str = betterproto.string_field(8)
    """URI for the EGF"""

    timestamp: str = betterproto.string_field(9)
    """
    Timestamp event occurred, in ISO 8601 format (ex.
    `2022-07-07T08:09:10.11Z`)
    """


@dataclass(eq=False, repr=False)
class TemplateCreatedV1(betterproto.Message):
    """Template created in ecosystem"""

    id: str = betterproto.string_field(1)
    """UUID of the template"""

    ecosystem_id: str = betterproto.string_field(2)
    """UUID of the ecosystem that owns this template"""

    name: str = betterproto.string_field(3)
    """Template name"""

    type: str = betterproto.string_field(4)
    """Template type"""

    created_by: str = betterproto.string_field(5)
    """WalletID that created the template"""

    timestamp: str = betterproto.string_field(6)
    """
    Timestamp event occurred, in ISO 8601 format (ex.
    `2022-07-07T08:09:10.11Z`)
    """


@dataclass(eq=False, repr=False)
class ItemReceivedV1(betterproto.Message):
    """Item inserted into wallet"""

    id: str = betterproto.string_field(1)
    """UUID of the new item"""

    received: str = betterproto.string_field(2)
    """
    Timestamp when the item was received, in ISO 8601 format (ex.
    `2022-07-07T08:09:10.11Z`)
    """

    wallet_id: str = betterproto.string_field(3)
    """ID of wallet"""

    ecosystem_id: str = betterproto.string_field(4)
    """Ecosystem where this event originated, if any."""
