# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aleksis',
 'aleksis.core',
 'aleksis.core.migrations',
 'aleksis.core.templatetags',
 'aleksis.core.tests.browser',
 'aleksis.core.tests.models',
 'aleksis.core.tests.templatetags',
 'aleksis.core.tests.views',
 'aleksis.core.util']

package_data = \
{'': ['*'],
 'aleksis.core': ['locale/ar/LC_MESSAGES/django.po',
                  'locale/ar/LC_MESSAGES/django.po',
                  'locale/ar/LC_MESSAGES/djangojs.po',
                  'locale/ar/LC_MESSAGES/djangojs.po',
                  'locale/de_DE/LC_MESSAGES/django.po',
                  'locale/de_DE/LC_MESSAGES/django.po',
                  'locale/de_DE/LC_MESSAGES/djangojs.po',
                  'locale/de_DE/LC_MESSAGES/djangojs.po',
                  'locale/fr/LC_MESSAGES/django.po',
                  'locale/fr/LC_MESSAGES/django.po',
                  'locale/fr/LC_MESSAGES/djangojs.po',
                  'locale/fr/LC_MESSAGES/djangojs.po',
                  'locale/la/LC_MESSAGES/django.po',
                  'locale/la/LC_MESSAGES/django.po',
                  'locale/la/LC_MESSAGES/djangojs.po',
                  'locale/la/LC_MESSAGES/djangojs.po',
                  'locale/nb_NO/LC_MESSAGES/django.po',
                  'locale/nb_NO/LC_MESSAGES/django.po',
                  'locale/nb_NO/LC_MESSAGES/djangojs.po',
                  'locale/nb_NO/LC_MESSAGES/djangojs.po',
                  'locale/tr_TR/LC_MESSAGES/django.po',
                  'locale/tr_TR/LC_MESSAGES/django.po',
                  'locale/tr_TR/LC_MESSAGES/djangojs.po',
                  'locale/tr_TR/LC_MESSAGES/djangojs.po',
                  'static/*',
                  'static/icons/*',
                  'static/img/*',
                  'static/js/*',
                  'templates/*',
                  'templates/components/*',
                  'templates/core/*',
                  'templates/core/announcement/*',
                  'templates/django_tables2/*',
                  'templates/dynamic_preferences/*',
                  'templates/impersonate/*',
                  'templates/material/*',
                  'templates/search/*',
                  'templates/search/indexes/core/*',
                  'templates/sms/*',
                  'templates/templated_email/*',
                  'templates/two_factor/*',
                  'templates/two_factor/core/*',
                  'templates/two_factor/profile/*']}

install_requires = \
['Django>=3.0,<4.0',
 'Pillow>=7.0,<8.0',
 'calendarweek>=0.4.3,<0.5.0',
 'colour>=0.1.5,<0.2.0',
 'django-any-js>=1.0,<2.0',
 'django-bleach>=0.6.1,<0.7.0',
 'django-cache-memoize>=0.1.6,<0.2.0',
 'django-ckeditor>=5.8.0,<6.0.0',
 'django-colorfield>=0.3.0,<0.4.0',
 'django-dbbackup>=3.3.0,<4.0.0',
 'django-debug-toolbar>=2.0,<3.0',
 'django-dynamic-preferences>=1.9,<2.0',
 'django-easy-audit>=1.2rc1,<2.0',
 'django-favicon-plus-reloaded>=1.0.4,<2.0.0',
 'django-filter>=2.2.0,<3.0.0',
 'django-guardian>=2.2.0,<3.0.0',
 'django-hattori>=0.2,<0.3',
 'django-haystack==3.0b1',
 'django-image-cropping>=1.2,<2.0',
 'django-impersonate>=1.4,<2.0',
 'django-ipware>=2.1,<3.0',
 'django-js-reverse>=0.9.1,<0.10.0',
 'django-jsonstore>=0.4.1,<0.5.0',
 'django-maintenance-mode>=0.14.0,<0.15.0',
 'django-material>=1.6.0,<2.0.0',
 'django-menu-generator>=1.0.4,<2.0.0',
 'django-middleware-global-request>=0.1.2,<0.2.0',
 'django-otp==0.9.0',
 'django-phonenumber-field[phonenumbers]>=3.0,<4.0',
 'django-polymorphic>=2.1.2,<3.0.0',
 'django-pwa>=1.0.8,<2.0.0',
 'django-reversion>=3.0.7,<4.0.0',
 'django-sass-processor>=0.8,<0.9',
 'django-settings-context-processor>=0.2,<0.3',
 'django-tables2>=2.1,<3.0',
 'django-templated-email>=2.3.0,<3.0.0',
 'django-two-factor-auth[yubikey,phonenumbers,call,sms]>=1.11.0,<2.0.0',
 'django-yarnpkg>=6.0,<7.0',
 'django_select2>=7.1,<8.0',
 'django_widget_tweaks>=1.4.5,<2.0.0',
 'dynaconf[yaml,toml,ini]>=2.0,<3.0',
 'easy-thumbnails>=2.6,<3.0',
 'html2text>=2020.0.0,<2021.0.0',
 'libsass>=0.20.0,<0.21.0',
 'license-expression>=1.2,<2.0',
 'psycopg2>=2.8,<3.0',
 'python-memcached>=1.59,<2.0',
 'requests>=2.22,<3.0',
 'rules>=2.2,<3.0',
 'spdx-license-list>=0.4.0,<0.5.0']

extras_require = \
{'celery': ['Celery[django,redis]>=4.4.0,<5.0.0',
            'django-celery-results>=1.1.2,<2.0.0',
            'django-celery-beat>=2.0.0,<3.0.0',
            'django-celery-email>=3.0.0,<4.0.0',
            'celery-haystack>=0.7.0,<0.8.0'],
 'ldap': ['django-auth-ldap>=2.0,<3.0']}

setup_kwargs = {
    'name': 'aleksis',
    'version': '2.0a2',
    'description': 'AlekSIS (School Information System)\u200a—\u200aCore',
    'long_description': 'AlekSIS — All-libre extensible kit for school information systems\n=================================================================\n\nWarning\n-------\n\n**This is an alpha version of AlekSIS, the free school information system.\nThe AlekSIS team is looking for schools who want to help shape the 2.0\nfinal release and supports interested schools in operating AlekSIS.**\n\nWhat AlekSIS is\n----------------\n\n`AlekSIS`_ is a web-based school information system (SIS) which can be used to\nmanage and/or publish organisational subjects of educational institutions.\n\nFormerly two separate projects (BiscuIT and SchoolApps), developed by\n`Teckids e.V.`_ and a team of students at `Katharineum zu Lübeck`_, they\nwere merged into the AlekSIS project in 2020.\n\nAlekSIS is a platform based on Django, that provides central funstions\nand data structures that can be used by apps that are developed and provided\nseperately. The AlekSIS team also maintains a set of official apps which\nmake AlekSIS a fully-featured software solutions for the information\nmanagement needs of schools.\n\nBy design, the platform can be used by schools to write their own apps for\nspecific needs they face, also in coding classes. Students are empowered to\ncreate real-world applications that bring direct value to their environment.\n\nAlekSIS is part of the `schul-frei`_ project as a component in sustainable\neducational networks.\n\nCore features\n--------------\n\n* For users:\n\n * Custom menu entries (e.g. in footer)\n * Global preferences\n * Group types\n * Manage announcements\n * Manage groups\n * Manage persons\n * Notifications via SMS email or dashboard\n * Rules and permissions for users, objects and pages\n * Two factor authentication via Yubikey, OTP or SMS\n * User preferences\n\n* For admins\n\n * Asynchronous tasks with celery\n * Authentication via LDAP\n * Automatic backup of database, static and media files\n\nOfficial apps\n-------------\n\n+--------------------------------------+---------------------------------------------------------------------------------------------+\n| App name                             | Purpose                                                                                     |\n+======================================+=============================================================================================+\n| `AlekSIS-App-Chronos`_               | The Chronos app provides functionality for digital timetables.                              |\n+--------------------------------------+---------------------------------------------------------------------------------------------+\n| `AlekSIS-App-DashboardFeeds`_        | The DashboardFeeds app provides functionality to add RSS or Atom feeds to dashboard         |\n+--------------------------------------+---------------------------------------------------------------------------------------------+\n| `AlekSIS-App-Hjelp`_                 | The Hjelp app provides functionality for aiding users.                                      |\n+--------------------------------------+---------------------------------------------------------------------------------------------+\n| `AlekSIS-App-LDAP`_                  | The LDAP app provides functionality to import users and groups from LDAP                    |\n+--------------------------------------+---------------------------------------------------------------------------------------------+\n| `AlekSIS-App-Untis`_                 | This app provides import and export functions to interact with Untis, a timetable software. |\n+--------------------------------------+---------------------------------------------------------------------------------------------+\n\n\nLicence\n-------\n\n::\n\n  Copyright © 2017, 2018, 2019, 2020 Jonathan Weth <wethjo@katharineum.de>\n  Copyright © 2017, 2018, 2019 Frank Poetzsch-Heffter <p-h@katharineum.de>\n  Copyright © 2018, 2019, 2020 Julian Leucker <leuckeju@katharineum.de>\n  Copyright © 2018, 2019, 2020 Hangzhi Yu <yuha@katharineum.de>\n  Copyright © 2019, 2020 Dominik George <dominik.george@teckids.org>\n  Copyright © 2019, 2020 Tom Teichler <tom.teichler@teckids.org>\n  Copyright © 2019 mirabilos <thorsten.glaser@teckids.org>\n\n  Licenced under the EUPL, version 1.2 or later\n\nPlease see the LICENCE.rst file accompanying this distribution for the\nfull licence text or on the `European Union Public Licence`_ website\nhttps://joinup.ec.europa.eu/collection/eupl/guidelines-users-and-developers\n(including all other official language versions).\n\n.. _AlekSIS: https://aleksis.org/\n.. _Teckids e.V.: https://www.teckids.org/\n.. _Katharineum zu Lübeck: https://www.katharineum.de/\n.. _European Union Public Licence: https://eupl.eu/\n.. _schul-frei: https://schul-frei.org/\n.. _AlekSIS-App-Chronos: https://edugit.org/AlekSIS/official/AlekSIS-App-Chronos\n.. _AlekSIS-App-DashboardFeeds: https://edugit.org/AlekSIS/official/AlekSIS-App-DashboardFeeds\n.. _AlekSIS-App-Hjelp: https://edugit.org/AlekSIS/official/AlekSIS-App-Hjelp\n.. _AlekSIS-App-LDAP: https://edugit.org/AlekSIS/official/AlekSIS-App-LDAP\n.. _AlekSIS-App-Untis: https://edugit.org/AlekSIS/official/AlekSIS-App-Untis\n',
    'author': 'Dominik George',
    'author_email': 'dominik.george@teckids.org',
    'maintainer': 'Jonathan Weth',
    'maintainer_email': 'wethjo@katharineum.de',
    'url': 'https://aleksis.org/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
