import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LoggingMetricConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of this metric, which is used in documentation. The maximum length of the description is 8000 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#description LoggingMetric#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * An advanced logs filter (https://cloud.google.com/logging/docs/view/advanced-filters) which is used to match log entries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#filter LoggingMetric#filter}
     *
     * @stability stable
     */
    readonly filter: string;
    /**
     * A map from a label key string to an extractor expression which is used to extract data from a log entry field and assign as the label value.
     *
     * Each label key specified in the LabelDescriptor must
     * have an associated extractor expression in this map. The syntax of the extractor expression is
     * the same as for the valueExtractor field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#label_extractors LoggingMetric#label_extractors}
     *
     * @stability stable
     */
    readonly labelExtractors?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The client-assigned metric identifier.
     *
     * Examples - "error_count", "nginx/requests".
     * Metric identifiers are limited to 100 characters and can include only the following
     * characters A-Z, a-z, 0-9, and the special characters _-.,+!*',()%/. The forward-slash
     * character (/) denotes a hierarchy of name pieces, and it cannot be the first character
     * of the name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#name LoggingMetric#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#project LoggingMetric#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A valueExtractor is required when using a distribution logs-based metric to extract the values to record from a log entry.
     *
     * Two functions are supported for value extraction - EXTRACT(field) or
     * REGEXP_EXTRACT(field, regex). The argument are 1. field - The name of the log entry field from which
     * the value is to be extracted. 2. regex - A regular expression using the Google RE2 syntax
     * (https://github.com/google/re2/wiki/Syntax) with a single capture group to extract data from the specified
     * log entry field. The value of the field is converted to a string before applying the regex. It is an
     * error to specify a regex that does not include exactly one capture group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#value_extractor LoggingMetric#value_extractor}
     *
     * @stability stable
     */
    readonly valueExtractor?: string;
    /**
     * bucket_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#bucket_options LoggingMetric#bucket_options}
     *
     * @stability stable
     */
    readonly bucketOptions?: LoggingMetricBucketOptions;
    /**
     * metric_descriptor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#metric_descriptor LoggingMetric#metric_descriptor}
     *
     * @stability stable
     */
    readonly metricDescriptor: LoggingMetricMetricDescriptor;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#timeouts LoggingMetric#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LoggingMetricTimeouts;
}
/**
 * @stability stable
 */
export interface LoggingMetricBucketOptionsExplicitBuckets {
    /**
     * The values must be monotonically increasing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#bounds LoggingMetric#bounds}
     *
     * @stability stable
     */
    readonly bounds: number[];
}
/**
 * @stability stable
 */
export declare class LoggingMetricBucketOptionsExplicitBucketsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bounds?;
    /**
     * @stability stable
     */
    get bounds(): number[];
    /**
     * @stability stable
     */
    set bounds(value: number[]);
    /**
     * @stability stable
     */
    get boundsInput(): number[] | undefined;
}
/**
 * @stability stable
 */
export interface LoggingMetricBucketOptionsExponentialBuckets {
    /**
     * Must be greater than 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#growth_factor LoggingMetric#growth_factor}
     *
     * @stability stable
     */
    readonly growthFactor?: number;
    /**
     * Must be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#num_finite_buckets LoggingMetric#num_finite_buckets}
     *
     * @stability stable
     */
    readonly numFiniteBuckets?: number;
    /**
     * Must be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#scale LoggingMetric#scale}
     *
     * @stability stable
     */
    readonly scale?: number;
}
/**
 * @stability stable
 */
export declare class LoggingMetricBucketOptionsExponentialBucketsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _growthFactor?;
    /**
     * @stability stable
     */
    get growthFactor(): number | undefined;
    /**
     * @stability stable
     */
    set growthFactor(value: number | undefined);
    /**
     * @stability stable
     */
    resetGrowthFactor(): void;
    /**
     * @stability stable
     */
    get growthFactorInput(): number | undefined;
    private _numFiniteBuckets?;
    /**
     * @stability stable
     */
    get numFiniteBuckets(): number | undefined;
    /**
     * @stability stable
     */
    set numFiniteBuckets(value: number | undefined);
    /**
     * @stability stable
     */
    resetNumFiniteBuckets(): void;
    /**
     * @stability stable
     */
    get numFiniteBucketsInput(): number | undefined;
    private _scale?;
    /**
     * @stability stable
     */
    get scale(): number | undefined;
    /**
     * @stability stable
     */
    set scale(value: number | undefined);
    /**
     * @stability stable
     */
    resetScale(): void;
    /**
     * @stability stable
     */
    get scaleInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface LoggingMetricBucketOptionsLinearBuckets {
    /**
     * Must be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#num_finite_buckets LoggingMetric#num_finite_buckets}
     *
     * @stability stable
     */
    readonly numFiniteBuckets?: number;
    /**
     * Lower bound of the first bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#offset LoggingMetric#offset}
     *
     * @stability stable
     */
    readonly offset?: number;
    /**
     * Must be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#width LoggingMetric#width}
     *
     * @stability stable
     */
    readonly width?: number;
}
/**
 * @stability stable
 */
export declare class LoggingMetricBucketOptionsLinearBucketsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _numFiniteBuckets?;
    /**
     * @stability stable
     */
    get numFiniteBuckets(): number | undefined;
    /**
     * @stability stable
     */
    set numFiniteBuckets(value: number | undefined);
    /**
     * @stability stable
     */
    resetNumFiniteBuckets(): void;
    /**
     * @stability stable
     */
    get numFiniteBucketsInput(): number | undefined;
    private _offset?;
    /**
     * @stability stable
     */
    get offset(): number | undefined;
    /**
     * @stability stable
     */
    set offset(value: number | undefined);
    /**
     * @stability stable
     */
    resetOffset(): void;
    /**
     * @stability stable
     */
    get offsetInput(): number | undefined;
    private _width?;
    /**
     * @stability stable
     */
    get width(): number | undefined;
    /**
     * @stability stable
     */
    set width(value: number | undefined);
    /**
     * @stability stable
     */
    resetWidth(): void;
    /**
     * @stability stable
     */
    get widthInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface LoggingMetricBucketOptions {
    /**
     * explicit_buckets block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#explicit_buckets LoggingMetric#explicit_buckets}
     *
     * @stability stable
     */
    readonly explicitBuckets?: LoggingMetricBucketOptionsExplicitBuckets;
    /**
     * exponential_buckets block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#exponential_buckets LoggingMetric#exponential_buckets}
     *
     * @stability stable
     */
    readonly exponentialBuckets?: LoggingMetricBucketOptionsExponentialBuckets;
    /**
     * linear_buckets block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#linear_buckets LoggingMetric#linear_buckets}
     *
     * @stability stable
     */
    readonly linearBuckets?: LoggingMetricBucketOptionsLinearBuckets;
}
/**
 * @stability stable
 */
export declare class LoggingMetricBucketOptionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _explicitBuckets?;
    private __explicitBucketsOutput;
    /**
     * @stability stable
     */
    get explicitBuckets(): LoggingMetricBucketOptionsExplicitBucketsOutputReference;
    /**
     * @stability stable
     */
    putExplicitBuckets(value: LoggingMetricBucketOptionsExplicitBuckets | undefined): void;
    /**
     * @stability stable
     */
    resetExplicitBuckets(): void;
    /**
     * @stability stable
     */
    get explicitBucketsInput(): LoggingMetricBucketOptionsExplicitBuckets | undefined;
    private _exponentialBuckets?;
    private __exponentialBucketsOutput;
    /**
     * @stability stable
     */
    get exponentialBuckets(): LoggingMetricBucketOptionsExponentialBucketsOutputReference;
    /**
     * @stability stable
     */
    putExponentialBuckets(value: LoggingMetricBucketOptionsExponentialBuckets | undefined): void;
    /**
     * @stability stable
     */
    resetExponentialBuckets(): void;
    /**
     * @stability stable
     */
    get exponentialBucketsInput(): LoggingMetricBucketOptionsExponentialBuckets | undefined;
    private _linearBuckets?;
    private __linearBucketsOutput;
    /**
     * @stability stable
     */
    get linearBuckets(): LoggingMetricBucketOptionsLinearBucketsOutputReference;
    /**
     * @stability stable
     */
    putLinearBuckets(value: LoggingMetricBucketOptionsLinearBuckets | undefined): void;
    /**
     * @stability stable
     */
    resetLinearBuckets(): void;
    /**
     * @stability stable
     */
    get linearBucketsInput(): LoggingMetricBucketOptionsLinearBuckets | undefined;
}
/**
 * @stability stable
 */
export interface LoggingMetricMetricDescriptorLabels {
    /**
     * A human-readable description for the label.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#description LoggingMetric#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The label key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#key LoggingMetric#key}
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * The type of data that can be assigned to the label. Default value: "STRING" Possible values: ["BOOL", "INT64", "STRING"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#value_type LoggingMetric#value_type}
     *
     * @stability stable
     */
    readonly valueType?: string;
}
/**
 * @stability stable
 */
export interface LoggingMetricMetricDescriptor {
    /**
     * A concise name for the metric, which can be displayed in user interfaces.
     *
     * Use sentence case
     * without an ending period, for example "Request count". This field is optional but it is
     * recommended to be set for any metrics associated with user-visible concepts, such as Quota.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#display_name LoggingMetric#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Whether the metric records instantaneous values, changes to a value, etc.
     *
     * Some combinations of metricKind and valueType might not be supported.
     * For counter metrics, set this to DELTA. Possible values: ["DELTA", "GAUGE", "CUMULATIVE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#metric_kind LoggingMetric#metric_kind}
     *
     * @stability stable
     */
    readonly metricKind: string;
    /**
     * The unit in which the metric value is reported.
     *
     * It is only applicable if the valueType is
     * 'INT64', 'DOUBLE', or 'DISTRIBUTION'. The supported units are a subset of
     * [The Unified Code for Units of Measure](http://unitsofmeasure.org/ucum.html) standard
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#unit LoggingMetric#unit}
     *
     * @stability stable
     */
    readonly unit?: string;
    /**
     * Whether the measurement is an integer, a floating-point number, etc.
     *
     * Some combinations of metricKind and valueType might not be supported.
     * For counter metrics, set this to INT64. Possible values: ["BOOL", "INT64", "DOUBLE", "STRING", "DISTRIBUTION", "MONEY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#value_type LoggingMetric#value_type}
     *
     * @stability stable
     */
    readonly valueType: string;
    /**
     * labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#labels LoggingMetric#labels}
     *
     * @stability stable
     */
    readonly labels?: LoggingMetricMetricDescriptorLabels[];
}
/**
 * @stability stable
 */
export declare class LoggingMetricMetricDescriptorOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string | undefined;
    /**
     * @stability stable
     */
    set displayName(value: string | undefined);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _metricKind?;
    /**
     * @stability stable
     */
    get metricKind(): string;
    /**
     * @stability stable
     */
    set metricKind(value: string);
    /**
     * @stability stable
     */
    get metricKindInput(): string | undefined;
    private _unit?;
    /**
     * @stability stable
     */
    get unit(): string | undefined;
    /**
     * @stability stable
     */
    set unit(value: string | undefined);
    /**
     * @stability stable
     */
    resetUnit(): void;
    /**
     * @stability stable
     */
    get unitInput(): string | undefined;
    private _valueType?;
    /**
     * @stability stable
     */
    get valueType(): string;
    /**
     * @stability stable
     */
    set valueType(value: string);
    /**
     * @stability stable
     */
    get valueTypeInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): LoggingMetricMetricDescriptorLabels[] | undefined;
    /**
     * @stability stable
     */
    set labels(value: LoggingMetricMetricDescriptorLabels[] | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): LoggingMetricMetricDescriptorLabels[] | undefined;
}
/**
 * @stability stable
 */
export interface LoggingMetricTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#create LoggingMetric#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#delete LoggingMetric#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#update LoggingMetric#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class LoggingMetricTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html google_logging_metric}.
 *
 * @stability stable
 */
export declare class LoggingMetric extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html google_logging_metric} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LoggingMetricConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labelExtractors?;
    /**
     * @stability stable
     */
    get labelExtractors(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labelExtractors(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabelExtractors(): void;
    /**
     * @stability stable
     */
    get labelExtractorsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _valueExtractor?;
    /**
     * @stability stable
     */
    get valueExtractor(): string | undefined;
    /**
     * @stability stable
     */
    set valueExtractor(value: string | undefined);
    /**
     * @stability stable
     */
    resetValueExtractor(): void;
    /**
     * @stability stable
     */
    get valueExtractorInput(): string | undefined;
    private _bucketOptions?;
    private __bucketOptionsOutput;
    /**
     * @stability stable
     */
    get bucketOptions(): LoggingMetricBucketOptionsOutputReference;
    /**
     * @stability stable
     */
    putBucketOptions(value: LoggingMetricBucketOptions | undefined): void;
    /**
     * @stability stable
     */
    resetBucketOptions(): void;
    /**
     * @stability stable
     */
    get bucketOptionsInput(): LoggingMetricBucketOptions | undefined;
    private _metricDescriptor?;
    private __metricDescriptorOutput;
    /**
     * @stability stable
     */
    get metricDescriptor(): LoggingMetricMetricDescriptorOutputReference;
    /**
     * @stability stable
     */
    putMetricDescriptor(value: LoggingMetricMetricDescriptor): void;
    /**
     * @stability stable
     */
    get metricDescriptorInput(): LoggingMetricMetricDescriptor | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): LoggingMetricTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LoggingMetricTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LoggingMetricTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
