import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Certificate Authority name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#certificate_authority PrivatecaCertificate#certificate_authority}
     *
     * @stability stable
     */
    readonly certificateAuthority?: string;
    /**
     * The resource name for a CertificateTemplate used to issue this certificate, in the format 'projects/*\/locations/*\/certificateTemplates/*'.
     *
     * If this is specified,
     * the caller must have the necessary permission to use this template. If this is
     * omitted, no template will be used. This template must be in the same location
     * as the Certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#certificate_template PrivatecaCertificate#certificate_template}
     *
     * @stability stable
     */
    readonly certificateTemplate?: string;
    /**
     * Labels with user-defined metadata to apply to this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#labels PrivatecaCertificate#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The desired lifetime of the CA certificate.
     *
     * Used to create the "notBeforeTime" and
     * "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
     * fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#lifetime PrivatecaCertificate#lifetime}
     *
     * @stability stable
     */
    readonly lifetime?: string;
    /**
     * Location of the Certificate. A full list of valid locations can be found by running 'gcloud privateca locations list'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#location PrivatecaCertificate#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * The name for this Certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#name PrivatecaCertificate#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Immutable. A pem-encoded X.509 certificate signing request (CSR).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#pem_csr PrivatecaCertificate#pem_csr}
     *
     * @stability stable
     */
    readonly pemCsr?: string;
    /**
     * The name of the CaPool this Certificate belongs to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#pool PrivatecaCertificate#pool}
     *
     * @stability stable
     */
    readonly pool: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#project PrivatecaCertificate#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#config PrivatecaCertificate#config}
     *
     * @stability stable
     */
    readonly config?: PrivatecaCertificateConfigA;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#timeouts PrivatecaCertificate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PrivatecaCertificateTimeouts;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionAuthorityKeyId extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get keyId(): string;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionCertFingerprint extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get sha256Hash(): string;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptions extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get certSign(): any;
    /**
     * @stability stable
     */
    get contentCommitment(): any;
    /**
     * @stability stable
     */
    get crlSign(): any;
    /**
     * @stability stable
     */
    get dataEncipherment(): any;
    /**
     * @stability stable
     */
    get decipherOnly(): any;
    /**
     * @stability stable
     */
    get digitalSignature(): any;
    /**
     * @stability stable
     */
    get encipherOnly(): any;
    /**
     * @stability stable
     */
    get keyAgreement(): any;
    /**
     * @stability stable
     */
    get keyEncipherment(): any;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsage extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get keyUsageOptions(): any;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsage extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clientAuth(): any;
    /**
     * @stability stable
     */
    get codeSigning(): any;
    /**
     * @stability stable
     */
    get emailProtection(): any;
    /**
     * @stability stable
     */
    get ocspSigning(): any;
    /**
     * @stability stable
     */
    get serverAuth(): any;
    /**
     * @stability stable
     */
    get timeStamping(): any;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsagesObectId extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get objectIdPath(): any;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsages extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get obectId(): any;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionConfigValuesKeyUsage extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get baseKeyUsage(): any;
    /**
     * @stability stable
     */
    get extendedKeyUsage(): any;
    /**
     * @stability stable
     */
    get unknownExtendedKeyUsages(): any;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionConfigValues extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get keyUsage(): any;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionPublicKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get format(): string;
    /**
     * @stability stable
     */
    get key(): string;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionSubjectDescriptionSubject extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get commonName(): string;
    /**
     * @stability stable
     */
    get countryCode(): string;
    /**
     * @stability stable
     */
    get locality(): string;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    get organizationalUnit(): string;
    /**
     * @stability stable
     */
    get postalCode(): string;
    /**
     * @stability stable
     */
    get province(): string;
    /**
     * @stability stable
     */
    get streetAddress(): string;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectId extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get objectIdPath(): any;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSans extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get critical(): any;
    /**
     * @stability stable
     */
    get obectId(): any;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltName extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get customSans(): any;
    /**
     * @stability stable
     */
    get dnsNames(): string[];
    /**
     * @stability stable
     */
    get emailAddresses(): string[];
    /**
     * @stability stable
     */
    get ipAddresses(): string[];
    /**
     * @stability stable
     */
    get uris(): string[];
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionSubjectDescription extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get hexSerialNumber(): string;
    /**
     * @stability stable
     */
    get lifetime(): string;
    /**
     * @stability stable
     */
    get notAfterTime(): string;
    /**
     * @stability stable
     */
    get notBeforeTime(): string;
    /**
     * @stability stable
     */
    get subject(): any;
    /**
     * @stability stable
     */
    get subjectAltName(): any;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescriptionSubjectKeyId extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get keyId(): string;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateCertificateDescription extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get aiaIssuingCertificateUrls(): string[];
    /**
     * @stability stable
     */
    get authorityKeyId(): any;
    /**
     * @stability stable
     */
    get certFingerprint(): any;
    /**
     * @stability stable
     */
    get configValues(): any;
    /**
     * @stability stable
     */
    get crlDistributionPoints(): string[];
    /**
     * @stability stable
     */
    get publicKey(): any;
    /**
     * @stability stable
     */
    get subjectDescription(): any;
    /**
     * @stability stable
     */
    get subjectKeyId(): any;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateRevocationDetails extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get revocationState(): string;
    /**
     * @stability stable
     */
    get revocationTime(): string;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfigPublicKey {
    /**
     * The format of the public key. Currently, only PEM format is supported. Possible values: ["KEY_TYPE_UNSPECIFIED", "PEM"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#format PrivatecaCertificate#format}
     *
     * @stability stable
     */
    readonly format: string;
    /**
     * Required.
     *
     * A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 SubjectPublicKeyInfo structure containing an algorithm identifier and a key. A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#key PrivatecaCertificate#key}
     *
     * @stability stable
     */
    readonly key?: string;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateConfigPublicKeyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _format?;
    /**
     * @stability stable
     */
    get format(): string;
    /**
     * @stability stable
     */
    set format(value: string);
    /**
     * @stability stable
     */
    get formatInput(): string | undefined;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string | undefined;
    /**
     * @stability stable
     */
    set key(value: string | undefined);
    /**
     * @stability stable
     */
    resetKey(): void;
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfigSubjectConfigSubject {
    /**
     * The common name of the distinguished name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#common_name PrivatecaCertificate#common_name}
     *
     * @stability stable
     */
    readonly commonName: string;
    /**
     * The country code of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#country_code PrivatecaCertificate#country_code}
     *
     * @stability stable
     */
    readonly countryCode?: string;
    /**
     * The locality or city of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#locality PrivatecaCertificate#locality}
     *
     * @stability stable
     */
    readonly locality?: string;
    /**
     * The organization of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#organization PrivatecaCertificate#organization}
     *
     * @stability stable
     */
    readonly organization: string;
    /**
     * The organizational unit of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#organizational_unit PrivatecaCertificate#organizational_unit}
     *
     * @stability stable
     */
    readonly organizationalUnit?: string;
    /**
     * The postal code of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#postal_code PrivatecaCertificate#postal_code}
     *
     * @stability stable
     */
    readonly postalCode?: string;
    /**
     * The province, territory, or regional state of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#province PrivatecaCertificate#province}
     *
     * @stability stable
     */
    readonly province?: string;
    /**
     * The street address of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#street_address PrivatecaCertificate#street_address}
     *
     * @stability stable
     */
    readonly streetAddress?: string;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateConfigSubjectConfigSubjectOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _commonName?;
    /**
     * @stability stable
     */
    get commonName(): string;
    /**
     * @stability stable
     */
    set commonName(value: string);
    /**
     * @stability stable
     */
    get commonNameInput(): string | undefined;
    private _countryCode?;
    /**
     * @stability stable
     */
    get countryCode(): string | undefined;
    /**
     * @stability stable
     */
    set countryCode(value: string | undefined);
    /**
     * @stability stable
     */
    resetCountryCode(): void;
    /**
     * @stability stable
     */
    get countryCodeInput(): string | undefined;
    private _locality?;
    /**
     * @stability stable
     */
    get locality(): string | undefined;
    /**
     * @stability stable
     */
    set locality(value: string | undefined);
    /**
     * @stability stable
     */
    resetLocality(): void;
    /**
     * @stability stable
     */
    get localityInput(): string | undefined;
    private _organization?;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    set organization(value: string);
    /**
     * @stability stable
     */
    get organizationInput(): string | undefined;
    private _organizationalUnit?;
    /**
     * @stability stable
     */
    get organizationalUnit(): string | undefined;
    /**
     * @stability stable
     */
    set organizationalUnit(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrganizationalUnit(): void;
    /**
     * @stability stable
     */
    get organizationalUnitInput(): string | undefined;
    private _postalCode?;
    /**
     * @stability stable
     */
    get postalCode(): string | undefined;
    /**
     * @stability stable
     */
    set postalCode(value: string | undefined);
    /**
     * @stability stable
     */
    resetPostalCode(): void;
    /**
     * @stability stable
     */
    get postalCodeInput(): string | undefined;
    private _province?;
    /**
     * @stability stable
     */
    get province(): string | undefined;
    /**
     * @stability stable
     */
    set province(value: string | undefined);
    /**
     * @stability stable
     */
    resetProvince(): void;
    /**
     * @stability stable
     */
    get provinceInput(): string | undefined;
    private _streetAddress?;
    /**
     * @stability stable
     */
    get streetAddress(): string | undefined;
    /**
     * @stability stable
     */
    set streetAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetStreetAddress(): void;
    /**
     * @stability stable
     */
    get streetAddressInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfigSubjectConfigSubjectAltName {
    /**
     * Contains only valid, fully-qualified host names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#dns_names PrivatecaCertificate#dns_names}
     *
     * @stability stable
     */
    readonly dnsNames?: string[];
    /**
     * Contains only valid RFC 2822 E-mail addresses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#email_addresses PrivatecaCertificate#email_addresses}
     *
     * @stability stable
     */
    readonly emailAddresses?: string[];
    /**
     * Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#ip_addresses PrivatecaCertificate#ip_addresses}
     *
     * @stability stable
     */
    readonly ipAddresses?: string[];
    /**
     * Contains only valid RFC 3986 URIs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#uris PrivatecaCertificate#uris}
     *
     * @stability stable
     */
    readonly uris?: string[];
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateConfigSubjectConfigSubjectAltNameOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dnsNames?;
    /**
     * @stability stable
     */
    get dnsNames(): string[] | undefined;
    /**
     * @stability stable
     */
    set dnsNames(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetDnsNames(): void;
    /**
     * @stability stable
     */
    get dnsNamesInput(): string[] | undefined;
    private _emailAddresses?;
    /**
     * @stability stable
     */
    get emailAddresses(): string[] | undefined;
    /**
     * @stability stable
     */
    set emailAddresses(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetEmailAddresses(): void;
    /**
     * @stability stable
     */
    get emailAddressesInput(): string[] | undefined;
    private _ipAddresses?;
    /**
     * @stability stable
     */
    get ipAddresses(): string[] | undefined;
    /**
     * @stability stable
     */
    set ipAddresses(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetIpAddresses(): void;
    /**
     * @stability stable
     */
    get ipAddressesInput(): string[] | undefined;
    private _uris?;
    /**
     * @stability stable
     */
    get uris(): string[] | undefined;
    /**
     * @stability stable
     */
    set uris(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetUris(): void;
    /**
     * @stability stable
     */
    get urisInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfigSubjectConfig {
    /**
     * subject block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#subject PrivatecaCertificate#subject}
     *
     * @stability stable
     */
    readonly subject: PrivatecaCertificateConfigSubjectConfigSubject;
    /**
     * subject_alt_name block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#subject_alt_name PrivatecaCertificate#subject_alt_name}
     *
     * @stability stable
     */
    readonly subjectAltName?: PrivatecaCertificateConfigSubjectConfigSubjectAltName;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateConfigSubjectConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _subject?;
    private __subjectOutput;
    /**
     * @stability stable
     */
    get subject(): PrivatecaCertificateConfigSubjectConfigSubjectOutputReference;
    /**
     * @stability stable
     */
    putSubject(value: PrivatecaCertificateConfigSubjectConfigSubject): void;
    /**
     * @stability stable
     */
    get subjectInput(): PrivatecaCertificateConfigSubjectConfigSubject | undefined;
    private _subjectAltName?;
    private __subjectAltNameOutput;
    /**
     * @stability stable
     */
    get subjectAltName(): PrivatecaCertificateConfigSubjectConfigSubjectAltNameOutputReference;
    /**
     * @stability stable
     */
    putSubjectAltName(value: PrivatecaCertificateConfigSubjectConfigSubjectAltName | undefined): void;
    /**
     * @stability stable
     */
    resetSubjectAltName(): void;
    /**
     * @stability stable
     */
    get subjectAltNameInput(): PrivatecaCertificateConfigSubjectConfigSubjectAltName | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectId {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#object_id_path PrivatecaCertificate#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _objectIdPath?;
    /**
     * @stability stable
     */
    get objectIdPath(): number[];
    /**
     * @stability stable
     */
    set objectIdPath(value: number[]);
    /**
     * @stability stable
     */
    get objectIdPathInput(): number[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfigX509ConfigAdditionalExtensions {
    /**
     * Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#critical PrivatecaCertificate#critical}
     *
     * @stability stable
     */
    readonly critical: boolean | cdktf.IResolvable;
    /**
     * The value of this X.509 extension. A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#value PrivatecaCertificate#value}
     *
     * @stability stable
     */
    readonly value: string;
    /**
     * object_id block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#object_id PrivatecaCertificate#object_id}
     *
     * @stability stable
     */
    readonly objectId: PrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectId;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfigX509ConfigCaOptions {
    /**
     * Refers to the "CA" X.509 extension, which is a boolean value. When this value is missing, the extension will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#is_ca PrivatecaCertificate#is_ca}
     *
     * @stability stable
     */
    readonly isCa?: boolean | cdktf.IResolvable;
    /**
     * Refers to the path length restriction X.509 extension. For a CA certificate, this value describes the depth of subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. If this value is missing, the max path length will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#max_issuer_path_length PrivatecaCertificate#max_issuer_path_length}
     *
     * @stability stable
     */
    readonly maxIssuerPathLength?: number;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateConfigX509ConfigCaOptionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isCa?;
    /**
     * @stability stable
     */
    get isCa(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isCa(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsCa(): void;
    /**
     * @stability stable
     */
    get isCaInput(): boolean | cdktf.IResolvable | undefined;
    private _maxIssuerPathLength?;
    /**
     * @stability stable
     */
    get maxIssuerPathLength(): number | undefined;
    /**
     * @stability stable
     */
    set maxIssuerPathLength(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxIssuerPathLength(): void;
    /**
     * @stability stable
     */
    get maxIssuerPathLengthInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage {
    /**
     * The key may be used to sign certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#cert_sign PrivatecaCertificate#cert_sign}
     *
     * @stability stable
     */
    readonly certSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#content_commitment PrivatecaCertificate#content_commitment}
     *
     * @stability stable
     */
    readonly contentCommitment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used sign certificate revocation lists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#crl_sign PrivatecaCertificate#crl_sign}
     *
     * @stability stable
     */
    readonly crlSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#data_encipherment PrivatecaCertificate#data_encipherment}
     *
     * @stability stable
     */
    readonly dataEncipherment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to decipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#decipher_only PrivatecaCertificate#decipher_only}
     *
     * @stability stable
     */
    readonly decipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for digital signatures.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#digital_signature PrivatecaCertificate#digital_signature}
     *
     * @stability stable
     */
    readonly digitalSignature?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#encipher_only PrivatecaCertificate#encipher_only}
     *
     * @stability stable
     */
    readonly encipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used in a key agreement protocol.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#key_agreement PrivatecaCertificate#key_agreement}
     *
     * @stability stable
     */
    readonly keyAgreement?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher other keys.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#key_encipherment PrivatecaCertificate#key_encipherment}
     *
     * @stability stable
     */
    readonly keyEncipherment?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _certSign?;
    /**
     * @stability stable
     */
    get certSign(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set certSign(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCertSign(): void;
    /**
     * @stability stable
     */
    get certSignInput(): boolean | cdktf.IResolvable | undefined;
    private _contentCommitment?;
    /**
     * @stability stable
     */
    get contentCommitment(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set contentCommitment(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetContentCommitment(): void;
    /**
     * @stability stable
     */
    get contentCommitmentInput(): boolean | cdktf.IResolvable | undefined;
    private _crlSign?;
    /**
     * @stability stable
     */
    get crlSign(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set crlSign(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCrlSign(): void;
    /**
     * @stability stable
     */
    get crlSignInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEncipherment?;
    /**
     * @stability stable
     */
    get dataEncipherment(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set dataEncipherment(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDataEncipherment(): void;
    /**
     * @stability stable
     */
    get dataEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
    private _decipherOnly?;
    /**
     * @stability stable
     */
    get decipherOnly(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set decipherOnly(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDecipherOnly(): void;
    /**
     * @stability stable
     */
    get decipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _digitalSignature?;
    /**
     * @stability stable
     */
    get digitalSignature(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set digitalSignature(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDigitalSignature(): void;
    /**
     * @stability stable
     */
    get digitalSignatureInput(): boolean | cdktf.IResolvable | undefined;
    private _encipherOnly?;
    /**
     * @stability stable
     */
    get encipherOnly(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set encipherOnly(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEncipherOnly(): void;
    /**
     * @stability stable
     */
    get encipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAgreement?;
    /**
     * @stability stable
     */
    get keyAgreement(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set keyAgreement(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetKeyAgreement(): void;
    /**
     * @stability stable
     */
    get keyAgreementInput(): boolean | cdktf.IResolvable | undefined;
    private _keyEncipherment?;
    /**
     * @stability stable
     */
    get keyEncipherment(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set keyEncipherment(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetKeyEncipherment(): void;
    /**
     * @stability stable
     */
    get keyEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage {
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#client_auth PrivatecaCertificate#client_auth}
     *
     * @stability stable
     */
    readonly clientAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#code_signing PrivatecaCertificate#code_signing}
     *
     * @stability stable
     */
    readonly codeSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#email_protection PrivatecaCertificate#email_protection}
     *
     * @stability stable
     */
    readonly emailProtection?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#ocsp_signing PrivatecaCertificate#ocsp_signing}
     *
     * @stability stable
     */
    readonly ocspSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#server_auth PrivatecaCertificate#server_auth}
     *
     * @stability stable
     */
    readonly serverAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#time_stamping PrivatecaCertificate#time_stamping}
     *
     * @stability stable
     */
    readonly timeStamping?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _clientAuth?;
    /**
     * @stability stable
     */
    get clientAuth(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set clientAuth(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetClientAuth(): void;
    /**
     * @stability stable
     */
    get clientAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigning?;
    /**
     * @stability stable
     */
    get codeSigning(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set codeSigning(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCodeSigning(): void;
    /**
     * @stability stable
     */
    get codeSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _emailProtection?;
    /**
     * @stability stable
     */
    get emailProtection(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set emailProtection(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEmailProtection(): void;
    /**
     * @stability stable
     */
    get emailProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspSigning?;
    /**
     * @stability stable
     */
    get ocspSigning(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set ocspSigning(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetOcspSigning(): void;
    /**
     * @stability stable
     */
    get ocspSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAuth?;
    /**
     * @stability stable
     */
    get serverAuth(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set serverAuth(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetServerAuth(): void;
    /**
     * @stability stable
     */
    get serverAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _timeStamping?;
    /**
     * @stability stable
     */
    get timeStamping(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set timeStamping(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTimeStamping(): void;
    /**
     * @stability stable
     */
    get timeStampingInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#object_id_path PrivatecaCertificate#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfigX509ConfigKeyUsage {
    /**
     * base_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#base_key_usage PrivatecaCertificate#base_key_usage}
     *
     * @stability stable
     */
    readonly baseKeyUsage: PrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage;
    /**
     * extended_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#extended_key_usage PrivatecaCertificate#extended_key_usage}
     *
     * @stability stable
     */
    readonly extendedKeyUsage: PrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage;
    /**
     * unknown_extended_key_usages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#unknown_extended_key_usages PrivatecaCertificate#unknown_extended_key_usages}
     *
     * @stability stable
     */
    readonly unknownExtendedKeyUsages?: PrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[];
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateConfigX509ConfigKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _baseKeyUsage?;
    private __baseKeyUsageOutput;
    /**
     * @stability stable
     */
    get baseKeyUsage(): PrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putBaseKeyUsage(value: PrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage): void;
    /**
     * @stability stable
     */
    get baseKeyUsageInput(): PrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage | undefined;
    private _extendedKeyUsage?;
    private __extendedKeyUsageOutput;
    /**
     * @stability stable
     */
    get extendedKeyUsage(): PrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putExtendedKeyUsage(value: PrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage): void;
    /**
     * @stability stable
     */
    get extendedKeyUsageInput(): PrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage | undefined;
    private _unknownExtendedKeyUsages?;
    /**
     * @stability stable
     */
    get unknownExtendedKeyUsages(): PrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | undefined;
    /**
     * @stability stable
     */
    set unknownExtendedKeyUsages(value: PrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | undefined);
    /**
     * @stability stable
     */
    resetUnknownExtendedKeyUsages(): void;
    /**
     * @stability stable
     */
    get unknownExtendedKeyUsagesInput(): PrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfigX509ConfigPolicyIds {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#object_id_path PrivatecaCertificate#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfigX509Config {
    /**
     * Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#aia_ocsp_servers PrivatecaCertificate#aia_ocsp_servers}
     *
     * @stability stable
     */
    readonly aiaOcspServers?: string[];
    /**
     * additional_extensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#additional_extensions PrivatecaCertificate#additional_extensions}
     *
     * @stability stable
     */
    readonly additionalExtensions?: PrivatecaCertificateConfigX509ConfigAdditionalExtensions[];
    /**
     * ca_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#ca_options PrivatecaCertificate#ca_options}
     *
     * @stability stable
     */
    readonly caOptions?: PrivatecaCertificateConfigX509ConfigCaOptions;
    /**
     * key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#key_usage PrivatecaCertificate#key_usage}
     *
     * @stability stable
     */
    readonly keyUsage: PrivatecaCertificateConfigX509ConfigKeyUsage;
    /**
     * policy_ids block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#policy_ids PrivatecaCertificate#policy_ids}
     *
     * @stability stable
     */
    readonly policyIds?: PrivatecaCertificateConfigX509ConfigPolicyIds[];
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateConfigX509ConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aiaOcspServers?;
    /**
     * @stability stable
     */
    get aiaOcspServers(): string[] | undefined;
    /**
     * @stability stable
     */
    set aiaOcspServers(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetAiaOcspServers(): void;
    /**
     * @stability stable
     */
    get aiaOcspServersInput(): string[] | undefined;
    private _additionalExtensions?;
    /**
     * @stability stable
     */
    get additionalExtensions(): PrivatecaCertificateConfigX509ConfigAdditionalExtensions[] | undefined;
    /**
     * @stability stable
     */
    set additionalExtensions(value: PrivatecaCertificateConfigX509ConfigAdditionalExtensions[] | undefined);
    /**
     * @stability stable
     */
    resetAdditionalExtensions(): void;
    /**
     * @stability stable
     */
    get additionalExtensionsInput(): PrivatecaCertificateConfigX509ConfigAdditionalExtensions[] | undefined;
    private _caOptions?;
    private __caOptionsOutput;
    /**
     * @stability stable
     */
    get caOptions(): PrivatecaCertificateConfigX509ConfigCaOptionsOutputReference;
    /**
     * @stability stable
     */
    putCaOptions(value: PrivatecaCertificateConfigX509ConfigCaOptions | undefined): void;
    /**
     * @stability stable
     */
    resetCaOptions(): void;
    /**
     * @stability stable
     */
    get caOptionsInput(): PrivatecaCertificateConfigX509ConfigCaOptions | undefined;
    private _keyUsage?;
    private __keyUsageOutput;
    /**
     * @stability stable
     */
    get keyUsage(): PrivatecaCertificateConfigX509ConfigKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putKeyUsage(value: PrivatecaCertificateConfigX509ConfigKeyUsage): void;
    /**
     * @stability stable
     */
    get keyUsageInput(): PrivatecaCertificateConfigX509ConfigKeyUsage | undefined;
    private _policyIds?;
    /**
     * @stability stable
     */
    get policyIds(): PrivatecaCertificateConfigX509ConfigPolicyIds[] | undefined;
    /**
     * @stability stable
     */
    set policyIds(value: PrivatecaCertificateConfigX509ConfigPolicyIds[] | undefined);
    /**
     * @stability stable
     */
    resetPolicyIds(): void;
    /**
     * @stability stable
     */
    get policyIdsInput(): PrivatecaCertificateConfigX509ConfigPolicyIds[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateConfigA {
    /**
     * public_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#public_key PrivatecaCertificate#public_key}
     *
     * @stability stable
     */
    readonly publicKey: PrivatecaCertificateConfigPublicKey;
    /**
     * subject_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#subject_config PrivatecaCertificate#subject_config}
     *
     * @stability stable
     */
    readonly subjectConfig: PrivatecaCertificateConfigSubjectConfig;
    /**
     * x509_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#x509_config PrivatecaCertificate#x509_config}
     *
     * @stability stable
     */
    readonly x509Config: PrivatecaCertificateConfigX509Config;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateConfigAOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _publicKey?;
    private __publicKeyOutput;
    /**
     * @stability stable
     */
    get publicKey(): PrivatecaCertificateConfigPublicKeyOutputReference;
    /**
     * @stability stable
     */
    putPublicKey(value: PrivatecaCertificateConfigPublicKey): void;
    /**
     * @stability stable
     */
    get publicKeyInput(): PrivatecaCertificateConfigPublicKey | undefined;
    private _subjectConfig?;
    private __subjectConfigOutput;
    /**
     * @stability stable
     */
    get subjectConfig(): PrivatecaCertificateConfigSubjectConfigOutputReference;
    /**
     * @stability stable
     */
    putSubjectConfig(value: PrivatecaCertificateConfigSubjectConfig): void;
    /**
     * @stability stable
     */
    get subjectConfigInput(): PrivatecaCertificateConfigSubjectConfig | undefined;
    private _x509Config?;
    private __x509ConfigOutput;
    /**
     * @stability stable
     */
    get x509Config(): PrivatecaCertificateConfigX509ConfigOutputReference;
    /**
     * @stability stable
     */
    putX509Config(value: PrivatecaCertificateConfigX509Config): void;
    /**
     * @stability stable
     */
    get x509ConfigInput(): PrivatecaCertificateConfigX509Config | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCertificateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#create PrivatecaCertificate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#delete PrivatecaCertificate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class PrivatecaCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html google_privateca_certificate}.
 *
 * @stability stable
 */
export declare class PrivatecaCertificate extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html google_privateca_certificate} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PrivatecaCertificateConfig);
    private _certificateAuthority?;
    /**
     * @stability stable
     */
    get certificateAuthority(): string | undefined;
    /**
     * @stability stable
     */
    set certificateAuthority(value: string | undefined);
    /**
     * @stability stable
     */
    resetCertificateAuthority(): void;
    /**
     * @stability stable
     */
    get certificateAuthorityInput(): string | undefined;
    /**
     * @stability stable
     */
    certificateDescription(index: string): PrivatecaCertificateCertificateDescription;
    private _certificateTemplate?;
    /**
     * @stability stable
     */
    get certificateTemplate(): string | undefined;
    /**
     * @stability stable
     */
    set certificateTemplate(value: string | undefined);
    /**
     * @stability stable
     */
    resetCertificateTemplate(): void;
    /**
     * @stability stable
     */
    get certificateTemplateInput(): string | undefined;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _lifetime?;
    /**
     * @stability stable
     */
    get lifetime(): string | undefined;
    /**
     * @stability stable
     */
    set lifetime(value: string | undefined);
    /**
     * @stability stable
     */
    resetLifetime(): void;
    /**
     * @stability stable
     */
    get lifetimeInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get pemCertificate(): string;
    /**
     * @stability stable
     */
    get pemCertificates(): string[];
    private _pemCsr?;
    /**
     * @stability stable
     */
    get pemCsr(): string | undefined;
    /**
     * @stability stable
     */
    set pemCsr(value: string | undefined);
    /**
     * @stability stable
     */
    resetPemCsr(): void;
    /**
     * @stability stable
     */
    get pemCsrInput(): string | undefined;
    private _pool?;
    /**
     * @stability stable
     */
    get pool(): string;
    /**
     * @stability stable
     */
    set pool(value: string);
    /**
     * @stability stable
     */
    get poolInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    revocationDetails(index: string): PrivatecaCertificateRevocationDetails;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _config?;
    private __configOutput;
    /**
     * @stability stable
     */
    get config(): PrivatecaCertificateConfigAOutputReference;
    /**
     * @stability stable
     */
    putConfig(value: PrivatecaCertificateConfigA | undefined): void;
    /**
     * @stability stable
     */
    resetConfig(): void;
    /**
     * @stability stable
     */
    get configInput(): PrivatecaCertificateConfigA | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): PrivatecaCertificateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PrivatecaCertificateTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PrivatecaCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
