from django.contrib.gis.geometry import (  # noqa: F401
    hex_regex as hex_regex,
    json_regex as json_regex,
    wkt_regex as wkt_regex,
)
from django.contrib.gis.geos.base import GEOSBase as GEOSBase
from django.contrib.gis.geos.mutable_list import ListMixin as ListMixin
from typing import Any, Optional

class GEOSGeometryBase(GEOSBase):
    ptr_type: Any = ...
    destructor: Any = ...
    has_cs: bool = ...
    __class__: Any = ...
    def __init__(self, ptr: Any, cls: Any) -> None: ...
    def __copy__(self): ...
    def __deepcopy__(self, memodict: Any): ...
    @staticmethod
    def from_ewkt(ewkt: Any): ...
    @classmethod
    def from_gml(cls, gml_string: Any): ...
    def __eq__(self, other: Any) -> Any: ...
    def __hash__(self) -> Any: ...
    def __or__(self, other: Any): ...
    def __and__(self, other: Any): ...
    def __sub__(self, other: Any): ...
    def __xor__(self, other: Any): ...
    @property
    def coord_seq(self): ...
    @property
    def geom_type(self): ...
    @property
    def geom_typeid(self): ...
    @property
    def num_geom(self): ...
    @property
    def num_coords(self): ...
    @property
    def num_points(self): ...
    @property
    def dims(self): ...
    def normalize(self) -> None: ...
    @property
    def empty(self): ...
    @property
    def hasz(self): ...
    @property
    def ring(self): ...
    @property
    def simple(self): ...
    @property
    def valid(self): ...
    @property
    def valid_reason(self): ...
    def contains(self, other: Any): ...
    def covers(self, other: Any): ...
    def crosses(self, other: Any): ...
    def disjoint(self, other: Any): ...
    def equals(self, other: Any): ...
    def equals_exact(self, other: Any, tolerance: int = ...): ...
    def intersects(self, other: Any): ...
    def overlaps(self, other: Any): ...
    def relate_pattern(self, other: Any, pattern: Any): ...
    def touches(self, other: Any): ...
    def within(self, other: Any): ...
    @property
    def srid(self): ...
    @srid.setter
    def srid(self, srid: Any) -> None: ...
    @property
    def ewkt(self): ...
    @property
    def wkt(self): ...
    @property
    def hex(self): ...
    @property
    def hexewkb(self): ...
    @property
    def json(self): ...
    geojson: Any = ...
    @property
    def wkb(self): ...
    @property
    def ewkb(self): ...
    @property
    def kml(self): ...
    @property
    def prepared(self): ...
    @property
    def ogr(self): ...
    @property
    def srs(self): ...
    @property
    def crs(self): ...
    ptr: Any = ...
    def transform(self, ct: Any, clone: bool = ...): ...
    @property
    def boundary(self): ...
    def buffer(self, width: Any, quadsegs: int = ...): ...
    def buffer_with_style(
        self, width: Any, quadsegs: int = ..., end_cap_style: int = ..., join_style: int = ..., mitre_limit: float = ...
    ): ...
    @property
    def centroid(self): ...
    @property
    def convex_hull(self): ...
    def difference(self, other: Any): ...
    @property
    def envelope(self): ...
    def intersection(self, other: Any): ...
    @property
    def point_on_surface(self): ...
    def relate(self, other: Any): ...
    def simplify(self, tolerance: float = ..., preserve_topology: bool = ...): ...
    def sym_difference(self, other: Any): ...
    @property
    def unary_union(self): ...
    def union(self, other: Any): ...
    @property
    def area(self): ...
    def distance(self, other: Any): ...
    @property
    def extent(self): ...
    @property
    def length(self): ...
    def clone(self): ...

class LinearGeometryMixin:
    def interpolate(self, distance: Any): ...
    def interpolate_normalized(self, distance: Any): ...
    def project(self, point: Any): ...
    def project_normalized(self, point: Any): ...
    @property
    def merged(self): ...
    @property
    def closed(self): ...

class GEOSGeometry(GEOSGeometryBase, ListMixin):
    srid: Any = ...
    def __init__(self, geo_input: Any, srid: Optional[Any] = ...) -> None: ...
