from typing import Any, List, Optional, Tuple, overload, Callable, Dict, Union

from .resolvers import URLResolver, URLPattern
from ..conf.urls import IncludedURLConf
from ..http.response import HttpResponseBase

def include(arg: Any, namespace: Optional[str] = ...) -> Tuple[List[Union[URLResolver, URLPattern]], Optional[str], Optional[str]]: ...

# path()
@overload
def path(
    route: str, view: Callable[..., HttpResponseBase], kwargs: Dict[str, Any] = ..., name: str = ...
) -> URLPattern: ...
@overload
def path(route: str, view: IncludedURLConf, kwargs: Dict[str, Any] = ..., name: str = ...) -> URLResolver: ...
@overload
def path(
    route: str, view: List[Union[URLResolver, str]], kwargs: Dict[str, Any] = ..., name: str = ...
) -> URLResolver: ...

# re_path()
@overload
def re_path(
    route: str, view: Callable[..., HttpResponseBase], kwargs: Dict[str, Any] = ..., name: str = ...
) -> URLPattern: ...
@overload
def re_path(route: str, view: IncludedURLConf, kwargs: Dict[str, Any] = ..., name: str = ...) -> URLResolver: ...
@overload
def re_path(
    route: str, view: List[Union[URLResolver, str]], kwargs: Dict[str, Any] = ..., name: str = ...
) -> URLResolver: ...
