import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
/**
 * (experimental) Statement provider for service [a4b](https://docs.aws.amazon.com/service-authorization/latest/reference/list_alexaforbusiness.html).
 *
 * @experimental
 */
export declare class A4b extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [a4b](https://docs.aws.amazon.com/service-authorization/latest/reference/list_alexaforbusiness.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to associate a skill with the organization under the customer's AWSaccount.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ApproveSkill.html
     *
     * @experimental
     */
    toApproveSkill(): this;
    /**
     * (experimental) Grants permission to associate a contact with a given address book.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_AssociateContactWithAddressBook.html
     *
     * @experimental
     */
    toAssociateContactWithAddressBook(): this;
    /**
     * (experimental) Grants permission to associate a device with the specified network profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_AssociateDeviceWithNetworkProfile.html
     *
     * @experimental
     */
    toAssociateDeviceWithNetworkProfile(): this;
    /**
     * (experimental) Grants permission to associate device with given room.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_AssociateDeviceWithRoom.html
     *
     * @experimental
     */
    toAssociateDeviceWithRoom(): this;
    /**
     * (experimental) Grants permission to associate the skill group with given room.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_AssociateSkillGroupWithRoom.html
     *
     * @experimental
     */
    toAssociateSkillGroupWithRoom(): this;
    /**
     * (experimental) Grants permission to associate a skill with a skill group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_AssociateSkillWithSkillGroup.html
     *
     * @experimental
     */
    toAssociateSkillWithSkillGroup(): this;
    /**
     * (experimental) Grants permission to make a private skill available for enrolled users to enable on their devices.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_AssociateSkillWithUsers.html
     *
     * @experimental
     */
    toAssociateSkillWithUsers(): this;
    /**
     * (experimental) Grants permission to complete the operation of registering an Alexa device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/ag/manage-devices.html
     *
     * @experimental
     */
    toCompleteRegistration(): this;
    /**
     * (experimental) Grants permission to create an address book with the specified details.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateAddressBook.html
     *
     * @experimental
     */
    toCreateAddressBook(): this;
    /**
     * (experimental) Grants permission to create a recurring schedule for usage reports to deliver to the specified S3 location with a specified daily or weekly interval.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateBusinessReportSchedule.html
     *
     * @experimental
     */
    toCreateBusinessReportSchedule(): this;
    /**
     * (experimental) Grants permission to add a new conference provider under the user's AWSaccount.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateConferenceProvider.html
     *
     * @experimental
     */
    toCreateConferenceProvider(): this;
    /**
     * (experimental) Grants permission to create a contact with the specified details.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateContact.html
     *
     * @experimental
     */
    toCreateContact(): this;
    /**
     * (experimental) Grants permission to create a gateway group with the specified details.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateGatewayGroup.html
     *
     * @experimental
     */
    toCreateGatewayGroup(): this;
    /**
     * (experimental) Grants permission to create a network profile with the specified details.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateNetworkProfile.html
     *
     * @experimental
     */
    toCreateNetworkProfile(): this;
    /**
     * (experimental) Grants permission to create a new profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateProfile.html
     *
     * @experimental
     */
    toCreateProfile(): this;
    /**
     * (experimental) Grants permission to create room with the specified details.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateRoom.html
     *
     * @experimental
     */
    toCreateRoom(): this;
    /**
     * (experimental) Grants permission to create a skill group with given name and description.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateSkillGroup.html
     *
     * @experimental
     */
    toCreateSkillGroup(): this;
    /**
     * (experimental) Grants permission to create a user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_CreateUser.html
     *
     * @experimental
     */
    toCreateUser(): this;
    /**
     * (experimental) Grants permission to delete an address book by the address book ARN.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteAddressBook.html
     *
     * @experimental
     */
    toDeleteAddressBook(): this;
    /**
     * (experimental) Grants permission to delete the recurring report delivery schedule with the specified schedule ARN.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteBusinessReportSchedule.html
     *
     * @experimental
     */
    toDeleteBusinessReportSchedule(): this;
    /**
     * (experimental) Grants permission to delete a conference provider.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteConferenceProvider.html
     *
     * @experimental
     */
    toDeleteConferenceProvider(): this;
    /**
     * (experimental) Grants permission to delete a contact by the contact ARN.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteContact.html
     *
     * @experimental
     */
    toDeleteContact(): this;
    /**
     * (experimental) Grants permission to remove a device from Alexa For Business.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteDevice.html
     *
     * @experimental
     */
    toDeleteDevice(): this;
    /**
     * (experimental) Grants permission to delete the device's entire previous history of voice input data and associated response data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteDeviceUsageData.html
     *
     * @experimental
     */
    toDeleteDeviceUsageData(): this;
    /**
     * (experimental) Grants permission to delete a gateway group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteGatewayGroup.html
     *
     * @experimental
     */
    toDeleteGatewayGroup(): this;
    /**
     * (experimental) Grants permission to delete a network profile by the network profile ARN.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteNetworkProfile.html
     *
     * @experimental
     */
    toDeleteNetworkProfile(): this;
    /**
     * (experimental) Grants permission to delete profile by profile ARN.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteProfile.html
     *
     * @experimental
     */
    toDeleteProfile(): this;
    /**
     * (experimental) Grants permission to delete room.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteRoom.html
     *
     * @experimental
     */
    toDeleteRoom(): this;
    /**
     * (experimental) Grants permission to delete a parameter from a skill and room.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteRoomSkillParameter.html
     *
     * @experimental
     */
    toDeleteRoomSkillParameter(): this;
    /**
     * (experimental) Grants permission to unlink a third-party account from a skill.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteSkillAuthorization.html
     *
     * @experimental
     */
    toDeleteSkillAuthorization(): this;
    /**
     * (experimental) Grants permission to delete skill group with skill group ARN.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteSkillGroup.html
     *
     * @experimental
     */
    toDeleteSkillGroup(): this;
    /**
     * (experimental) Grants permission to delete a user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DeleteUser.html
     *
     * @experimental
     */
    toDeleteUser(): this;
    /**
     * (experimental) Grants permission to disassociate a contact from a given address book.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DisassociateContactFromAddressBook.html
     *
     * @experimental
     */
    toDisassociateContactFromAddressBook(): this;
    /**
     * (experimental) Grants permission to disassociate device from its current room.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DisassociateDeviceFromRoom.html
     *
     * @experimental
     */
    toDisassociateDeviceFromRoom(): this;
    /**
     * (experimental) Grants permission to disassociate a skill from a skill group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DisassociateSkillFromSkillGroup.html
     *
     * @experimental
     */
    toDisassociateSkillFromSkillGroup(): this;
    /**
     * (experimental) Grants permission to make a private skill unavailable for enrolled users and prevent them from enabling it on their devices.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DisassociateSkillFromUsers.html
     *
     * @experimental
     */
    toDisassociateSkillFromUsers(): this;
    /**
     * (experimental) Grants permission to disassociate the skill group from given room.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_DisassociateSkillGroupFromRoom.html
     *
     * @experimental
     */
    toDisassociateSkillGroupFromRoom(): this;
    /**
     * (experimental) Grants permission to forget smart home appliances associated to a room.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ForgetSmartHomeAppliances.html
     *
     * @experimental
     */
    toForgetSmartHomeAppliances(): this;
    /**
     * (experimental) Grants permission to get the address book details by the address book ARN.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetAddressBook.html
     *
     * @experimental
     */
    toGetAddressBook(): this;
    /**
     * (experimental) Grants permission to retrieve the existing conference preferences.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetConferencePreference.html
     *
     * @experimental
     */
    toGetConferencePreference(): this;
    /**
     * (experimental) Grants permission to get details about a specific conference provider.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetConferenceProvider.html
     *
     * @experimental
     */
    toGetConferenceProvider(): this;
    /**
     * (experimental) Grants permission to get the contact details by the contact ARN.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetContact.html
     *
     * @experimental
     */
    toGetContact(): this;
    /**
     * (experimental) Grants permission to get device details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetDevice.html
     *
     * @experimental
     */
    toGetDevice(): this;
    /**
     * (experimental) Grants permission to retrieve the details of a gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetGateway.html
     *
     * @experimental
     */
    toGetGateway(): this;
    /**
     * (experimental) Grants permission to retrieve the details of a gateway group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetGatewayGroup.html
     *
     * @experimental
     */
    toGetGatewayGroup(): this;
    /**
     * (experimental) Grants permission to retrieve the configured values for the user enrollment invitation email template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetInvitationConfiguration.html
     *
     * @experimental
     */
    toGetInvitationConfiguration(): this;
    /**
     * (experimental) Grants permission to get the network profile details by the network profile ARN.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetNetworkProfile.html
     *
     * @experimental
     */
    toGetNetworkProfile(): this;
    /**
     * (experimental) Grants permission to get profile when provided with Profile ARN.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetProfile.html
     *
     * @experimental
     */
    toGetProfile(): this;
    /**
     * (experimental) Grants permission to get room details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetRoom.html
     *
     * @experimental
     */
    toGetRoom(): this;
    /**
     * (experimental) Grants permission to get an existing parameter that has been set for a skill and room.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetRoomSkillParameter.html
     *
     * @experimental
     */
    toGetRoomSkillParameter(): this;
    /**
     * (experimental) Grants permission to get skill group details with skill group ARN.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GetSkillGroup.html
     *
     * @experimental
     */
    toGetSkillGroup(): this;
    /**
     * (experimental) Grants permission to list the details of the schedules that a user configured.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListBusinessReportSchedules.html
     *
     * @experimental
     */
    toListBusinessReportSchedules(): this;
    /**
     * (experimental) Grants permission to list conference providers under a specific AWSaccount.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListConferenceProviders.html
     *
     * @experimental
     */
    toListConferenceProviders(): this;
    /**
     * (experimental) Grants permission to list the device event history, including device connection status, for up to 30 days.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListDeviceEvents.html
     *
     * @experimental
     */
    toListDeviceEvents(): this;
    /**
     * (experimental) Grants permission to list gateway group summaries.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListGatewayGroups.html
     *
     * @experimental
     */
    toListGatewayGroups(): this;
    /**
     * (experimental) Grants permission to list gateway summaries.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListGateways.html
     *
     * @experimental
     */
    toListGateways(): this;
    /**
     * (experimental) Grants permission to list skills.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListSkills.html
     *
     * @experimental
     */
    toListSkills(): this;
    /**
     * (experimental) Grants permission to list all categories in the Alexa skill store.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListSkillsStoreCategories.html
     *
     * @experimental
     */
    toListSkillsStoreCategories(): this;
    /**
     * (experimental) Grants permission to list all skills in the Alexa skill store by category.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListSkillsStoreSkillsByCategory.html
     *
     * @experimental
     */
    toListSkillsStoreSkillsByCategory(): this;
    /**
     * (experimental) Grants permission to list all of the smart home appliances associated with a room.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListSmartHomeAppliances.html
     *
     * @experimental
     */
    toListSmartHomeAppliances(): this;
    /**
     * (experimental) Grants permission to list all tags on a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ListTags.html
     *
     * @experimental
     */
    toListTags(): this;
    /**
     * (experimental) Grants permission to set the conference preferences on a specific conference provider at the account level.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_PutConferencePreference.html
     *
     * @experimental
     */
    toPutConferencePreference(): this;
    /**
     * (experimental) Grants permission to publish Alexa device setup events.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/ag/manage-devices.html
     *
     * @experimental
     */
    toPutDeviceSetupEvents(): this;
    /**
     * (experimental) Grants permission to configure the email template for the user enrollment invitation with the specified attributes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_PutInvitationConfiguration.html
     *
     * @experimental
     */
    toPutInvitationConfiguration(): this;
    /**
     * (experimental) Grants permission to put a room specific parameter for a skill.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_PutRoomSkillParameter.html
     *
     * @experimental
     */
    toPutRoomSkillParameter(): this;
    /**
     * (experimental) Grants permission to link a user's account to a third-party skill provider.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_PutSkillAuthorization.html
     *
     * @experimental
     */
    toPutSkillAuthorization(): this;
    /**
     * (experimental) Grants permission to register an Alexa-enabled device built by an Original Equipment Manufacturer (OEM) using Alexa Voice Service (AVS).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_RegisterAVSDevice.html
     *
     * @experimental
     */
    toRegisterAVSDevice(): this;
    /**
     * (experimental) Grants permission to register an Alexa device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/ag/manage-devices.html
     *
     * @experimental
     */
    toRegisterDevice(): this;
    /**
     * (experimental) Grants permission to disassociate a skill from the organization under a user's AWSaccount.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_RejectSkill.html
     *
     * @experimental
     */
    toRejectSkill(): this;
    /**
     * (experimental) Grants permission to resolve room information.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ResolveRoom.html
     *
     * @experimental
     */
    toResolveRoom(): this;
    /**
     * (experimental) Grants permission to revoke an invitation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_RevokeInvitation.html
     *
     * @experimental
     */
    toRevokeInvitation(): this;
    /**
     * (experimental) Grants permission to search address books and list the ones that meet a set of filter and sort criteria.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchAddressBooks.html
     *
     * @experimental
     */
    toSearchAddressBooks(): this;
    /**
     * (experimental) Grants permission to search contacts and list the ones that meet a set of filter and sort criteria.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchContacts.html
     *
     * @experimental
     */
    toSearchContacts(): this;
    /**
     * (experimental) Grants permission to search for devices.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchDevices.html
     *
     * @experimental
     */
    toSearchDevices(): this;
    /**
     * (experimental) Grants permission to search network profiles and list the ones that meet a set of filter and sort criteria.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchNetworkProfiles.html
     *
     * @experimental
     */
    toSearchNetworkProfiles(): this;
    /**
     * (experimental) Grants permission to search for profiles.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchProfiles.html
     *
     * @experimental
     */
    toSearchProfiles(): this;
    /**
     * (experimental) Grants permission to search for rooms.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchRooms.html
     *
     * @experimental
     */
    toSearchRooms(): this;
    /**
     * (experimental) Grants permission to search for skill groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchSkillGroups.html
     *
     * @experimental
     */
    toSearchSkillGroups(): this;
    /**
     * (experimental) Grants permission to search for users.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchUsers.html
     *
     * @experimental
     */
    toSearchUsers(): this;
    /**
     * (experimental) Grants permission to trigger an asynchronous flow to send text, SSML, or audio announcements to rooms that are identified by a search or filter.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SendAnnouncement.html
     *
     * @experimental
     */
    toSendAnnouncement(): this;
    /**
     * (experimental) Grants permission to send an invitation to a user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SendInvitation.html
     *
     * @experimental
     */
    toSendInvitation(): this;
    /**
     * (experimental) Grants permission to restore the device and its account to its known, default settings by clearing all information and settings set by its previous users.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_StartDeviceSync.html
     *
     * @experimental
     */
    toStartDeviceSync(): this;
    /**
     * (experimental) Grants permission to initiate the discovery of any smart home appliances associated with the room.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_StartSmartHomeApplianceDiscovery.html
     *
     * @experimental
     */
    toStartSmartHomeApplianceDiscovery(): this;
    /**
     * (experimental) Grants permission to add metadata tags to a resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove metadata tags from a resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update address book details by the address book ARN.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateAddressBook.html
     *
     * @experimental
     */
    toUpdateAddressBook(): this;
    /**
     * (experimental) Grants permission to update the configuration of the report delivery schedule with the specified schedule ARN.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateBusinessReportSchedule.html
     *
     * @experimental
     */
    toUpdateBusinessReportSchedule(): this;
    /**
     * (experimental) Grants permission to update an existing conference provider's settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateConferenceProvider.html
     *
     * @experimental
     */
    toUpdateConferenceProvider(): this;
    /**
     * (experimental) Grants permission to update the contact details by the contact ARN.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateContact.html
     *
     * @experimental
     */
    toUpdateContact(): this;
    /**
     * (experimental) Grants permission to update device name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateDevice.html
     *
     * @experimental
     */
    toUpdateDevice(): this;
    /**
     * (experimental) Grants permission to update the details of a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateGateway.html
     *
     * @experimental
     */
    toUpdateGateway(): this;
    /**
     * (experimental) Grants permission to update the details of a gateway group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateGatewayGroup.html
     *
     * @experimental
     */
    toUpdateGatewayGroup(): this;
    /**
     * (experimental) Grants permission to update a network profile by the network profile ARN.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateNetworkProfile.html
     *
     * @experimental
     */
    toUpdateNetworkProfile(): this;
    /**
     * (experimental) Grants permission to update an existing profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateProfile.html
     *
     * @experimental
     */
    toUpdateProfile(): this;
    /**
     * (experimental) Grants permission to update room details.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateRoom.html
     *
     * @experimental
     */
    toUpdateRoom(): this;
    /**
     * (experimental) Grants permission to update skill group details with skill group ARN.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UpdateSkillGroup.html
     *
     * @experimental
     */
    toUpdateSkillGroup(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type profile to the statement.
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_Profile.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onProfile(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type room to the statement.
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_Room.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRoom(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type device to the statement.
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_Device.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDevice(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type skillgroup to the statement.
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SkillGroup.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSkillgroup(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type user to the statement.
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_UserData.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onUser(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type addressbook to the statement.
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_AddressBook.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAddressbook(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type conferenceprovider to the statement.
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_ConferenceProvider.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onConferenceprovider(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type contact to the statement.
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_Contact.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onContact(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type schedule to the statement.
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_BusinessReportSchedule.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSchedule(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type networkprofile to the statement.
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_NetworkProfile.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onNetworkprofile(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type gateway to the statement.
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_Gateway.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onGateway(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type gatewaygroup to the statement.
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_GatewayGroup.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onGatewaygroup(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters actions based on the Amazon Id in the request.
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_RegisterAVSDevice.html
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifAmazonId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters actions based on the device type in the request.
     *
     * https://docs.aws.amazon.com/a4b/latest/APIReference/API_SearchDevices.html
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifFiltersDeviceType(value: string | string[], operator?: Operator | string): this;
}
