"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComputeOptimizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [compute-optimizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscomputeoptimizer.html).
 *
 * @experimental
 */
class ComputeOptimizer extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [compute-optimizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscomputeoptimizer.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'compute-optimizer';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "List": [
                "DescribeRecommendationExportJobs",
                "GetAutoScalingGroupRecommendations",
                "GetEBSVolumeRecommendations",
                "GetEC2InstanceRecommendations",
                "GetEC2RecommendationProjectedMetrics",
                "GetEnrollmentStatus",
                "GetLambdaFunctionRecommendations",
                "GetRecommendationSummaries"
            ],
            "Write": [
                "ExportAutoScalingGroupRecommendations",
                "ExportEBSVolumeRecommendations",
                "ExportEC2InstanceRecommendations",
                "ExportLambdaFunctionRecommendations",
                "UpdateEnrollmentStatus"
            ]
        };
    }
    /**
     * (experimental) Grants permission to view the status of recommendation export jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_DescribeRecommendationExportJobs.html
     *
     * @experimental
     */
    toDescribeRecommendationExportJobs() {
        return this.to('DescribeRecommendationExportJobs');
    }
    /**
     * (experimental) Grants permission to export autoscaling group recommendations to S3 for the provided accounts.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - autoscaling:DescribeAutoScalingGroups
     * - compute-optimizer:GetAutoScalingGroupRecommendations
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportAutoScalingGroupRecommendations.html
     *
     * @experimental
     */
    toExportAutoScalingGroupRecommendations() {
        return this.to('ExportAutoScalingGroupRecommendations');
    }
    /**
     * (experimental) Grants permission to export EBS volume recommendations to S3 for the provided accounts.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - compute-optimizer:GetEBSVolumeRecommendations
     * - ec2:DescribeVolumes
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportEBSVolumeRecommendations.html
     *
     * @experimental
     */
    toExportEBSVolumeRecommendations() {
        return this.to('ExportEBSVolumeRecommendations');
    }
    /**
     * (experimental) Grants permission to export EC2 instance recommendations to S3 for the provided accounts.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - compute-optimizer:GetEC2InstanceRecommendations
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportEC2InstanceRecommendations.html
     *
     * @experimental
     */
    toExportEC2InstanceRecommendations() {
        return this.to('ExportEC2InstanceRecommendations');
    }
    /**
     * (experimental) Grants permission to export Lambda function recommendations to S3 for the provided accounts.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - compute-optimizer:GetLambdaFunctionRecommendations
     * - lambda:ListFunctions
     * - lambda:ListProvisionedConcurrencyConfigs
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportLambdaFunctionRecommendations.html
     *
     * @experimental
     */
    toExportLambdaFunctionRecommendations() {
        return this.to('ExportLambdaFunctionRecommendations');
    }
    /**
     * (experimental) Grants permission to get recommendations for the provided autoscaling groups.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - autoscaling:DescribeAutoScalingGroups
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetAutoScalingGroupRecommendations.html
     *
     * @experimental
     */
    toGetAutoScalingGroupRecommendations() {
        return this.to('GetAutoScalingGroupRecommendations');
    }
    /**
     * (experimental) Grants permission to get recommendations for the provided ebs volumes.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeVolumes
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEBSVolumeRecommendations.html
     *
     * @experimental
     */
    toGetEBSVolumeRecommendations() {
        return this.to('GetEBSVolumeRecommendations');
    }
    /**
     * (experimental) Grants permission to get recommendations for the provided EC2 instances.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2InstanceRecommendations.html
     *
     * @experimental
     */
    toGetEC2InstanceRecommendations() {
        return this.to('GetEC2InstanceRecommendations');
    }
    /**
     * (experimental) Grants permission to get the recommendation projected metrics of the specified instance.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2RecommendationProjectedMetrics.html
     *
     * @experimental
     */
    toGetEC2RecommendationProjectedMetrics() {
        return this.to('GetEC2RecommendationProjectedMetrics');
    }
    /**
     * (experimental) Grants permission to get the enrollment status for the specified account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEnrollmentStatus.html
     *
     * @experimental
     */
    toGetEnrollmentStatus() {
        return this.to('GetEnrollmentStatus');
    }
    /**
     * (experimental) Grants permission to get recommendations for the provided lambda functions.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - lambda:ListFunctions
     * - lambda:ListProvisionedConcurrencyConfigs
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetLambdaFunctionRecommendations.html
     *
     * @experimental
     */
    toGetLambdaFunctionRecommendations() {
        return this.to('GetLambdaFunctionRecommendations');
    }
    /**
     * (experimental) Grants permission to get the recommendation summaries for the specified account(s).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetRecommendationSummaries.html
     *
     * @experimental
     */
    toGetRecommendationSummaries() {
        return this.to('GetRecommendationSummaries');
    }
    /**
     * (experimental) Grants permission to update the enrollment status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_UpdateEnrollmentStatus.html
     *
     * @experimental
     */
    toUpdateEnrollmentStatus() {
        return this.to('UpdateEnrollmentStatus');
    }
}
exports.ComputeOptimizer = ComputeOptimizer;
_a = JSII_RTTI_SYMBOL_1;
ComputeOptimizer[_a] = { fqn: "iam-floyd.ComputeOptimizer", version: "0.212.0" };
//# sourceMappingURL=data:application/json;base64,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