import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
/**
 * (experimental) Statement provider for service [elasticloadbalancing-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_elasticloadbalancingv2.html).
 *
 * @experimental
 */
export declare class ElasticloadbalancingV2 extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [elasticloadbalancing-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_elasticloadbalancingv2.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Adds the specified certificates to the specified secure listener.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_AddListenerCertificates.html
     *
     * @experimental
     */
    toAddListenerCertificates(): this;
    /**
     * (experimental) Adds the specified tags to the specified load balancer. Each load balancer can have a maximum of 10 tags.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_AddTags.html
     *
     * @experimental
     */
    toAddTags(): this;
    /**
     * (experimental) Creates a listener for the specified Application Load Balancer.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateListener.html
     *
     * @experimental
     */
    toCreateListener(): this;
    /**
     * (experimental) Creates a load balancer.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateLoadBalancer.html
     *
     * @experimental
     */
    toCreateLoadBalancer(): this;
    /**
     * (experimental) Creates a rule for the specified listener.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateRule.html
     *
     * @experimental
     */
    toCreateRule(): this;
    /**
     * (experimental) Creates a target group.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html
     *
     * @experimental
     */
    toCreateTargetGroup(): this;
    /**
     * (experimental) Deletes the specified listener.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DeleteListener.html
     *
     * @experimental
     */
    toDeleteListener(): this;
    /**
     * (experimental) Deletes the specified load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DeleteLoadBalancer.html
     *
     * @experimental
     */
    toDeleteLoadBalancer(): this;
    /**
     * (experimental) Deletes the specified rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DeleteRule.html
     *
     * @experimental
     */
    toDeleteRule(): this;
    /**
     * (experimental) Deletes the specified target group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DeleteTargetGroup.html
     *
     * @experimental
     */
    toDeleteTargetGroup(): this;
    /**
     * (experimental) Deregisters the specified targets from the specified target group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DeregisterTargets.html
     *
     * @experimental
     */
    toDeregisterTargets(): this;
    /**
     * (experimental) Describes the Elastic Load Balancing resource limits for the AWSaccount.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeAccountLimits.html
     *
     * @experimental
     */
    toDescribeAccountLimits(): this;
    /**
     * (experimental) Describes the certificates for the specified secure listener.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeListenerCertificates.html
     *
     * @experimental
     */
    toDescribeListenerCertificates(): this;
    /**
     * (experimental) Describes the specified listeners or the listeners for the specified Application Load Balancer.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeListeners.html
     *
     * @experimental
     */
    toDescribeListeners(): this;
    /**
     * (experimental) Describes the attributes for the specified load balancer.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancerAttributes.html
     *
     * @experimental
     */
    toDescribeLoadBalancerAttributes(): this;
    /**
     * (experimental) Describes the specified the load balancers.
     *
     * If no load balancers are specified, the call describes all of your load balancers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html
     *
     * @experimental
     */
    toDescribeLoadBalancers(): this;
    /**
     * (experimental) Describes the specified rules or the rules for the specified listener.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeRules.html
     *
     * @experimental
     */
    toDescribeRules(): this;
    /**
     * (experimental) Describes the specified policies or all policies used for SSL negotiation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeSSLPolicies.html
     *
     * @experimental
     */
    toDescribeSSLPolicies(): this;
    /**
     * (experimental) Describes the tags associated with the specified resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTags.html
     *
     * @experimental
     */
    toDescribeTags(): this;
    /**
     * (experimental) Describes the attributes for the specified target group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroupAttributes.html
     *
     * @experimental
     */
    toDescribeTargetGroupAttributes(): this;
    /**
     * (experimental) Describes the specified target groups or all of your target groups.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html
     *
     * @experimental
     */
    toDescribeTargetGroups(): this;
    /**
     * (experimental) Describes the health of the specified targets or all of your targets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetHealth.html
     *
     * @experimental
     */
    toDescribeTargetHealth(): this;
    /**
     * (experimental) Modifies the specified properties of the specified listener.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_ModifyListener.html
     *
     * @experimental
     */
    toModifyListener(): this;
    /**
     * (experimental) Modifies the attributes of the specified load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_ModifyLoadBalancerAttributes.html
     *
     * @experimental
     */
    toModifyLoadBalancerAttributes(): this;
    /**
     * (experimental) Modifies the specified rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_ModifyRule.html
     *
     * @experimental
     */
    toModifyRule(): this;
    /**
     * (experimental) Modifies the health checks used when evaluating the health state of the targets in the specified target group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_ModifyTargetGroup.html
     *
     * @experimental
     */
    toModifyTargetGroup(): this;
    /**
     * (experimental) Modifies the specified attributes of the specified target group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_ModifyTargetGroupAttributes.html
     *
     * @experimental
     */
    toModifyTargetGroupAttributes(): this;
    /**
     * (experimental) Registers the specified targets with the specified target group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_RegisterTargets.html
     *
     * @experimental
     */
    toRegisterTargets(): this;
    /**
     * (experimental) Removes the specified certificates of the specified secure listener.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_RemoveListenerCertificates.html
     *
     * @experimental
     */
    toRemoveListenerCertificates(): this;
    /**
     * (experimental) Removes one or more tags from the specified load balancer.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_RemoveTags.html
     *
     * @experimental
     */
    toRemoveTags(): this;
    /**
     * (experimental) Not found.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_SetIpAddressType.html
     *
     * @experimental
     */
    toSetIpAddressType(): this;
    /**
     * (experimental) Sets the priorities of the specified rules.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_SetRulePriorities.html
     *
     * @experimental
     */
    toSetRulePriorities(): this;
    /**
     * (experimental) Associates the specified security groups with the specified load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_SetSecurityGroups.html
     *
     * @experimental
     */
    toSetSecurityGroups(): this;
    /**
     * (experimental) Enables the Availability Zone for the specified subnets for the specified load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_SetSubnets.html
     *
     * @experimental
     */
    toSetSubnets(): this;
    /**
     * (experimental) Gives WebAcl permission to WAF.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toSetWebAcl(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type listener/app to the statement.
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html
     *
     * @param loadBalancerName - Identifier for the loadBalancerName.
     * @param loadBalancerId - Identifier for the loadBalancerId.
     * @param listenerId - Identifier for the listenerId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onListenerApp(loadBalancerName: string, loadBalancerId: string, listenerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type listener-rule/app to the statement.
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/application/listener-update-rules.html
     *
     * @param loadBalancerName - Identifier for the loadBalancerName.
     * @param loadBalancerId - Identifier for the loadBalancerId.
     * @param listenerId - Identifier for the listenerId.
     * @param listenerRuleId - Identifier for the listenerRuleId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onListenerRuleApp(loadBalancerName: string, loadBalancerId: string, listenerId: string, listenerRuleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type listener/net to the statement.
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html
     *
     * @param loadBalancerName - Identifier for the loadBalancerName.
     * @param loadBalancerId - Identifier for the loadBalancerId.
     * @param listenerId - Identifier for the listenerId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onListenerNet(loadBalancerName: string, loadBalancerId: string, listenerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type listener-rule/net to the statement.
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/application/listener-update-rules.html
     *
     * @param loadBalancerName - Identifier for the loadBalancerName.
     * @param loadBalancerId - Identifier for the loadBalancerId.
     * @param listenerId - Identifier for the listenerId.
     * @param listenerRuleId - Identifier for the listenerRuleId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onListenerRuleNet(loadBalancerName: string, loadBalancerId: string, listenerId: string, listenerRuleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type loadbalancer/app/ to the statement.
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/application/introduction.html#application-load-balancer-overview
     *
     * @param loadBalancerName - Identifier for the loadBalancerName.
     * @param loadBalancerId - Identifier for the loadBalancerId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLoadbalancerApp(loadBalancerName: string, loadBalancerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type loadbalancer/net/ to the statement.
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/network/introduction.html#network-load-balancer-overview
     *
     * @param loadBalancerName - Identifier for the loadBalancerName.
     * @param loadBalancerId - Identifier for the loadBalancerId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLoadbalancerNet(loadBalancerName: string, loadBalancerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type targetgroup to the statement.
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html
     *
     * @param targetGroupName - Identifier for the targetGroupName.
     * @param targetGroupId - Identifier for the targetGroupId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTargetgroup(targetGroupName: string, targetGroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) A tag key and value pair.
     *
     * Applies to resource types:
     * - listener/app
     * - listener-rule/app
     * - listener/net
     * - listener-rule/net
     * - loadbalancer/app/
     * - loadbalancer/net/
     * - targetgroup
     *
     * @param tagKey The tag key to check.
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
}
