"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transcribe = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [transcribe](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranscribe.html).
 *
 * @experimental
 */
class Transcribe extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [transcribe](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranscribe.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'transcribe';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "CreateLanguageModel",
                "CreateMedicalVocabulary",
                "CreateVocabulary",
                "CreateVocabularyFilter",
                "DeleteLanguageModel",
                "DeleteMedicalTranscriptionJob",
                "DeleteMedicalVocabulary",
                "DeleteTranscriptionJob",
                "DeleteVocabulary",
                "DeleteVocabularyFilter",
                "StartMedicalStreamTranscription",
                "StartMedicalStreamTranscriptionWebSocket",
                "StartMedicalTranscriptionJob",
                "StartStreamTranscription",
                "StartStreamTranscriptionWebSocket",
                "StartTranscriptionJob",
                "UpdateMedicalVocabulary",
                "UpdateVocabulary",
                "UpdateVocabularyFilter"
            ],
            "Read": [
                "DescribeLanguageModel",
                "GetMedicalTranscriptionJob",
                "GetMedicalVocabulary",
                "GetTranscriptionJob",
                "GetVocabulary",
                "GetVocabularyFilter"
            ],
            "List": [
                "ListLanguageModels",
                "ListMedicalTranscriptionJobs",
                "ListMedicalVocabularies",
                "ListTranscriptionJobs",
                "ListVocabularies",
                "ListVocabularyFilters"
            ]
        };
    }
    /**
     * (experimental) Grants permission to create a new custom language model.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     * - s3:ListBucket
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateLanguageModel.html
     *
     * @experimental
     */
    toCreateLanguageModel() {
        return this.to('CreateLanguageModel');
    }
    /**
     * (experimental) Grants permission to create a new custom vocabulary that you can use to change the way Amazon Transcribe Medical handles transcription of an audio file.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateMedicalVocabulary.html
     *
     * @experimental
     */
    toCreateMedicalVocabulary() {
        return this.to('CreateMedicalVocabulary');
    }
    /**
     * (experimental) Grants permission to create a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an audio file.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabulary.html
     *
     * @experimental
     */
    toCreateVocabulary() {
        return this.to('CreateVocabulary');
    }
    /**
     * (experimental) Grants permission to create a new vocabulary filter that you can use to filter out words from the transcription of an audio file generated by Amazon Transcribe.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabularyFilter.html
     *
     * @experimental
     */
    toCreateVocabularyFilter() {
        return this.to('CreateVocabularyFilter');
    }
    /**
     * (experimental) Grants permission to delete a previously created custom language model.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteLanguageModel.html
     *
     * @experimental
     */
    toDeleteLanguageModel() {
        return this.to('DeleteLanguageModel');
    }
    /**
     * (experimental) Grants permission to delete a previously submitted medical transcription job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalTranscriptionJob.html
     *
     * @experimental
     */
    toDeleteMedicalTranscriptionJob() {
        return this.to('DeleteMedicalTranscriptionJob');
    }
    /**
     * (experimental) Grants permission to delete a medical vocabulary from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalVocabulary.html
     *
     * @experimental
     */
    toDeleteMedicalVocabulary() {
        return this.to('DeleteMedicalVocabulary');
    }
    /**
     * (experimental) Grants permission to delete a previously submitted transcription job along with any other generated results such as the transcription, models, and so on.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteTranscriptionJob.html
     *
     * @experimental
     */
    toDeleteTranscriptionJob() {
        return this.to('DeleteTranscriptionJob');
    }
    /**
     * (experimental) Grants permission to delete a vocabulary from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabulary.html
     *
     * @experimental
     */
    toDeleteVocabulary() {
        return this.to('DeleteVocabulary');
    }
    /**
     * (experimental) Grants permission to delete a vocabulary filter from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabularyFilter.html
     *
     * @experimental
     */
    toDeleteVocabularyFilter() {
        return this.to('DeleteVocabularyFilter');
    }
    /**
     * (experimental) Grants permission to return information about a custom language model.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DescribeLanguageModel.html
     *
     * @experimental
     */
    toDescribeLanguageModel() {
        return this.to('DescribeLanguageModel');
    }
    /**
     * (experimental) Grants permission to return information about a medical transcription job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalTranscriptionJob.html
     *
     * @experimental
     */
    toGetMedicalTranscriptionJob() {
        return this.to('GetMedicalTranscriptionJob');
    }
    /**
     * (experimental) Grants permission to get information about a medical vocabulary.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalVocabulary.html
     *
     * @experimental
     */
    toGetMedicalVocabulary() {
        return this.to('GetMedicalVocabulary');
    }
    /**
     * (experimental) Grants permission to return information about a transcription job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetTranscriptionJob.html
     *
     * @experimental
     */
    toGetTranscriptionJob() {
        return this.to('GetTranscriptionJob');
    }
    /**
     * (experimental) Grants permission to to get information about a vocabulary.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabulary.html
     *
     * @experimental
     */
    toGetVocabulary() {
        return this.to('GetVocabulary');
    }
    /**
     * (experimental) Grants permission to get information about a vocabulary filter.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabularyFilter.html
     *
     * @experimental
     */
    toGetVocabularyFilter() {
        return this.to('GetVocabularyFilter');
    }
    /**
     * (experimental) Grants permission to list custom language models.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListLanguageModels.html
     *
     * @experimental
     */
    toListLanguageModels() {
        return this.to('ListLanguageModels');
    }
    /**
     * (experimental) Grants permission to list medical transcription jobs with the specified status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalTranscriptionJobs.html
     *
     * @experimental
     */
    toListMedicalTranscriptionJobs() {
        return this.to('ListMedicalTranscriptionJobs');
    }
    /**
     * (experimental) Grants permission to return a list of medical vocabularies that match the specified criteria.
     *
     * If no criteria are specified, returns the entire list of vocabularies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalVocabularies.html
     *
     * @experimental
     */
    toListMedicalVocabularies() {
        return this.to('ListMedicalVocabularies');
    }
    /**
     * (experimental) Grants permission to list transcription jobs with the specified status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListTranscriptionJobs.html
     *
     * @experimental
     */
    toListTranscriptionJobs() {
        return this.to('ListTranscriptionJobs');
    }
    /**
     * (experimental) Grants permission to return a list of vocabularies that match the specified criteria.
     *
     * If no criteria are specified, returns the entire list of vocabularies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularies.html
     *
     * @experimental
     */
    toListVocabularies() {
        return this.to('ListVocabularies');
    }
    /**
     * (experimental) Grants permission to return a list of vocabulary filters that match the specified criteria.
     *
     * If no criteria are specified, returns the at most 5 vocabulary filters.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularyFilters.html
     *
     * @experimental
     */
    toListVocabularyFilters() {
        return this.to('ListVocabularyFilters');
    }
    /**
     * (experimental) Grants permission to start a protocol where audio is streamed to Transcribe Medical and the transcription results are streamed to your application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscription.html
     *
     * @experimental
     */
    toStartMedicalStreamTranscription() {
        return this.to('StartMedicalStreamTranscription');
    }
    /**
     * (experimental) Grants permission to start a WebSocket where audio is streamed to Transcribe Medical and the transcription results are streamed to your application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscriptionWebSocket.html
     *
     * @experimental
     */
    toStartMedicalStreamTranscriptionWebSocket() {
        return this.to('StartMedicalStreamTranscriptionWebSocket');
    }
    /**
     * (experimental) Grants permission to start an asynchronous job to transcribe medical speech to text.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_StartMedicalTranscriptionJob.html
     *
     * @experimental
     */
    toStartMedicalTranscriptionJob() {
        return this.to('StartMedicalTranscriptionJob');
    }
    /**
     * (experimental) Grants permission to start a bidirectional HTTP2 stream to transcribe speech to text in real time.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscription.html
     *
     * @experimental
     */
    toStartStreamTranscription() {
        return this.to('StartStreamTranscription');
    }
    /**
     * (experimental) Grants permission to start a websocket stream to transcribe speech to text in real time.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscriptionWebSocket.html
     *
     * @experimental
     */
    toStartStreamTranscriptionWebSocket() {
        return this.to('StartStreamTranscriptionWebSocket');
    }
    /**
     * (experimental) Grants permission to start an asynchronous job to transcribe speech to text.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifOutputBucketName()
     * - .ifOutputEncryptionKMSKeyId()
     * - .ifOutputKey()
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_StartTranscriptionJob.html
     *
     * @experimental
     */
    toStartTranscriptionJob() {
        return this.to('StartTranscriptionJob');
    }
    /**
     * (experimental) Grants permission to update an existing medical vocabulary with new values.
     *
     * The UpdateMedicalVocabulary operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateMedicalVocabulary.html
     *
     * @experimental
     */
    toUpdateMedicalVocabulary() {
        return this.to('UpdateMedicalVocabulary');
    }
    /**
     * (experimental) Grants permission to update an existing vocabulary with new values.
     *
     * The UpdateVocabulary operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabulary.html
     *
     * @experimental
     */
    toUpdateVocabulary() {
        return this.to('UpdateVocabulary');
    }
    /**
     * (experimental) Grants permission to update an existing vocabulary filter with new values.
     *
     * The UpdateVocabularyFilter operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabularyFilter.html
     *
     * @experimental
     */
    toUpdateVocabularyFilter() {
        return this.to('UpdateVocabularyFilter');
    }
    /**
     * (experimental) Enables you to control access based on the output bucket name included in the request.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranscribe.html#amazontranscribe-policy-keys
     *
     * Applies to actions:
     * - .toStartTranscriptionJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifOutputBucketName(value, operator) {
        return this.if(`OutputBucketName`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Enables you to control access based on the KMS key id included in the request.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranscribe.html#amazontranscribe-policy-keys
     *
     * Applies to actions:
     * - .toStartTranscriptionJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifOutputEncryptionKMSKeyId(value, operator) {
        return this.if(`OutputEncryptionKMSKeyId`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Enables you to control access based on the output key included in the request.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranscribe.html#amazontranscribe-policy-keys
     *
     * Applies to actions:
     * - .toStartTranscriptionJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifOutputKey(value, operator) {
        return this.if(`OutputKey`, value, operator || 'StringLike');
    }
}
exports.Transcribe = Transcribe;
_a = JSII_RTTI_SYMBOL_1;
Transcribe[_a] = { fqn: "iam-floyd.Transcribe", version: "0.212.0" };
//# sourceMappingURL=data:application/json;base64,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