import datetime
from numpy import datetime64
from numpy import float64
from numpy import float32
from numpy import int32  # int
from numpy import int64  # long

# Pandas data types to impose them when creating a dataframe
# rather than having it guess from the data.

domain_dataframe_column_types = {
    # table names here
    "care_site": {
        "care_site_id": int64,
        "care_site_name": str,
        "place_of_service_concept_id": int32,
        "location_id": int64,
        "care_site_source_value": str,
        "place_of_service_source_value": str,
        "filename": str,
    },
    "location": {
        "location_id": int64,
        "address_1": str,
        "address_2": str,
        "city": str,
        "state": str,
        "zip": str,
        "county": str,
        "location_source_value": str,
        "filename": str,
    },
    "provider": {
        "provider_id": int64,
        "provider_name": str,
        "npi": str,
        "dea": str,
        "specialty_concept_id": int32,
        "care_site_id": int64,
        "year_of_birth": int32,
        "gender_concept_id": int32,
        "provider_source_value": str,
        "specialty_source_value": str,
        "specialty_source_concept_id": int32,
        "gender_source_value": str,
        "gender_source_concept_id": int32,
        "filename": str,
    },
    "person": {
        "person_id": int64,
        "gender_concept_id": int32,
        "year_of_birth": int32,
        "month_of_birth": int32,
        "day_of_birth": int32,
        "birth_datetime": datetime.datetime,
        "race_concept_id": int32,
        "ethnicity_concept_id": int32,
        "location_id": int64,
        "provider_id": int64,
        "care_site_id": int64,
        "person_source_value": str,
        "gender_source_value": str,
        "gender_source_concept_id": int32,
        "race_source_value": str,
        "race_source_concept_id": int32,
        "ethnicity_source_value": str,
        "ethnicity_source_concept_id": int32,
        "filename": str,
    },
    "visit_occurrence": {
        "visit_occurrence_id": int64,
        "person_id": int64,
        "visit_concept_id": int32,
        "visit_start_date": datetime.date,
        "visit_start_datetime": datetime.datetime,
        "visit_end_date": datetime.date,
        "visit_end_datetime": datetime.datetime,
        "visit_type_concept_id": int32,
        "provider_id": int64,
        "care_site_id": int64,
        "visit_source_value": str,
        "visit_source_concept_id": int32,
        "admitting_source_value": str,
        "admitting_source_concept_id": int32,
        "discharge_to_concept_id": int32,
        "discharge_to_source_value": str,
        "preceding_visit_occurrence_id": int64,
        "filename": str,
    },
    "measurement": {
        "measurement_id": int64,
        "person_id": int64,
        "measurement_concept_id": int32,
        "measurement_date": datetime.date,
        "measurement_datetime": datetime.datetime,
        "measurement_time": str,
        "measurement_type_concept_id": int32,
        "operator_concept_id": int32,
        "value_as_number": float64,
        "value_as_concept_id": int32,
        "unit_concept_id": int32,
        "range_low": float32,
        "range_high": float32,
        "provider_id": int64,
        "visit_occurrence_id": int64,
        "visit_detail_id": int64,
        "measurement_source_value": str,
        "measurement_source_concept_id": int32,
        "unit_source_value": str,
        "value_source_value": str,
        "filename": str,
    },
    "observation": {
        "observation_id": int64,
        "person_id": int64,
        "observation_concept_id": int32,
        "observation_date": datetime.date,
        "observation_datetime": datetime.datetime,
        "observation_type_concept_id": int32,
        "value_as_number": float64,
        "value_as_string": str,
        "value_as_concept_id": int32,
        "qualifier_concept_id": int32,
        "unit_concept_id": int32,
        "provider_id": int64,
        "visit_occurrence_id": int64,
        "visit_detail_id": int64,
        "observation_source_value": str,
        "observation_source_concept_id": int32,
        "unit_source_value": str,
        "qualifier_source_value": str,
        "filename": str,
    },
    "condition_occurrence": {
        "condition_occurrence_id": int64,
        "person_id": int64,
        "condition_concept_id": int32,
        "condition_start_date": datetime.date,
        "condition_start_datetime": datetime.datetime,
        "condition_end_date": datetime.date,
        "condition_end_datetime": datetime.datetime,
        "condition_type_concept_id": int32,
        "condition_status_concept_id": int32,
        "stop_reason": str,
        "provider_id": int64,
        "visit_occurrence_id": int64,
        "visit_detail_id": int64,
        "condition_source_value": str,
        "condition_source_concept_id": int32,
        "condition_status_source_value": str,
        "filename": str,
    },
    "procedure_occurrence": {
        "procedure_occurrence_id": int64,
        "person_id": int64,
        "procedure_concept_id": int32,
        "procedure_date": datetime.date,
        "procedure_datetime": datetime.datetime,
        "procedure_type_concept_id": int32,
        "modifier_concept_id": int32,
        "quantity": int32,
        "provider_id": int64,
        "visit_occurrence_id": int64,
        "visit_detail_id": int64,
        "procedure_source_value": str,
        "procedure_source_concept_id": int32,
        "modifier_source_value": str,
        "filename": str,
    },
    "drug_exposure": {
        "drug_exposure_id": int64,
        "person_id": int64,
        "drug_concept_id": int32,
        "drug_exposure_start_date": datetime.date,
        "drug_exposure_start_datetime": datetime.datetime,
        "drug_exposure_end_date": datetime.date,
        "drug_exposure_end_datetime": datetime.datetime,
        "verbatim_end_date": datetime.date,
        "drug_type_concept_id": int32,
        "stop_reason": str,
        "refills": int32,
        "quantity": float32,
        "days_supply": int32,
        "sig": str,
        "route_concept_id": int32,
        "lot_number": str,
        "provider_id": int64,
        "visit_occurrence_id": int64,
        "visit_detail_id": int64,
        "drug_source_value": str,
        "drug_source_concept_id": int32,
        "route_source_value": str,
        "dose_unit_source_value": str,
        "filename": str,
    },
    "device_exposure": {
        "device_concept_id": int32,
        "person_id": int64,
        "device_exposure_start_date": datetime.date,
        "device_exposure_start_datetime": datetime.datetime,
        "device_exposure_end_date": datetime.date,
        "device_exposure_end_datetime": datetime.datetime,
        "device_type_concept_id": int32,
        "unique_device_id": str,
        "quantity": int32,
        "provider_id": int64,
        "visit_occurrence_id": int64,
        "visit_detail_id": int64,
        "device_source_value": str,
        "device_source_concept_id": int32,
    },
}
domain_dataframe_column_required = {
    # table names here
    "care_site": {
        "care_site_id": True,
        "care_site_name": False,
        "place_of_service_concept_id": False,
        "location_id": False,
        "care_site_source_value": False,
        "place_of_service_source_value": False,
        "filename": False,
    },
    "location": {
        "location_id": True,
        "address_1": False,
        "address_2": False,
        "city": False,
        "state": False,
        "zip": False,
        "county": False,
        "location_source_value": False,
        "filename": False
    },
    "provider": {
        "provider_id": True,
        "provider_name": False,
        "npi": False,
        "dea": False,
        "specialty_concept_id": False,
        "care_site_id": False,
        "year_of_birth": False,
        "gender_concept_id": False,
        "provider_source_value": False,
        "specialty_source_value": False,
        "specialty_source_concept_id": False,
        "gender_source_value": False,
        "gender_source_concept_id": False,
        "filename": False,
    },
    "person": {
        "person_id": True,
        "gender_concept_id": True,
        "year_of_birth": True,
        "month_of_birth": False,
        "day_of_birth": False,
        "birth_datetime": False,
        "race_concept_id": True,
        "ethnicity_concept_id": True,
        "location_id": False,
        "provider_id": False,
        "care_site_id": False,
        "person_source_value": False,
        "gender_source_value": False,
        "gender_source_concept_id": False,
        "race_source_value": False,
        "race_source_concept_id": False,
        "ethnicity_source_value": False,
        "ethnicity_source_concept_id": False,
        "filename": False,
    },
    "visit_occurrence": {
        "visit_occurrence_id": True,
        "person_id": True,
        "visit_concept_id": True,
        "visit_start_date": True,
        "visit_start_datetime": False,
        "visit_end_date": True, 
        "visit_end_datetime": False,
        "visit_type_concept_id": True,
        "provider_id": False,
        "care_site_id": False,
        "visit_source_value": False,
        "visit_source_concept_id": False,
        "admitting_source_value": False,
        "admitting_source_concept_id": False,
        "discharge_to_concept_id": False,
        "discharge_to_source_value": False,
        "preceding_visit_occurrence_id": False,
        "filename": False,
    },
    "measurement": {
        "measurement_id": True,
        "person_id": True,
        "measurement_concept_id": True,
        "measurement_date": True,
        "measurement_datetime": False,
        "measurement_time": False,
        "measurement_type_concept_id": True,
        "operator_concept_id": False,
        "value_as_number": False,
        "value_as_concept_id": False,
        "unit_concept_id": False,
        "range_low": False,
        "range_high": False,
        "provider_id": False,
        "visit_occurrence_id": False,
        "visit_detail_id": False,
        "measurement_source_value": False,
        "measurement_source_concept_id": False,
        "unit_source_value": False,
        "value_source_value": False,
        "filename": False,
    },
    "observation": {
        "observation_id": True,
        "person_id": True,
        "observation_concept_id": True,
        "observation_date": True,
        "observation_datetime": False,
        "observation_type_concept_id": True,
        "value_as_number": False,
        "value_as_Falseing": False,
        "value_as_concept_id": False,
        "qualifier_concept_id": False,
        "unit_concept_id": False,
        "provider_id": False,
        "visit_occurrence_id": False,
        "visit_detail_id": False,
        "observation_source_value": False,
        "observation_source_concept_id": False,
        "unit_source_value": False,
        "qualifier_source_value": False,
        "filename": False,
    },
    "condition_occurrence": {
        "condition_occurrence_id": True,
        "person_id": True,
        "condition_concept_id": True,
        "condition_start_date": True,
        "condition_start_datetime": False,
        "condition_end_date": False,
        "condition_end_datetime": False,
        "condition_type_concept_id": True,
        "condition_status_concept_id": False,
        "stop_reason": False,
        "provider_id": False,
        "visit_occurrence_id": False,
        "visit_detail_id": False,
        "condition_source_value": False,
        "condition_source_concept_id": False,
        "condition_status_source_value": False,
        "filename": False,
    },
    "procedure_occurrence": {
        "procedure_occurrence_id": True,
        "person_id": True,
        "procedure_concept_id": True,
        "procedure_date": True,
        "procedure_datetime": False,
        "procedure_type_concept_id": True,
        "modifier_concept_id": False,
        "quantity": False,
        "provider_id": False,
        "visit_occurrence_id": False,
        "visit_detail_id": False,
        "procedure_source_value": False,
        "procedure_source_concept_id": False,
        "modifier_source_value": False,
        "filename": False,
    },
    "drug_exposure": {
        "drug_exposure_id": True,
        "person_id": True,
        "drug_concept_id": True,
        "drug_exposure_start_date": True,
        "drug_exposure_start_datetime": False,
        "drug_exposure_end_date": False,      # set to False as discussed in #476 and #481.
        "drug_exposure_end_datetime": False,
        "verbatim_end_date": False,
        "drug_type_concept_id": True,
        "stop_reason": False,
        "refills": False,
        "quantity": False,
        "days_supply": False,
        "sig": False,
        "route_concept_id": False,
        "lot_number": False,
        "provider_id": False,
        "visit_occurrence_id": False,
        "visit_detail_id": False,
        "drug_source_value": False,
        "drug_source_concept_id": False,
        "route_source_value": False,
        "dose_unit_source_value": False,
        "filename": False,
    },
    "device_exposure": {
        "device_concept_id": True,
        "person_id": True,
        "device_exposure_start_date": True,
        "device_exposure_start_datetime": False,
        "device_exposure_end_date": False,
        "device_exposure_end_datetime": False,
        "device_type_concept_id": True,
        "unique_device_id": False,
        "quantity": False,
        "provider_id": False,
        "visit_occurrence_id": False,
        "visit_detail_id": False,
        "device_source_value": False,
        "device_source_concept_id": False,
    },
}

