import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [appflow](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonappflow.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Appflow extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    protected resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [appflow](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonappflow.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a login profile to be used with AppFlow flows
     *
     * Access Level: Write
     */
    createConnectorProfile(): this;
    /**
     * Grants permission to create an AppFlow flow
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     */
    createFlow(): this;
    /**
     * Grants permission to delete a login profile set up for use with AppFlow
     *
     * Access Level: Write
     */
    deleteConnectorProfile(): this;
    /**
     * Grants permission to delete an AppFlow flow
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     */
    deleteFlow(): this;
    /**
     * Grants permission to describe all fields supported by AppFlow
     *
     * Access Level: Read
     */
    describeConnectorFields(): this;
    /**
     * Grants permission to describe all login profiles configured in AppFlow
     *
     * Access Level: Read
     */
    describeConnectorProfiles(): this;
    /**
     * Grants permission to describe all connectors supported by AppFlow
     *
     * Access Level: Read
     */
    describeConnectors(): this;
    /**
     * Grants permission to describe all flow executions for a flow configured in AppFlow
     *
     * Access Level: Read
     */
    describeFlowExecution(): this;
    /**
     * Grants permission to describe all flows configured in AppFlow
     *
     * Access Level: Read
     */
    describeFlows(): this;
    /**
     * Grants permission to list all fields supported by AppFlow
     *
     * Access Level: Read
     */
    listConnectorFields(): this;
    /**
     * Grants permission to list tags for a flow
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appflow/latest/APIReference/API_ListTagsForResource.html
     */
    listTagsForResource(): this;
    /**
     * Grants permission to run a flow configured in AppFlow
     *
     * Access Level: Write
     */
    runFlow(): this;
    /**
     * Grants permission to tag a flow
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/appflow/latest/APIReference/API_TagResource.html
     */
    tagResource(): this;
    /**
     * Grants permission to untag a flow
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appflow/latest/APIReference/API_UntagResource.html
     */
    untagResource(): this;
    /**
     * Grants permission to update an AppFlow flow
     *
     * Access Level: Write
     */
    updateFlow(): this;
    /**
     * Adds a resource of type flow to the statement
     *
     * @param flowName - Identifier for the flowName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFlow(flowName: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type connectorprofile to the statement
     *
     * @param profileName - Identifier for the profileName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onConnectorprofile(profileName: string, account?: string, partition?: string): this;
    /**
     * Filters actions based on the allowed set of values for each of the tags
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .createFlow()
     * - .deleteFlow()
     * - .tagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: string): this;
    /**
     * Filters actions based on tag-value associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - flow
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: string): this;
    /**
     * Filters actions based on the presence of mandatory tags in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .createFlow()
     * - .deleteFlow()
     * - .tagResource()
     * - .untagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: string): this;
}
