import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [elasticache](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonelasticache.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Elasticache extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    protected resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [elasticache](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonelasticache.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * The AddTagsToResource action adds up to 10 cost allocation tags to the named resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_AddTagsToResource.html
     */
    addTagsToResource(): this;
    /**
     * The AuthorizeCacheSecurityGroupIngress action allows network ingress to a cache security group.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:AuthorizeSecurityGroupIngress
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_AuthorizeCacheSecurityGroupIngress.html
     */
    authorizeCacheSecurityGroupIngress(): this;
    /**
     * Apply the service update.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_BatchApplyUpdateAction.html
     */
    batchApplyUpdateAction(): this;
    /**
     * Stop the service update.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_BatchStopUpdateAction.html
     */
    batchStopUpdateAction(): this;
    /**
     * Stop the service update.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CompleteMigration.html
     */
    completeMigration(): this;
    /**
     * The CopySnapshot action makes a copy of an existing snapshot.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - elasticache:AddTagsToResource
     * - s3:DeleteObject
     * - s3:GetBucketAcl
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CopySnapshot.html
     */
    copySnapshot(): this;
    /**
     * The CreateCacheCluster action creates a cache cluster.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     * - elasticache:AddTagsToResource
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheCluster.html
     */
    createCacheCluster(): this;
    /**
     * The CreateCacheParameterGroup action creates a new cache parameter group.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - elasticache:AddTagsToResource
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheParameterGroup.html
     */
    createCacheParameterGroup(): this;
    /**
     * The CreateCacheSecurityGroup action creates a new cache security group.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - elasticache:AddTagsToResource
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSecurityGroup.html
     */
    createCacheSecurityGroup(): this;
    /**
     * The CreateCacheSubnetGroup action creates a new cache subnet group.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - elasticache:AddTagsToResource
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html
     */
    createCacheSubnetGroup(): this;
    /**
     * The CreateGlobalReplicationGroup action creates a global datastore.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateGlobalReplicationGroup.html
     */
    createGlobalReplicationGroup(): this;
    /**
     * The CreateReplicationGroup action creates a replication group.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     * - elasticache:AddTagsToResource
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateReplicationGroup.html
     */
    createReplicationGroup(): this;
    /**
     * The CreateSnapshot action creates a copy of an entire cache cluster at a specific moment in time.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - elasticache:AddTagsToResource
     * - s3:DeleteObject
     * - s3:GetBucketAcl
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateSnapshot.html
     */
    createSnapshot(): this;
    /**
     * The DecreaseNodeGroupsInGlobalReplicationGroup action dec a global datastore.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DecreaseNodeGroupsInGlobalReplicationGroup.html
     */
    decreaseNodeGroupsInGlobalReplicationGroup(): this;
    /**
     * The DecreaseReplicaCount action decreases the number of replicas in a Redis replication group.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DecreaseReplicaCount.html
     */
    decreaseReplicaCount(): this;
    /**
     * The DeleteCacheCluster action deletes a previously provisioned cache cluster.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DeleteCacheCluster.html
     */
    deleteCacheCluster(): this;
    /**
     * The DeleteCacheParameterGroup action deletes the specified cache parameter group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DeleteCacheParameterGroup.html
     */
    deleteCacheParameterGroup(): this;
    /**
     * The DeleteCacheSecurityGroup action deletes a cache security group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DeleteCacheSecurityGroup.html
     */
    deleteCacheSecurityGroup(): this;
    /**
     * The DeleteCacheSubnetGroup action deletes a cache subnet group.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DeleteCacheSubnetGroup.html
     */
    deleteCacheSubnetGroup(): this;
    /**
     * The DeleteGlobalReplicationGroup action deletes a global datastore.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DeleteGlobalReplicationGroup.html
     */
    deleteGlobalReplicationGroup(): this;
    /**
     * The DeleteReplicationGroup action deletes an existing replication group.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DeleteReplicationGroup.html
     */
    deleteReplicationGroup(): this;
    /**
     * The DeleteSnapshot action deletes an existing snapshot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DeleteSnapshot.html
     */
    deleteSnapshot(): this;
    /**
     * The DescribeCacheClusters action returns information about all provisioned cache clusters if no cache cluster identifier is specified, or about a specific cache cluster if a cache cluster identifier is supplied.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeCacheClusters.html
     */
    describeCacheClusters(): this;
    /**
     * The DescribeCacheEngineVersions action returns a list of the available cache engines and their versions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeCacheEngineVersions.html
     */
    describeCacheEngineVersions(): this;
    /**
     * The DescribeCacheParameterGroups action returns information about parameter groups for this account, or a particular parameter group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeCacheParameterGroups.html
     */
    describeCacheParameterGroups(): this;
    /**
     * The DescribeCacheParameters action returns the detailed parameter list for a particular cache parameter group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeCacheParameters.html
     */
    describeCacheParameters(): this;
    /**
     * The DescribeCacheSecurityGroups action returns a list of cache security group descriptions, or the description of the specified security group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeCacheSecurityGroups.html
     */
    describeCacheSecurityGroups(): this;
    /**
     * The DescribeCacheSubnetGroups action returns a list of cache subnet group descriptions, or the description of the specified subnet group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeCacheSubnetGroups.html
     */
    describeCacheSubnetGroups(): this;
    /**
     * The DescribeEngineDefaultParameters action returns the default engine and system parameter information for the specified cache engine.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEngineDefaultParameters.html
     */
    describeEngineDefaultParameters(): this;
    /**
     * The DescribeEvents action returns events related to cache clusters, cache security groups, and cache parameter groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html
     */
    describeEvents(): this;
    /**
     * The DescribeGlobalReplicationGroups action returns information about global datastores for this account, or a particular global datastore.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeGlobalReplicationGroups.html
     */
    describeGlobalReplicationGroups(): this;
    /**
     * The DescribeReplicationGroups action returns information about replication groups for this account, or a particular replication group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeReplicationGroups.html
     */
    describeReplicationGroups(): this;
    /**
     * The DescribeReservedCacheNodes action returns information about reserved cache nodes for this account, or a particular reserved cache node.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeReservedCacheNodes.html
     */
    describeReservedCacheNodes(): this;
    /**
     * The DescribeReservedCacheNodesOfferings action lists available reserved cache node offerings.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeReservedCacheNodesOfferings.html
     */
    describeReservedCacheNodesOfferings(): this;
    /**
     * Returns details of the service updates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeServiceUpdates.html
     */
    describeServiceUpdates(): this;
    /**
     * The DescribeSnapshots action returns information about cache cluster snapshots.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeSnapshots.html
     */
    describeSnapshots(): this;
    /**
     * Returns details of the update actions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeUpdateActions.html
     */
    describeUpdateActions(): this;
    /**
     * The DisassociateGlobalReplicationGroup action removes a secondary Replication Group from the Global Datastore.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DisassociateGlobalReplicationGroup.html
     */
    disassociateGlobalReplicationGroup(): this;
    /**
     * The FailoverGlobalReplicationGroup action removes a secondary Replication Group from the Global Datastore.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_FailoverGlobalReplicationGroup.html
     */
    failoverGlobalReplicationGroup(): this;
    /**
     * The IncreaseNodeGroupsInGlobalReplicationGroup action increases the number of node groups in the Global Datastore.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_IncreaseNodeGroupsInGlobalReplicationGroup.html
     */
    increaseNodeGroupsInGlobalReplicationGroup(): this;
    /**
     * The IncreaseReplicaCount action increases the number of replicas in a Redis replication group.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_IncreaseReplicaCount.html
     */
    increaseReplicaCount(): this;
    /**
     * List Allowed Node Type Modifications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ListAllowedNodeTypeModifications.html
     */
    listAllowedNodeTypeModifications(): this;
    /**
     * The ListTagsForResource action lists all cost allocation tags currently on the named resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ListTagsForResource.html
     */
    listTagsForResource(): this;
    /**
     * The ModifyCacheCluster action modifies the settings for a cache cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheCluster.html
     */
    modifyCacheCluster(): this;
    /**
     * The ModifyCacheParameterGroup action modifies the parameters of a cache parameter group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html
     */
    modifyCacheParameterGroup(): this;
    /**
     * The ModifyCacheSubnetGroup action modifies an existing cache subnet group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheSubnetGroup.html
     */
    modifyCacheSubnetGroup(): this;
    /**
     * The ModifyGlobalReplicationGroup action modifies the settings for a Global Datastore.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyGlobalReplicationGroup.html
     */
    modifyGlobalReplicationGroup(): this;
    /**
     * The ModifyReplicationGroup action modifies the settings for a replication group.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroup.html
     */
    modifyReplicationGroup(): this;
    /**
     * The ModifyReplicationGroupShardConfiguration action allows you to add shards, remove shards, or rebalance the keyspaces among exisiting shards.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroupShardConfiguration.html
     */
    modifyReplicationGroupShardConfiguration(): this;
    /**
     * The PurchaseReservedCacheNodesOffering action allows you to purchase a reserved cache node offering.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - elasticache:AddTagsToResource
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_PurchaseReservedCacheNodesOffering.html
     */
    purchaseReservedCacheNodesOffering(): this;
    /**
     * The RebalanceSlotsInGlobalReplicationGroup action redistributes slots to ensure uniform distribution across existing shards in the cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_RebalanceSlotsInGlobalReplicationGroup.html
     */
    rebalanceSlotsInGlobalReplicationGroup(): this;
    /**
     * The RebootCacheCluster action reboots some, or all, of the cache nodes within a provisioned cache cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_RebootCacheCluster.html
     */
    rebootCacheCluster(): this;
    /**
     * The RemoveTagsFromResource action removes the tags identified by the TagKeys list from the named resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_RemoveTagsFromResource.html
     */
    removeTagsFromResource(): this;
    /**
     * The ResetCacheParameterGroup action modifies the parameters of a cache parameter group to the engine or system default value.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ResetCacheParameterGroup.html
     */
    resetCacheParameterGroup(): this;
    /**
     * The RevokeCacheSecurityGroupIngress action revokes ingress from a cache security group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_RevokeCacheSecurityGroupIngress.html
     */
    revokeCacheSecurityGroupIngress(): this;
    /**
     * Start the migration of data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_StartMigration.html
     */
    startMigration(): this;
    /**
     * The TestFailover action allows you to test automatic failover on a specified node group in a replication group
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_TestFailover.html
     */
    testFailover(): this;
    /**
     * Adds a resource of type parametergroup to the statement
     *
     * @param cacheParameterGroupName - Identifier for the cacheParameterGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onParametergroup(cacheParameterGroupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type securitygroup to the statement
     *
     * @param cacheSecurityGroupName - Identifier for the cacheSecurityGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSecuritygroup(cacheSecurityGroupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type subnetgroup to the statement
     *
     * @param cacheSubnetGroupName - Identifier for the cacheSubnetGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSubnetgroup(cacheSubnetGroupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type replicationgroup to the statement
     *
     * @param replicationGroupId - Identifier for the replicationGroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onReplicationgroup(replicationGroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type cluster to the statement
     *
     * @param cacheClusterId - Identifier for the cacheClusterId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onCluster(cacheClusterId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type reserved-instance to the statement
     *
     * @param reservedCacheNodeId - Identifier for the reservedCacheNodeId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onReservedInstance(reservedCacheNodeId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type snapshot to the statement
     *
     * @param snapshotName - Identifier for the snapshotName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSnapshot(snapshotName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type globalreplicationgroup to the statement
     *
     * @param globalReplicationGroupId - Identifier for the globalReplicationGroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onGlobalreplicationgroup(globalReplicationGroupId: string, account?: string, partition?: string): this;
}
