import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [macie](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmacieclassic.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Macie extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    protected resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [macie](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmacieclassic.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Enables the user to associate a specified AWS account with Amazon Macie as a member account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_AssociateMemberAccount.html
     */
    associateMemberAccount(): this;
    /**
     * Enables the user to associate specified S3 resources with Amazon Macie for monitoring and data classification.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsSourceArn()
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_AssociateS3Resources.html
     */
    associateS3Resources(): this;
    /**
     * Enables the user to remove the specified member account from Amazon Macie.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_DisassociateMemberAccount.html
     */
    disassociateMemberAccount(): this;
    /**
     * Enables the user to remove specified S3 resources from being monitored by Amazon Macie.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsSourceArn()
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_DisassociateS3Resources.html
     */
    disassociateS3Resources(): this;
    /**
     * Enables the user to list all Amazon Macie member accounts for the current Macie master account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_ListMemberAccounts.html
     */
    listMemberAccounts(): this;
    /**
     * Enables the user to list all the S3 resources associated with Amazon Macie.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_ListS3Resources.html
     */
    listS3Resources(): this;
    /**
     * Enables the user to update the classification types for the specified S3 resources.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsSourceArn()
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_UpdateS3Resources.html
     */
    updateS3Resources(): this;
    /**
     * Allow access to the specified actions only when the request operates on the specified aws resource
     *
     * Applies to actions:
     * - .associateS3Resources()
     * - .disassociateS3Resources()
     * - .updateS3Resources()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnEquals`
     */
    ifAwsSourceArn(value: string | string[], operator?: string): this;
}
