"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Discovery = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [discovery](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationdiscovery.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Discovery extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [discovery](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationdiscovery.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'discovery';
        this.actionList = {
            "AssociateConfigurationItemsToApplication": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_AssociateConfigurationItemsToApplication.html",
                "description": "Associates one or more configuration items with an application.",
                "accessLevel": "Write"
            },
            "BatchDeleteImportData": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_BatchDeleteImportData.html",
                "description": "Deletes one or more Migration Hub import tasks, each identified by their import ID. Each import task has a number of records, which can identify servers or applications.",
                "accessLevel": "Write"
            },
            "CreateApplication": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateApplication.html",
                "description": "Creates an application with the given name and description.",
                "accessLevel": "Write"
            },
            "CreateTags": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateTags.html",
                "description": "Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.",
                "accessLevel": "Tagging"
            },
            "DeleteApplications": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteApplications.html",
                "description": "Deletes a list of applications and their associations with configuration items.",
                "accessLevel": "Write"
            },
            "DeleteTags": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteTags.html",
                "description": "Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.",
                "accessLevel": "Tagging"
            },
            "DescribeAgents": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeAgents.html",
                "description": "Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if you did not specify an ID.",
                "accessLevel": "Read"
            },
            "DescribeConfigurations": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeConfigurations.html",
                "description": "Retrieves attributes for a list of configuration item IDs. All of the supplied IDs must be for the same asset type (server, application, process, or connection). Output fields are specific to the asset type selected. For example, the output for a server configuration item includes a list of attributes about the server, such as host name, operating system, and number of network cards.",
                "accessLevel": "Read"
            },
            "DescribeContinuousExports": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeContinuousExports.html",
                "description": "Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you call DescribeContinuousExports as is without passing any parameters.",
                "accessLevel": "Read"
            },
            "DescribeExportConfigurations": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportConfigurations.html",
                "description": "Retrieves the status of a given export process. You can retrieve status from a maximum of 100 processes.",
                "accessLevel": "Read"
            },
            "DescribeExportTasks": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html",
                "description": "Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.",
                "accessLevel": "Read"
            },
            "DescribeImportTasks": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeImportTasks.html",
                "description": "Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.",
                "accessLevel": "List"
            },
            "DescribeTags": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeTags.html",
                "description": "Retrieves a list of configuration items that are tagged with a specific tag. Or retrieves a list of all tags assigned to a specific configuration item.",
                "accessLevel": "Read"
            },
            "DisassociateConfigurationItemsFromApplication": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DisassociateConfigurationItemsFromApplication.html",
                "description": "Disassociates one or more configuration items from an application.",
                "accessLevel": "Write"
            },
            "ExportConfigurations": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportConfigurations.html",
                "description": "Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance.",
                "accessLevel": "Write"
            },
            "GetDiscoverySummary": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_GetDiscoverySummary.html",
                "description": "Retrieves a short summary of discovered assets.",
                "accessLevel": "Read"
            },
            "ListConfigurations": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListConfigurations.html",
                "description": "Retrieves a list of configuration items according to criteria you specify in a filter. The filter criteria identify relationship requirements.",
                "accessLevel": "List"
            },
            "ListServerNeighbors": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListServerNeighbors.html",
                "description": "Retrieves a list of servers which are one network hop away from a specified server.",
                "accessLevel": "List"
            },
            "StartContinuousExport": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartContinuousExport.html",
                "description": "Start the continuous flow of agent's discovered data into Amazon Athena.",
                "accessLevel": "Write"
            },
            "StartDataCollectionByAgentIds": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartDataCollectionByAgentIds.html",
                "description": "Instructs the specified agents or Connectors to start collecting data.",
                "accessLevel": "Write"
            },
            "StartExportTask": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html",
                "description": "Export the configuration data about discovered configuration items and relationships to an S3 bucket in a specified format.",
                "accessLevel": "Write"
            },
            "StartImportTask": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartImportTask.html",
                "description": "Starts an import task. The Migration Hub import feature allows you to import details of your on-premises environment directly into AWS without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data including the ability to group your devices as applications and track their migration status.",
                "accessLevel": "Write"
            },
            "StopContinuousExport": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopContinuousExport.html",
                "description": "Stop the continuous flow of agent's discovered data into Amazon Athena.",
                "accessLevel": "Write"
            },
            "StopDataCollectionByAgentIds": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopDataCollectionByAgentIds.html",
                "description": "Instructs the specified agents or Connectors to stop collecting data.",
                "accessLevel": "Write"
            },
            "UpdateApplication": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_UpdateApplication.html",
                "description": "Updates metadata about an application.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Associates one or more configuration items with an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_AssociateConfigurationItemsToApplication.html
     */
    associateConfigurationItemsToApplication() {
        this.add('discovery:AssociateConfigurationItemsToApplication');
        return this;
    }
    /**
     * Deletes one or more Migration Hub import tasks, each identified by their import ID. Each import task has a number of records, which can identify servers or applications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_BatchDeleteImportData.html
     */
    batchDeleteImportData() {
        this.add('discovery:BatchDeleteImportData');
        return this;
    }
    /**
     * Creates an application with the given name and description.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateApplication.html
     */
    createApplication() {
        this.add('discovery:CreateApplication');
        return this;
    }
    /**
     * Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateTags.html
     */
    createTags() {
        this.add('discovery:CreateTags');
        return this;
    }
    /**
     * Deletes a list of applications and their associations with configuration items.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteApplications.html
     */
    deleteApplications() {
        this.add('discovery:DeleteApplications');
        return this;
    }
    /**
     * Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteTags.html
     */
    deleteTags() {
        this.add('discovery:DeleteTags');
        return this;
    }
    /**
     * Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if you did not specify an ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeAgents.html
     */
    describeAgents() {
        this.add('discovery:DescribeAgents');
        return this;
    }
    /**
     * Retrieves attributes for a list of configuration item IDs. All of the supplied IDs must be for the same asset type (server, application, process, or connection). Output fields are specific to the asset type selected. For example, the output for a server configuration item includes a list of attributes about the server, such as host name, operating system, and number of network cards.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeConfigurations.html
     */
    describeConfigurations() {
        this.add('discovery:DescribeConfigurations');
        return this;
    }
    /**
     * Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you call DescribeContinuousExports as is without passing any parameters.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeContinuousExports.html
     */
    describeContinuousExports() {
        this.add('discovery:DescribeContinuousExports');
        return this;
    }
    /**
     * Retrieves the status of a given export process. You can retrieve status from a maximum of 100 processes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportConfigurations.html
     */
    describeExportConfigurations() {
        this.add('discovery:DescribeExportConfigurations');
        return this;
    }
    /**
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html
     */
    describeExportTasks() {
        this.add('discovery:DescribeExportTasks');
        return this;
    }
    /**
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeImportTasks.html
     */
    describeImportTasks() {
        this.add('discovery:DescribeImportTasks');
        return this;
    }
    /**
     * Retrieves a list of configuration items that are tagged with a specific tag. Or retrieves a list of all tags assigned to a specific configuration item.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeTags.html
     */
    describeTags() {
        this.add('discovery:DescribeTags');
        return this;
    }
    /**
     * Disassociates one or more configuration items from an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DisassociateConfigurationItemsFromApplication.html
     */
    disassociateConfigurationItemsFromApplication() {
        this.add('discovery:DisassociateConfigurationItemsFromApplication');
        return this;
    }
    /**
     * Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportConfigurations.html
     */
    exportConfigurations() {
        this.add('discovery:ExportConfigurations');
        return this;
    }
    /**
     * Retrieves a short summary of discovered assets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_GetDiscoverySummary.html
     */
    getDiscoverySummary() {
        this.add('discovery:GetDiscoverySummary');
        return this;
    }
    /**
     * Retrieves a list of configuration items according to criteria you specify in a filter. The filter criteria identify relationship requirements.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListConfigurations.html
     */
    listConfigurations() {
        this.add('discovery:ListConfigurations');
        return this;
    }
    /**
     * Retrieves a list of servers which are one network hop away from a specified server.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListServerNeighbors.html
     */
    listServerNeighbors() {
        this.add('discovery:ListServerNeighbors');
        return this;
    }
    /**
     * Start the continuous flow of agent's discovered data into Amazon Athena.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartContinuousExport.html
     */
    startContinuousExport() {
        this.add('discovery:StartContinuousExport');
        return this;
    }
    /**
     * Instructs the specified agents or Connectors to start collecting data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartDataCollectionByAgentIds.html
     */
    startDataCollectionByAgentIds() {
        this.add('discovery:StartDataCollectionByAgentIds');
        return this;
    }
    /**
     * Export the configuration data about discovered configuration items and relationships to an S3 bucket in a specified format.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html
     */
    startExportTask() {
        this.add('discovery:StartExportTask');
        return this;
    }
    /**
     * Starts an import task. The Migration Hub import feature allows you to import details of your on-premises environment directly into AWS without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data including the ability to group your devices as applications and track their migration status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartImportTask.html
     */
    startImportTask() {
        this.add('discovery:StartImportTask');
        return this;
    }
    /**
     * Stop the continuous flow of agent's discovered data into Amazon Athena.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopContinuousExport.html
     */
    stopContinuousExport() {
        this.add('discovery:StopContinuousExport');
        return this;
    }
    /**
     * Instructs the specified agents or Connectors to stop collecting data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopDataCollectionByAgentIds.html
     */
    stopDataCollectionByAgentIds() {
        this.add('discovery:StopDataCollectionByAgentIds');
        return this;
    }
    /**
     * Updates metadata about an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_UpdateApplication.html
     */
    updateApplication() {
        this.add('discovery:UpdateApplication');
        return this;
    }
}
exports.Discovery = Discovery;
//# sourceMappingURL=data:application/json;base64,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